/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DpChildrenData;
import com.farm.bean.DpData;
import com.farm.bean.DpDataBo;
import com.farm.bean.DpDataExport;
import com.farm.bean.vo.DpDataVo;
import com.farm.mapper.DpDataMapper;
import com.farm.service.DpDataService;
import com.farm.util.ResultVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DpDataServiceImpl
implements DpDataService {
    @Value(value="${branch}")
    private String branch;
    @Resource
    private DpDataMapper dpDataMapper;

    public Integer saveData(DpDataBo dpDataBo) {
        DpData dpData = (DpData)BeanUtil.toBean((Object)dpDataBo, DpData.class);
        if (dpDataBo.getBusinessId() == null) {
            if (dpDataBo.getType() == 0) {
                this.dpDataMapper.saveData(dpData);
            } else {
                String uuid;
                this.dpDataMapper.saveData(dpData);
                if (dpData.getJsonData().getString("uuid") == null || dpData.getJsonData().getString("uuid").isEmpty()) {
                    uuid = IdUtil.simpleUUID();
                    dpData.getJsonData().put("uuid", (Object)uuid);
                } else {
                    uuid = dpData.getJsonData().getString("uuid");
                }
                if (dpData.getId() == null) {
                    dpData.setId(this.dpDataMapper.queryId(dpData.getTypeCode()));
                }
                this.dpDataMapper.saveDataList(uuid, dpData.getId(), JSONObject.toJSONString((Object)dpData.getJsonData()), dpData.getJsonData().getString("title"), dpData.getJsonData().getString("sort"), dpData.getJsonData().getString("time"), dpData.getJsonData().getString("year"));
            }
        } else {
            this.dpDataMapper.saveNodeData(dpData);
        }
        return 1;
    }

    public JSONObject queryDataByTypeCode(Integer typeCode, String businessId, Integer type, String title, Integer sort, String startTime, String endTime, String year, String month, Integer pageNum, Integer pageSize, Integer dateType, String date) {
        JSONObject json = new JSONObject();
        if (businessId == null || businessId.isEmpty() && type == 0) {
            DpDataVo dpDataVo = this.dpDataMapper.queryDataByTypeCodeAndTime(typeCode, null, null);
            if (typeCode == 60003) {
                List hsl = this.dpDataMapper.queryListByWaring(Integer.valueOf(60001), dateType, date);
                List czl = this.dpDataMapper.queryListByWaring(Integer.valueOf(60002), dateType, date);
                AtomicReference<Double> sum = new AtomicReference<Double>(0.0);
                AtomicReference<Double> czlSum = new AtomicReference<Double>(0.0);
                if (czl != null && hsl != null) {
                    hsl.forEach(item -> {
                        Double h = item.getData().getDouble("h");
                        sum.updateAndGet(v -> v + h);
                    });
                    czl.forEach(item -> {
                        Double h = item.getData().getDouble("h");
                        czlSum.updateAndGet(v -> v + h);
                    });
                }
                JSONObject data = new JSONObject();
                if (dpDataVo != null && dpDataVo.getData() != null) {
                    data = dpDataVo.getData();
                }
                Double ndrwl = data.getDouble("ndrwl") == null ? 0.0 : data.getDouble("ndrwl");
                data.put("hsliang", (Object)String.format("%.2f", sum.get()));
                data.put("czliang", (Object)String.format("%.2f", czlSum.get()));
                data.put("hsl", ndrwl == 0.0 ? Integer.valueOf(0) : String.format("%.2f", sum.get() / ndrwl * 100.0));
                data.put("czl", sum.get() == 0.0 ? Integer.valueOf(0) : String.format("%.2f", czlSum.get() / sum.get() * 100.0));
            }
            json.put("data", (Object)dpDataVo);
        } else if (type != null) {
            Integer start = null;
            if (pageNum != null && pageSize != null && pageNum != null && pageNum != null) {
                start = (pageNum - 1) * pageSize;
            }
            List data = this.dpDataMapper.queryList(typeCode, title, sort, startTime, endTime, year, month, start, pageSize, dateType, date);
            if (start != null && pageSize != null) {
                json.put("count", (Object)this.dpDataMapper.queryListCount(typeCode, title, sort, startTime, endTime, year, month, dateType, date));
            }
            json.put("data", (Object)data);
        } else {
            DpDataVo dpDataVo = this.dpDataMapper.queryDataNodeByBusinessId(typeCode, businessId);
            if (dpDataVo == null) {
                dpDataVo = new DpDataVo();
                JSONObject json1 = new JSONObject();
                json1.put("list", new ArrayList());
                dpDataVo.setDataJson(json);
                json.put("data", (Object)dpDataVo);
            }
        }
        return json;
    }

    public Integer delData(String uuids) {
        return this.dpDataMapper.delData(uuids);
    }

    public Integer delDataByCode(String code) {
        return this.dpDataMapper.delDataByCode(code);
    }

    public Integer saveParentData(DpData dpData) {
        return this.dpDataMapper.saveParentData(dpData);
    }

    public Integer saveChildrenData(List<DpChildrenData> list) {
        return this.dpDataMapper.saveChildrenData(list);
    }

    public DpDataExport selectExportData(String typeCode) {
        return this.dpDataMapper.selectExportData(typeCode);
    }

    public ResultVo getHomeData(Integer dateType, String date) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Long dataCount = 0L;
        dataCount = StringUtils.equals((CharSequence)this.branch, (CharSequence)"prod") ? this.dpDataMapper.queryAllDataCount("lyywzz") : this.dpDataMapper.queryAllDataCount("db_farm_ly");
        Integer num1 = this.dpDataMapper.getFLHomeData(dateType, date);
        map.put("fl", num1);
        Integer num2 = this.dpDataMapper.getCQHomeData(dateType, date);
        map.put("cq", num2);
        Integer num3 = this.dpDataMapper.getSFHomeData(dateType, date);
        map.put("sf", num3);
        Integer num4 = this.dpDataMapper.getNCHomeData(dateType, date);
        map.put("nc", num4);
        Integer num5 = this.dpDataMapper.getNJHomeData(dateType, date);
        map.put("nj", num5);
        Integer num6 = this.dpDataMapper.getFQHomeData(dateType, date);
        map.put("fq", num6);
        Integer num7 = this.dpDataMapper.getSNHomeData(dateType, date);
        map.put("sn", num7);
        Integer num8 = this.dpDataMapper.getYHHomeData(dateType, date);
        map.put("yh", num8);
        Long num9 = dataCount - (long)num1.intValue() - (long)num2.intValue() - (long)num3.intValue() - (long)num4.intValue() - (long)num5.intValue() - (long)num6.intValue() - (long)num7.intValue() - (long)num8.intValue();
        map.put("qt", Math.toIntExact(num9));
        return ResultVo.success(map);
    }
}

