/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FieldAutoAudit;
import com.farm.bean.resultMap.FieldDSMapPlus;
import com.farm.mapper.FieldAutoAuditMapper;
import com.farm.mapper.RegionStatusAreaMapper;
import com.farm.service.ConfigService;
import com.farm.service.FieldAutoAuditService;
import com.farm.service.FieldDoubleStatusService;
import com.farm.service.SmsService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="fieldAutoAuditService")
public class FieldAutoAuditServiceImpl
implements FieldAutoAuditService {
    @Resource
    private FieldAutoAuditMapper fieldAutoAuditMapper;
    @Autowired
    private ConfigService configService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RegionStatusAreaMapper regionStatusAreaMapper;
    @Autowired
    private SmsService smsService;
    @Autowired
    private FieldDoubleStatusService fieldDoubleStatusService;

    public List<FieldAutoAudit> queryAllByRegionCode(FieldAutoAudit fieldAutoAudit) {
        List list = this.fieldAutoAuditMapper.queryAll(fieldAutoAudit);
        for (FieldAutoAudit audit : list) {
            audit.setRegionName(this.configService.queryRegionName(fieldAutoAudit.getRegionCode()));
        }
        return list;
    }

    public FieldAutoAudit insert(FieldAutoAudit fieldAutoAudit) {
        this.fieldAutoAuditMapper.insert(fieldAutoAudit);
        return fieldAutoAudit;
    }

    public FieldAutoAudit update(FieldAutoAudit fieldAutoAudit) {
        this.fieldAutoAuditMapper.update(fieldAutoAudit);
        return fieldAutoAudit;
    }

    @Transactional
    public void autoAuditStatusList(String regionCode) {
        this.fieldAutoAuditMapper.updateHistoryAuditFlag(regionCode);
        this.fieldAutoAuditMapper.updateHistoryLogAuditFlag(regionCode);
        this.fieldDoubleStatusService.syncFieldStatusHistoryLog(regionCode, "/ly/field/auto-audit");
        Criteria criteria0 = Criteria.where((String)"region_code").regex(regionCode + ".*").and("auditFlag").is((Object)2);
        Update update0 = Update.update((String)"auditFlag", (Object)1);
        this.mongoTemplate.updateMulti(Query.query((CriteriaDefinition)criteria0), update0, JSONObject.class, "t_field_double_status");
    }

    public Integer calFinalAuditFlagByTown(String regionCode, Integer status) {
        Integer auditFlag;
        if (Arrays.asList(1, 2, 3).contains(status)) {
            Boolean townIdenAutoFlag = this.fieldAutoAuditMapper.queryAutoFlagByRegionAndType(regionCode, 1);
            auditFlag = townIdenAutoFlag != null && townIdenAutoFlag.booleanValue() ? Integer.valueOf(4) : Integer.valueOf(2);
        } else if (Arrays.asList(10, 11, 12).contains(status)) {
            Boolean townFixAutoFlag = this.fieldAutoAuditMapper.queryAutoFlagByRegionAndType(regionCode, 2);
            Boolean cityFixAutoFlag = this.fieldAutoAuditMapper.queryAutoFlagByRegionAndType(regionCode.substring(0, 6), 2);
            if (townFixAutoFlag == null) {
                townFixAutoFlag = false;
            }
            if (cityFixAutoFlag == null) {
                cityFixAutoFlag = false;
            }
            auditFlag = cityFixAutoFlag.booleanValue() && townFixAutoFlag.booleanValue() ? Integer.valueOf(1) : (townFixAutoFlag.booleanValue() ? Integer.valueOf(4) : Integer.valueOf(2));
        } else {
            auditFlag = 2;
        }
        return auditFlag;
    }

    public void sendAlIdenFieldMsg() {
        List list = this.regionStatusAreaMapper.queryGridLeaderMsgList();
        for (FieldDSMapPlus ds : list) {
            this.smsService.sendAlIdenFieldMsg(ds.getIdenCount(), ds.getPhone(), ds.getRegionCode());
        }
    }
}

