/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DoubleLabelResultMap;
import com.farm.bean.FieldAreaResultMap;
import com.farm.bean.FieldDoubleHistory;
import com.farm.bean.FieldDoubleHistoryLog;
import com.farm.bean.FieldDoubleHistoryPic;
import com.farm.bean.FieldDoubleStatistics;
import com.farm.bean.FieldDoubleStatisticsNew;
import com.farm.bean.FieldDoubleStatus;
import com.farm.bean.FieldGridRecord;
import com.farm.bean.LabelResultMap;
import com.farm.bean.LytUser;
import com.farm.bean.resultMap.FunctionAreaResultMap;
import com.farm.bean.resultMap.ValListResultMap;
import com.farm.bean.vo.AreaTypeVo;
import com.farm.bean.vo.DpDataTempVo;
import com.farm.mapper.FieldAutoAuditMapper;
import com.farm.mapper.FieldDoubleHistoryMapper;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.mapper.FieldGridRecordMapper;
import com.farm.mapper.FieldSpecialLandMapper;
import com.farm.mapper.WarningMapper;
import com.farm.service.ConfigService;
import com.farm.service.FieldAutoAuditService;
import com.farm.service.FieldDoubleStatusService;
import com.farm.service.LytUserService;
import com.farm.service.SmsService;
import com.farm.util.HttpSendUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="fieldDoubleStatusService")
public class FieldDoubleStatusServiceImpl
implements FieldDoubleStatusService {
    private static final Logger log = LoggerFactory.getLogger(FieldDoubleStatusServiceImpl.class);
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private FieldSpecialLandMapper fieldSpecialLandMapper;
    @Autowired
    private FieldDoubleHistoryMapper fieldDoubleHistoryMapper;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ConfigService configService;
    @Autowired
    private LytUserService lytUserService;
    @Autowired
    private FieldGridRecordMapper fieldGridRecordMapper;
    @Autowired
    private FieldAutoAuditMapper fieldAutoAuditMapper;
    @Autowired
    private FieldAutoAuditService fieldAutoAuditService;
    @Resource
    private WarningMapper warningMapper;
    @Value(value="${farm.companyId}")
    private Integer companyId;
    @Autowired
    private SmsService smsService;
    @Value(value="${farm.datasync}")
    private String datasyncUrl;
    @Value(value="${lyt.config.roleP0}")
    private String roleP0;
    @Value(value="${lyt.config.roleP1}")
    private String roleP1;
    @Value(value="${lyt.config.roleP2}")
    private String roleP2;

    public JSONObject queryById(Integer id) {
        List listp0 = Arrays.asList(this.roleP0.split(",")).stream().mapToInt(num -> Integer.parseInt(num)).boxed().collect(Collectors.toList());
        List listp1 = Arrays.asList(this.roleP1.split(",")).stream().mapToInt(num -> Integer.parseInt(num)).boxed().collect(Collectors.toList());
        List listp2 = Arrays.asList(this.roleP2.split(",")).stream().mapToInt(num -> Integer.parseInt(num)).boxed().collect(Collectors.toList());
        JSONObject json = new JSONObject();
        FieldDoubleStatus dto = this.fieldDoubleStatusMapper.queryById(id);
        dto.setImg("http://imgs.shuxitech.com/farm/field_img/" + dto.getImg());
        json.put("fieldInfo", (Object)dto);
        FieldDoubleHistoryPic rectifyImgList = this.fieldDoubleHistoryMapper.queryFieldRectifyImg(id, dto.getHistoryId());
        json.put("rectifyImg", (Object)rectifyImgList);
        String parentCode = this.fieldDoubleStatusMapper.queryParentCodeByRegionCode(dto.getRegionCode());
        List villageUserList = this.lytUserService.queryHeadUserListByFieldStatusId(parentCode, (Integer)listp2.get(listp2.size() - 1));
        json.put("villageNameList", (Object)villageUserList.stream().map(LytUser::getUserName).collect(Collectors.joining(",")));
        parentCode = this.fieldDoubleStatusMapper.queryParentCodeByRegionCode(parentCode);
        List townUserList = this.lytUserService.queryHeadUserListByRoleId(parentCode, Integer.valueOf(777777));
        json.put("townNameList", (Object)townUserList.stream().map(LytUser::getUserName).collect(Collectors.joining(",")));
        json.put("townPhoneList", (Object)townUserList.stream().map(LytUser::getMobile).collect(Collectors.joining(",")));
        parentCode = this.fieldDoubleStatusMapper.queryParentCodeByRegionCode(parentCode);
        List countyUserList = this.lytUserService.queryHeadUserListByRoleId(parentCode, Integer.valueOf(1549398233));
        json.put("countyNameList", (Object)countyUserList.stream().map(LytUser::getUserName).collect(Collectors.joining(",")));
        FieldDoubleHistory identifyInfo = this.fieldDoubleStatusMapper.queryRecentStatusById(id);
        json.put("identifyInfo", (Object)identifyInfo);
        List logList = this.fieldDoubleHistoryMapper.queryStatusLogListById(identifyInfo.getHistoryId());
        json.put("logList", (Object)logList);
        return json;
    }

    @Transactional
    public void uploadImgToFieldHistoryLog(FieldDoubleHistoryPic fieldDoubleHistoryPic) {
        FieldDoubleHistoryPic item = this.fieldDoubleHistoryMapper.queryFieldRectifyImg(fieldDoubleHistoryPic.getFieldId(), fieldDoubleHistoryPic.getHistoryId());
        if (item != null) {
            this.fieldDoubleHistoryMapper.updateFieldRectifyImg(fieldDoubleHistoryPic);
        } else {
            this.fieldDoubleHistoryMapper.insertFieldRectifyImg(fieldDoubleHistoryPic);
        }
    }

    public FieldDoubleHistoryPic queryFieldRectifyImg(Integer fieldId, Integer historyId) {
        return this.fieldDoubleHistoryMapper.queryFieldRectifyImg(fieldId, historyId);
    }

    public FieldDoubleStatus insert(FieldDoubleStatus fieldDoubleStatus) {
        this.fieldDoubleStatusMapper.insert(fieldDoubleStatus);
        return fieldDoubleStatus;
    }

    public FieldDoubleStatus update(FieldDoubleStatus fieldDoubleStatus) {
        this.fieldDoubleStatusMapper.update(fieldDoubleStatus);
        return this.fieldDoubleStatusMapper.queryById(fieldDoubleStatus.getId());
    }

    public void removeByIds(List<Integer> idList) {
        Integer i = 0;
        while (i < idList.size()) {
            this.fieldDoubleStatusMapper.deleteById(idList.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public JSONObject queryListByCompanyId(Integer companyId, Integer page, Integer pageSize, List<Integer> typeList, String regionCode, String areaType, List<Integer> statusTypeList) {
        List resultList = new ArrayList();
        JSONObject json = new JSONObject();
        if (typeList.size() == 0 && statusTypeList.size() < 1) {
            json.put("list", resultList);
            return json;
        }
        resultList = this.fieldDoubleStatusMapper.queryListByCompanyId(companyId, page, pageSize, typeList, regionCode, areaType, statusTypeList);
        json.put("list", resultList);
        return json;
    }

    public JSONObject queryDoubleUserFieldList(Integer companyId, Integer start, Integer pageSize, String userId, Integer type, String search) {
        JSONObject json = new JSONObject();
        Set recodeList = this.lytUserService.queryUserRegionList(userId);
        List<Object> typeList = new ArrayList();
        if (type == 0) {
            typeList = Arrays.asList(1, 2, 3);
        } else if (type == 1) {
            typeList = Arrays.asList(4, 5, 6);
        } else if (type == 2) {
            typeList = Arrays.asList(7, 8, 9);
        } else if (type == 3) {
            typeList = Arrays.asList(10, 11, 12);
        }
        List list = this.fieldDoubleStatusMapper.queryDoubleUserFieldList(start, pageSize, companyId, userId, typeList, recodeList, search);
        for (FieldDoubleStatus dto : list) {
            dto.setImg("http://imgs.shuxitech.com/farm/field_img/" + dto.getImg());
        }
        Integer count = this.fieldDoubleStatusMapper.queryCountByCompanyId(companyId, userId, typeList, recodeList, search);
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    @Transactional
    public void postDoubleField(FieldDoubleHistoryLog log) {
        FieldDoubleStatus now = this.fieldDoubleStatusMapper.queryById(log.getStatusId());
        Integer lastStatus = now.getStatus();
        Integer nowStatus = log.getStatus();
        List<Integer> statusList = Arrays.asList(1, 2, 3, 10, 11, 12, 0);
        if (!statusList.contains(nowStatus)) {
            return;
        }
        Integer auditFlag = 2;
        String tempRegionCode = now.getRegionCode();
        String regionCode = String.format("%s,%s,%s,%s", tempRegionCode, tempRegionCode.substring(0, 12), tempRegionCode.substring(0, 9), tempRegionCode.substring(0, 6));
        List autoAuditFlagList = this.fieldAutoAuditMapper.queryAutoAuditByRegionCode(regionCode);
        List collect = autoAuditFlagList.stream().filter(flag -> flag == 1).collect(Collectors.toList());
        if (collect.size() > 0) {
            auditFlag = 1;
        }
        FieldDoubleStatus fieldDoubleStatus = new FieldDoubleStatus();
        fieldDoubleStatus.setId(log.getStatusId());
        Integer identifyStatus = log.getIdentifyStatus();
        Integer status = nowStatus;
        if (identifyStatus == 1) {
            if (Arrays.asList(1, 2, 3).contains(status)) {
                status = status + 3;
                this.fieldDoubleStatusMapper.updateIdenDate(log.getStatusId());
            } else if (Arrays.asList(10, 11, 12).contains(status)) {
                status = status - 3;
                this.fieldDoubleStatusMapper.updateFixDate(log.getStatusId());
            }
        } else if (Arrays.asList(1, 2, 3).contains(status)) {
            status = 0;
            this.fieldDoubleStatusMapper.updateIdenDate(log.getStatusId());
        }
        fieldDoubleStatus.setStatus(status);
        fieldDoubleStatus.setType(log.getType());
        this.fieldDoubleStatusMapper.update(fieldDoubleStatus);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)fieldDoubleStatus.getId());
        jsonObject.put("status", (Object)status);
        jsonObject.put("type", (Object)fieldDoubleStatus.getType());
        if (log.getStatus() == 0) {
            this.fieldDoubleStatusMapper.updateFieldDoubleAreaNormal(now.getArea(), now.getRegionCode(), now.getAreaType());
        } else {
            this.fieldDoubleStatusMapper.updateFieldDoubleAreaAccept(now.getArea(), now.getRegionCode(), now.getAreaType());
        }
        String date = this.fieldDoubleHistoryMapper.queryDetailDate(now.getHistoryId());
        try {
            if (fieldDoubleStatus.getType() == 1) {
                this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "turf_amount", "0", date);
                if (log.getStatus() != 0) {
                    this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "turf_amount", "2", date);
                }
            }
            if (fieldDoubleStatus.getType() == 2) {
                this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "aquatic_amount", "0", date);
                if (log.getStatus() != 0) {
                    this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "aquatic_amount", "2", date);
                }
            }
            if (fieldDoubleStatus.getType() == 3) {
                this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "architecture_amount", "0", date);
                if (log.getStatus() != 0) {
                    this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "architecture_amount", "2", date);
                }
            }
            if (fieldDoubleStatus.getType() == 4) {
                this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "cash_crops_amount", "0", date);
                if (log.getStatus() != 0) {
                    this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "cash_crops_amount", "2", date);
                }
            }
            if (fieldDoubleStatus.getType() == 6) {
                if (log.getStatus() != 0) {
                    this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "wasteland_amount", "0", date);
                }
                this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "wasteland_amount", "2", date);
            }
            if (fieldDoubleStatus.getType() == 7) {
                if (log.getStatus() != 0) {
                    this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "wasteland_amount", "0", date);
                }
                this.fieldSpecialLandMapper.updateFieldAreaAuditPost(now.getArea(), now.getRegionCode(), "wasteland_amount", "2", date);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.setStatus(lastStatus);
        log.setHistoryId(now.getHistoryId());
        log.setAuditFlag(auditFlag);
        this.fieldDoubleHistoryMapper.insertHistoryLog(log);
        Criteria criteria = Criteria.where((String)"field_double_status_id").is((Object)fieldDoubleStatus.getId());
        Update update = Update.update((String)"status", (Object)status);
        update.set("type", (Object)log.getType());
        update.set("auditFlag", (Object)auditFlag);
        this.mongoTemplate.upsert(Query.query((CriteriaDefinition)criteria), update, JSONObject.class, "t_field_double_status");
        FieldDoubleHistory history = new FieldDoubleHistory();
        history.setId(now.getHistoryId());
        history.setStatus(status);
        history.setIdentifyStatus(log.getIdentifyStatus());
        history.setDutyMan(log.getDutyMan());
        history.setDutyPhone(log.getDutyPhone());
        history.setType(log.getType());
        history.setJyfMc(log.getJyfMc());
        history.setJyfPhone(log.getJyfPhone());
        history.setCropName(log.getCropName());
        history.setActualDutyMan(log.getActualDutyMan());
        history.setAuditFlag(auditFlag);
        this.fieldDoubleHistoryMapper.update(history);
        JSONObject historyJson = new JSONObject();
        historyJson.put("id", (Object)history.getId());
        historyJson.put("auditFlag", (Object)auditFlag);
        this.syncFieldStatusHistoryLog(historyJson.toJSONString(), "/ly/field/double-log/update");
        this.warningMapper.updWarningStatus(Integer.valueOf(auditFlag == 2 ? 1 : 2), date, now.getId());
    }

    public JSONObject queryGridUserList(Integer companyId, Integer start, Integer pageSize, String regionCode) {
        JSONObject json = new JSONObject();
        List list = this.fieldDoubleStatusMapper.queryGridUserList(companyId, start, pageSize, regionCode);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryFieldSummary(Integer companyId, String regionCode, Integer areaType) {
        List recodeList = this.configService.queryDownRegions(regionCode);
        List list = this.fieldDoubleStatusMapper.queryFieldSummary(companyId, regionCode, areaType);
        List doubleLabelResultMaps = this.fieldDoubleStatusMapper.queryFuncAndStatusDetailList(regionCode, 0);
        double areaSum = doubleLabelResultMaps.stream().filter(doubleLabelResultMap -> doubleLabelResultMap != null && doubleLabelResultMap.getArea() != null).mapToDouble(DoubleLabelResultMap::getArea).sum();
        String updateDate = this.fieldDoubleStatusMapper.queryMaxTime(companyId, recodeList);
        Integer count = 0;
        LabelResultMap it = new LabelResultMap();
        LinkedHashMap<Integer, String[]> map = new LinkedHashMap<Integer, String[]>();
        map.put(0, new String[]{"\u6b63\u5e38", ""});
        map.put(1, new String[]{"\u7591\u4f3c\u975e\u519c", "#ffa71c"});
        map.put(4, new String[]{"\u5df2\u786e\u8ba4\u975e\u519c", "#E1E100"});
        map.put(7, new String[]{"\u5df2\u6574\u6539\u975e\u519c", "#8080C0"});
        map.put(10, new String[]{"\u6574\u6539\u4e2d\u975e\u519c", "#9AFF02"});
        map.put(2, new String[]{"\u7591\u4f3c\u975e\u7cae", "#f44336"});
        map.put(5, new String[]{"\u5df2\u786e\u8ba4\u975e\u7cae", "#B766AD"});
        map.put(8, new String[]{"\u5df2\u6574\u6539\u975e\u7cae", "#743A3A"});
        map.put(11, new String[]{"\u6574\u6539\u4e2d\u975e\u7cae", "#9AFF02"});
        map.put(3, new String[]{"\u7591\u4f3c\u629b\u8352", "#fff100"});
        map.put(6, new String[]{"\u5df2\u786e\u8ba4\u629b\u8352", "#808040"});
        map.put(9, new String[]{"\u5df2\u6574\u6539\u629b\u8352", "#9AFF02"});
        map.put(12, new String[]{"\u6574\u6539\u4e2d\u629b\u8352", "#9AFF02"});
        LinkedList<FieldAreaResultMap> arealist = new LinkedList<FieldAreaResultMap>();
        for (int i = 0; i < list.size(); ++i) {
            FieldAreaResultMap areaAmount;
            FieldAreaResultMap fixedArea;
            FieldAreaResultMap fixingArea;
            FieldAreaResultMap confirmArea;
            FieldAreaResultMap likeArea;
            FieldAreaResultMap normalArea;
            it = (LabelResultMap)list.get(i);
            if (it == null) continue;
            if (areaType == 0) {
                normalArea = new FieldAreaResultMap("\u6b63\u5e38", it.getCounts(), it.getNormalAmount(), it.getId(), "#32c45e");
                likeArea = new FieldAreaResultMap("\u7591\u4f3c\u975e\u7cae", it.getCounts(), it.getLikeAmount(), it.getId(), "#f44336");
                confirmArea = new FieldAreaResultMap("\u5df2\u786e\u8ba4\u975e\u7cae", it.getCounts(), it.getConfirmAmount(), it.getId(), "#B766AD");
                fixingArea = new FieldAreaResultMap("\u6574\u6539\u4e2d\u975e\u7cae", it.getCounts(), it.getFixingAmount(), it.getId(), "#9AFF02");
                fixedArea = new FieldAreaResultMap("\u5df2\u6574\u6539\u975e\u7cae", it.getCounts(), it.getFixedAmount(), it.getId(), "#743A3A");
                areaAmount = new FieldAreaResultMap("\u975e\u7cae\u7530\u5757", it.getCounts(), it.getAreaAmount(), it.getId(), "#B766AD");
            } else if (areaType == 1) {
                normalArea = new FieldAreaResultMap("\u6b63\u5e38", it.getCounts(), it.getNormalAmount(), it.getId(), "#32c45e");
                likeArea = new FieldAreaResultMap("\u7591\u4f3c\u975e\u519c", it.getCounts(), it.getLikeAmount(), it.getId(), "#f44336");
                confirmArea = new FieldAreaResultMap("\u5df2\u786e\u8ba4\u975e\u519c", it.getCounts(), it.getConfirmAmount(), it.getId(), "#B766AD");
                fixedArea = new FieldAreaResultMap("\u5df2\u6574\u6539\u975e\u519c", it.getCounts(), it.getFixedAmount(), it.getId(), "#743A3A");
                fixingArea = new FieldAreaResultMap("\u6574\u6539\u4e2d\u975e\u519c", it.getCounts(), it.getFixingAmount(), it.getId(), "#9AFF02");
                areaAmount = new FieldAreaResultMap("\u975e\u519c\u7530\u5757", it.getCounts(), it.getAreaAmount(), it.getId(), "#B766AD");
            } else {
                normalArea = new FieldAreaResultMap("\u6b63\u5e38", it.getCounts(), it.getNormalAmount(), it.getId(), "#32c45e");
                likeArea = new FieldAreaResultMap("\u7591\u4f3c\u629b\u8352", it.getCounts(), it.getLikeAmount(), it.getId(), "#fff100");
                confirmArea = new FieldAreaResultMap("\u5df2\u786e\u8ba4\u629b\u8352", it.getCounts(), it.getConfirmAmount(), it.getId(), "#808040");
                fixedArea = new FieldAreaResultMap("\u5df2\u6574\u6539\u629b\u8352", it.getCounts(), it.getFixedAmount(), it.getId(), "#9AFF02");
                fixingArea = new FieldAreaResultMap("\u6574\u6539\u4e2d\u629b\u8352", it.getCounts(), it.getFixingAmount(), it.getId(), "#9AFF02");
                areaAmount = new FieldAreaResultMap("\u629b\u8352\u7530\u5757", it.getCounts(), it.getAreaAmount(), it.getId(), "#B766AD");
            }
            arealist.add(normalArea);
            arealist.add(likeArea);
            arealist.add(confirmArea);
            arealist.add(fixingArea);
            arealist.add(fixedArea);
            arealist.add(areaAmount);
            count = count + it.getCounts();
        }
        JSONObject json = new JSONObject();
        json.put("areaSum", (Object)areaSum);
        json.put("count", (Object)count);
        json.put("list", arealist);
        json.put("updateDate", (Object)updateDate);
        return json;
    }

    public JSONObject queryDoubleFieldHistoryLogs(Integer companyId, String regionCode, Integer start, Integer pageSize, String search, Integer statusType, String areaType, Integer apiFlag) {
        Integer count = this.fieldDoubleHistoryMapper.queryLogCountByRegionCode(companyId, regionCode, search, statusType, areaType);
        List list = this.fieldDoubleHistoryMapper.queryLogListByRegionCode(companyId, regionCode, start, pageSize, search, statusType, areaType);
        if (apiFlag != null && apiFlag == 1) {
            for (FieldDoubleHistoryLog log : list) {
                if (log.getAuditFlag() == null || log.getAuditFlag() == 0 || log.getAuditFlag() == 3) {
                    log.setMsg(String.format("\u7cfb\u7edf\u5728%s\u8bc6\u522b\u4e86[%s]\u4e3a\u975e\u7cae\u7530\u5757", log.getCreateDate(), log.getFieldName()));
                    if (log.getAuditFlag() == null || log.getAuditFlag() != 0) continue;
                    log.setMsg(String.format("\u519c\u4e1a\u519c\u6751\u5c40\u5728%s\u9a73\u56de\u4e86[%s]\u7684\u9a8c\u6536", log.getAuditTime(), log.getFieldName()));
                    continue;
                }
                if (log.getAuditFlag() == 2 || log.getAuditFlag() == 4) {
                    log.setMsg(String.format("\u4e61\u9547\u7ba1\u7406\u5458\u5728%s\u63d0\u4ea4\u4e86[%s]\u975e\u7cae\u6574\u6539\u9a8c\u6536", log.getLogDate(), log.getFieldName()));
                    continue;
                }
                if (log.getAuditFlag() != 1) continue;
                log.setMsg(String.format("\u519c\u4e1a\u519c\u6751\u5c40\u5728%s\u5ba1\u6838\u4e86[%s]\u5df2\u6574\u6539", log.getAuditTime(), log.getFieldName()));
            }
        } else {
            for (FieldDoubleHistoryLog log : list) {
                if (log.getStatus() != null && log.getStatus() == 11) {
                    log.setMsg(String.format("\u7cfb\u7edf\u5728%s\u8bc6\u522b\u4e86[%s]\u4e3a\u975e\u7cae\u7530\u5757", log.getCreateDate(), log.getFieldName()));
                    continue;
                }
                if (log.getAuditFlag() == null || log.getAuditFlag() == 0 || log.getAuditFlag() == 3) {
                    log.setMsg(String.format("\u7cfb\u7edf\u5728%s\u8bc6\u522b\u4e86[%s]\u4e3a\u975e\u7cae\u7530\u5757", log.getCreateDate(), log.getFieldName()));
                    if (log.getAuditFlag() == null || log.getAuditFlag() != 0) continue;
                    log.setMsg(String.format("\u519c\u4e1a\u519c\u6751\u5c40\u5728%s\u9a73\u56de\u4e86[%s]\u7684\u9a8c\u6536", log.getAuditTime(), log.getFieldName()));
                    continue;
                }
                if (log.getAuditFlag() == 2 || log.getAuditFlag() == 4) {
                    log.setMsg(String.format("\u4e61\u9547\u7ba1\u7406\u5458\u5728%s\u63d0\u4ea4\u4e86[%s]\u975e\u7cae\u6574\u6539\u9a8c\u6536", log.getLogDate(), log.getFieldName()));
                    continue;
                }
                if (log.getAuditFlag() != 1) continue;
                log.setMsg(String.format("\u519c\u4e1a\u519c\u6751\u5c40\u5728%s\u5ba1\u6838\u4e86[%s]\u5df2\u6574\u6539", log.getAuditTime(), log.getFieldName()));
            }
        }
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryDoubleFieldHistoryLogsFPic(Integer companyId, String regionCode, Integer start, Integer pageSize, String search, Integer statusType, String areaType) {
        Integer count = this.fieldDoubleHistoryMapper.queryLogCountByRegionCode4Pics(companyId, regionCode, search, statusType, areaType);
        List list = this.fieldDoubleHistoryMapper.queryLogListByRegionCode4Pics(companyId, regionCode, start, pageSize, search, statusType, areaType);
        for (FieldDoubleHistoryLog log : list) {
            if (log.getStatus() != null && log.getStatus() == 11) {
                log.setMsg(String.format("\u7cfb\u7edf\u5728%s\u8bc6\u522b\u4e86[%s]\u4e3a\u975e\u7cae\u7530\u5757", log.getCreateDate(), log.getFieldName()));
                continue;
            }
            if (log.getAuditFlag() == null || log.getAuditFlag() == 0 || log.getAuditFlag() == 3) {
                log.setMsg(String.format("\u7cfb\u7edf\u5728%s\u8bc6\u522b\u4e86[%s]\u4e3a\u975e\u7cae\u7530\u5757", log.getCreateDate(), log.getFieldName()));
                if (log.getAuditFlag() == null || log.getAuditFlag() != 0) continue;
                log.setMsg(String.format("\u519c\u4e1a\u519c\u6751\u5c40\u5728%s\u9a73\u56de\u4e86[%s]\u7684\u9a8c\u6536", log.getAuditTime(), log.getFieldName()));
                continue;
            }
            if (log.getAuditFlag() == 2 || log.getAuditFlag() == 4) {
                log.setMsg(String.format("\u4e61\u9547\u7ba1\u7406\u5458\u5728%s\u63d0\u4ea4\u4e86[%s]\u975e\u7cae\u6574\u6539\u9a8c\u6536", log.getLogDate(), log.getFieldName()));
                continue;
            }
            if (log.getAuditFlag() != 1) continue;
            log.setMsg(String.format("\u519c\u4e1a\u519c\u6751\u5c40\u5728%s\u5ba1\u6838\u4e86[%s]\u5df2\u6574\u6539", log.getAuditTime(), log.getFieldName()));
        }
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryStatusLogSummary(Integer companyId, String regionCode, Integer areaType) {
        LabelResultMap labelResultMap = this.fieldDoubleHistoryMapper.queryDoubleStatisticsToday(regionCode);
        JSONObject json = new JSONObject();
        json.put("\u4eca\u65e5\u5df2\u786e\u8ba4", (Object)0);
        json.put("\u7d2f\u8ba1\u786e\u8ba4", (Object)labelResultMap.getConfirmAmount());
        json.put("\u786e\u8ba4\u7387", (Object)String.format("%.2f", labelResultMap.getConfirmAmount() / labelResultMap.getAreaAmount()));
        json.put("\u4eca\u65e5\u6574\u6539", (Object)0);
        json.put("\u7d2f\u8ba1\u6574\u6539", (Object)labelResultMap.getFixedAmount());
        json.put("\u6574\u6539\u7387", (Object)String.format("%.2f", labelResultMap.getFixedAmount() / labelResultMap.getConfirmAmount()));
        return json;
    }

    public List<LabelResultMap> queryDoubleStatusSummaryByHamlet(Integer companyId, List<String> recodeList) {
        List<Integer> norList = Arrays.asList(0);
        LabelResultMap nor = this.fieldDoubleStatusMapper.queryFieldSummaryByStatusList(companyId, recodeList, norList);
        nor.setName("\u6b63\u5e38");
        List<Integer> likeList = Arrays.asList(1, 2, 3);
        LabelResultMap like = this.fieldDoubleStatusMapper.queryFieldSummaryByStatusList(companyId, recodeList, likeList);
        like.setName("\u7591\u4f3c");
        List<Integer> idenList = Arrays.asList(4, 5, 6);
        LabelResultMap iden = this.fieldDoubleStatusMapper.queryFieldSummaryByStatusList(companyId, recodeList, idenList);
        iden.setName("\u5df2\u786e\u8ba4");
        List<Integer> fixList = Arrays.asList(7, 8, 9);
        LabelResultMap fix = this.fieldDoubleStatusMapper.queryFieldSummaryByStatusList(companyId, recodeList, fixList);
        fix.setName("\u5df2\u6574\u6539");
        LinkedList<LabelResultMap> list = new LinkedList<LabelResultMap>();
        list.add(nor);
        list.add(like);
        list.add(iden);
        list.add(fix);
        return list;
    }

    public List<LabelResultMap> queryDoubleStatusSummaryByRegionCode(String regionCode, Integer areaType) {
        FieldDoubleStatistics fieldDoubleStatistics = this.fieldDoubleStatusMapper.queryFieldSummaryByRegionCodeAndAreaType(regionCode, areaType);
        ArrayList<LabelResultMap> list = new ArrayList<LabelResultMap>();
        list.add(new LabelResultMap("\u6574\u6539\u4e2d", Double.valueOf(fieldDoubleStatistics == null ? 0.0 : fieldDoubleStatistics.getFixingAmount())));
        list.add(new LabelResultMap("\u9a8c\u6536\u4e2d", Double.valueOf(fieldDoubleStatistics == null ? 0.0 : fieldDoubleStatistics.getAcceptingAmount())));
        list.add(new LabelResultMap("\u5df2\u6574\u6539", Double.valueOf(fieldDoubleStatistics == null ? 0.0 : fieldDoubleStatistics.getFixedAmount())));
        return list;
    }

    public JSONObject queryAuditList(String regionCode, Integer flag, Integer areaType, Integer start, Integer pageSize, String search) {
        JSONObject json = new JSONObject();
        Integer noDealCount = this.fieldDoubleStatusMapper.queryFieldDoubleAcceptCountByDate(regionCode, null, areaType, search);
        Integer dealCount = this.fieldDoubleStatusMapper.queryFieldDoubleDealCount(regionCode, areaType, search);
        Integer copyCount = this.fieldDoubleStatusMapper.queryFieldDoubleCopyCount(regionCode, areaType, search);
        json.put("dealCount", (Object)dealCount);
        json.put("noDealCount", (Object)noDealCount);
        json.put("copyCount", (Object)copyCount);
        Integer count = 0;
        List list = new ArrayList();
        if (flag == 0) {
            count = noDealCount;
            list = this.fieldDoubleHistoryMapper.queryStatusAreaListByRegionCodeAndAreaType(Arrays.asList(7, 8, 9), Integer.valueOf(2), regionCode, areaType, null, null, start, pageSize, search);
        } else if (flag == 1) {
            count = dealCount;
            list = this.fieldDoubleHistoryMapper.queryDealAreaListByRegionCodeAndAreaType(regionCode, areaType, start, pageSize, search);
        } else if (flag == 2) {
            count = copyCount;
            list = this.fieldDoubleStatusMapper.queryFieldDoubleCopyList(regionCode, areaType, search, start, pageSize);
        }
        for (FieldDoubleStatus dto : list) {
            dto.setImg("http://imgs.shuxitech.com/farm/field_img/" + dto.getImg());
            dto.setRegionName(this.configService.queryHamletAddress(dto.getRegionCode()));
        }
        json.put("list", list);
        json.put("count", (Object)count);
        return json;
    }

    @Transactional
    public Integer auditDoubleField(Integer id, Integer auditFlag, String userId, String msg) {
        Integer resFlag = 0;
        FieldDoubleStatus fdStatus = this.fieldDoubleStatusMapper.queryById(id);
        Integer sqlAuditFlag = fdStatus.getAuditFlag();
        if (Arrays.asList(0, 1, 3).contains(sqlAuditFlag)) {
            resFlag = 1;
        } else {
            FieldDoubleHistory log = this.fieldDoubleHistoryMapper.queryRecentLogByHistoryId(fdStatus.getHistoryId());
            if (auditFlag == 1 || auditFlag == 4) {
                this.fieldDoubleStatusMapper.auditDoubleField(fdStatus.getHistoryId(), auditFlag);
                JSONObject historyJson = new JSONObject();
                historyJson.put("id", (Object)fdStatus.getHistoryId());
                historyJson.put("auditFlag", (Object)auditFlag);
                this.syncFieldStatusHistoryLog(historyJson.toJSONString(), "/ly/field/double-log/update");
                log.setAuditFlag(auditFlag);
                log.setAuditMsg(msg);
                log.setAuditUserId(userId);
                this.fieldDoubleHistoryMapper.updateAuditInfo(log);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("auditFlag", (Object)auditFlag);
                jsonObject.put("id", (Object)log.getId());
                jsonObject.put("auditUserId", (Object)userId);
                jsonObject.put("auditMsg", (Object)msg);
                String date = this.fieldDoubleHistoryMapper.queryDetailDate(fdStatus.getHistoryId());
                this.fieldDoubleStatusMapper.updateFieldDoubleAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), fdStatus.getAreaType());
                try {
                    if (fdStatus.getType() == 1) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "turf_amount", "2", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "turf_amount", "1", date);
                    }
                    if (fdStatus.getType() == 2) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "aquatic_amount", "2", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "aquatic_amount", "1", date);
                    }
                    if (fdStatus.getType() == 3) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "architecture_amount", "2", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "architecture_amount", "1", date);
                    }
                    if (fdStatus.getType() == 4) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "cash_crops_amount", "2", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "cash_crops_amount", "1", date);
                    }
                    if (fdStatus.getType() == 6) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "wasteland_amount", "2", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "wasteland_amount", "1", date);
                    }
                    if (fdStatus.getType() == 7) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "wasteland_amount", "2", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "wasteland_amount", "1", date);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Criteria criteria0 = Criteria.where((String)"field_double_status_id").is((Object)fdStatus.getId());
                Update update0 = Update.update((String)"auditFlag", (Object)auditFlag);
                this.mongoTemplate.upsert(Query.query((CriteriaDefinition)criteria0), update0, JSONObject.class, "t_field_double_status");
                this.warningMapper.updWarningStatus(Integer.valueOf(auditFlag == 1 ? 2 : 1), date, fdStatus.getId());
            } else if (auditFlag == 0 || auditFlag == 3) {
                Integer status = log.getStatus();
                fdStatus.setFixDate("");
                fdStatus.setIdenDate("");
                fdStatus.setStatus(status);
                this.fieldDoubleStatusMapper.revertFdStatus(fdStatus);
                JSONObject json = new JSONObject();
                json.put("id", (Object)fdStatus.getId());
                json.put("status", (Object)status);
                json.put("type", (Object)fdStatus.getType());
                this.fieldDoubleHistoryMapper.updateStatus(status, fdStatus.getHistoryId(), auditFlag);
                JSONObject historyJson = new JSONObject();
                historyJson.put("id", (Object)fdStatus.getHistoryId());
                historyJson.put("auditFlag", (Object)auditFlag);
                this.syncFieldStatusHistoryLog(historyJson.toJSONString(), "/ly/field/double-log/update");
                log.setAuditFlag(auditFlag);
                log.setAuditMsg(msg);
                log.setAuditUserId(userId);
                this.fieldDoubleHistoryMapper.updateAuditInfo(log);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("auditFlag", (Object)auditFlag);
                jsonObject.put("id", (Object)log.getId());
                jsonObject.put("auditUserId", (Object)userId);
                jsonObject.put("auditMsg", (Object)msg);
                this.fieldDoubleStatusMapper.updateFieldDoubleAreaAuditFail(fdStatus.getArea(), fdStatus.getRegionCode(), fdStatus.getAreaType());
                String date = this.fieldDoubleHistoryMapper.queryDetailDate(fdStatus.getHistoryId());
                try {
                    if (fdStatus.getType() == 1) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "turf_amount", "0", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "turf_amount", "2", date);
                    }
                    if (fdStatus.getType() == 2) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "aquatic_amount", "0", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "aquatic_amount", "2", date);
                    }
                    if (fdStatus.getType() == 3) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "architecture_amount", "0", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "architecture_amount", "2", date);
                    }
                    if (fdStatus.getType() == 4) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "cash_crops_amount", "0", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "cash_crops_amount", "2", date);
                    }
                    if (fdStatus.getType() == 6) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "wasteland_amount", "0", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "wasteland_amount", "2", date);
                    }
                    if (fdStatus.getType() == 7) {
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "wasteland_amount", "0", date);
                        this.fieldSpecialLandMapper.updateFieldAreaAuditPass(fdStatus.getArea(), fdStatus.getRegionCode(), "wasteland_amount", "2", date);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.warningMapper.updWarningStatus(Integer.valueOf(auditFlag == 1 ? 2 : 1), date, fdStatus.getId());
                Criteria criteria = Criteria.where((String)"field_double_status_id").is((Object)fdStatus.getId());
                Update update = Update.update((String)"status", (Object)status);
                update.set("auditFlag", (Object)auditFlag);
                this.mongoTemplate.upsert(Query.query((CriteriaDefinition)criteria), update, JSONObject.class, "t_field_double_status");
            }
        }
        return resFlag;
    }

    public void updateDoubleField(FieldDoubleHistoryLog log) {
        FieldDoubleStatus now = this.fieldDoubleStatusMapper.queryById(log.getStatusId());
        Integer nowStatus = log.getStatus();
        Integer auditFlag = 2;
        FieldDoubleStatus fieldDoubleStatus = new FieldDoubleStatus();
        fieldDoubleStatus.setId(log.getStatusId());
        Integer identifyStatus = log.getIdentifyStatus();
        Integer status = nowStatus;
        if (identifyStatus == 1) {
            auditFlag = this.fieldAutoAuditService.calFinalAuditFlagByTown(now.getRegionCode().substring(0, 9), status);
            if (Arrays.asList(1, 2, 3).contains(status)) {
                status = status + 3;
                this.fieldDoubleStatusMapper.updateIdenDate(log.getStatusId());
            } else if (Arrays.asList(10, 11, 12).contains(status)) {
                status = status - 3;
                this.fieldDoubleStatusMapper.updateFixDate(log.getStatusId());
            }
        } else if (Arrays.asList(1, 2, 3).contains(status)) {
            status = 1;
            this.fieldDoubleStatusMapper.updateIdenDate(log.getStatusId());
        }
        fieldDoubleStatus.setStatus(status);
        fieldDoubleStatus.setType(log.getType());
        this.fieldDoubleStatusMapper.update(fieldDoubleStatus);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)fieldDoubleStatus.getId());
        jsonObject.put("status", (Object)status);
        jsonObject.put("type", (Object)fieldDoubleStatus.getType());
        this.fieldDoubleHistoryMapper.updateHistoryLog(log);
        Criteria criteria = Criteria.where((String)"field_double_status_id").is((Object)fieldDoubleStatus.getId());
        Update update = Update.update((String)"status", (Object)status);
        update.set("type", (Object)log.getType());
        this.mongoTemplate.upsert(Query.query((CriteriaDefinition)criteria), update, JSONObject.class, "t_field_double_status");
        FieldDoubleHistory history = new FieldDoubleHistory();
        history.setId(now.getHistoryId());
        history.setStatus(status);
        history.setIdentifyStatus(log.getIdentifyStatus());
        history.setDutyMan(log.getDutyMan());
        history.setDutyPhone(log.getDutyPhone());
        history.setType(log.getType());
        history.setJyfMc(log.getJyfMc());
        history.setJyfPhone(log.getJyfPhone());
        history.setCropName(log.getCropName());
        history.setActualDutyMan(log.getActualDutyMan());
        history.setAuditFlag(auditFlag);
        this.fieldDoubleHistoryMapper.update(history);
        JSONObject historyJson = new JSONObject();
        historyJson.put("id", (Object)history.getId());
        historyJson.put("auditFlag", (Object)auditFlag);
        this.syncFieldStatusHistoryLog(historyJson.toJSONString(), "/ly/field/double-log/update");
    }

    public JSONObject querySummaryByFunctionArea(String regionCode) {
        JSONObject json = new JSONObject();
        List fieldDoubleStatisticsNewList = this.queryFieldStatisticsByParentCode(regionCode, null);
        LinkedList array = new LinkedList();
        Map<String, List<FieldDoubleStatisticsNew>> collect = fieldDoubleStatisticsNewList.stream().collect(Collectors.groupingBy(FieldDoubleStatisticsNew::getRegionCode));
        collect.keySet().forEach(key -> {
            List itemList = (List)collect.get(key);
            FunctionAreaResultMap functionAreaResultMap = new FunctionAreaResultMap();
            functionAreaResultMap.setCode(key);
            functionAreaResultMap.setName(((FieldDoubleStatisticsNew)itemList.get(0)).getName());
            itemList.forEach(fieldDoubleStatisticsNew -> {
                if (fieldDoubleStatisticsNew.getAreaType() == 0) {
                    functionAreaResultMap.setArea0(Double.valueOf(fieldDoubleStatisticsNew.getNormalAmount() + fieldDoubleStatisticsNew.getAreaAmount()));
                } else if (fieldDoubleStatisticsNew.getAreaType() == 1) {
                    functionAreaResultMap.setArea1(Double.valueOf(fieldDoubleStatisticsNew.getNormalAmount() + fieldDoubleStatisticsNew.getAreaAmount()));
                } else if (fieldDoubleStatisticsNew.getAreaType() == 2) {
                    functionAreaResultMap.setArea2(Double.valueOf(fieldDoubleStatisticsNew.getNormalAmount() + fieldDoubleStatisticsNew.getAreaAmount()));
                }
            });
            array.add(functionAreaResultMap);
        });
        json.put("list", array);
        return json;
    }

    @Transactional
    public void submitDFIdenTime(FieldGridRecord fieldGridRecord) {
        this.fieldGridRecordMapper.deleteByStatusId(fieldGridRecord.getStatusId());
        List list = this.fieldGridRecordMapper.queryAll(fieldGridRecord);
        if (list == null || list.size() <= 0) {
            FieldDoubleStatus ds = this.fieldDoubleStatusMapper.queryById(fieldGridRecord.getStatusId());
            Integer initStatus = ds.getStatus();
            Integer status = ds.getStatus();
            if (Arrays.asList(4, 5, 6).contains(initStatus)) {
                status = ds.getStatus() + 6;
                ds.setStatus(status);
            }
            this.fieldGridRecordMapper.insert(fieldGridRecord);
            this.fieldDoubleStatusMapper.update(ds);
            this.fieldDoubleHistoryMapper.updateStatus(status, fieldGridRecord.getHistoryId(), Integer.valueOf(1));
            JSONObject historyJson = new JSONObject();
            historyJson.put("id", (Object)fieldGridRecord.getHistoryId());
            historyJson.put("auditFlag", (Object)1);
            this.syncFieldStatusHistoryLog(historyJson.toJSONString(), "/ly/field/double-log/update");
            FieldDoubleHistoryLog log = new FieldDoubleHistoryLog();
            log.setStatus(initStatus);
            log.setIdentifyStatus(Integer.valueOf(2));
            log.setHistoryId(ds.getHistoryId());
            log.setStatusId(ds.getId());
            log.setAuditFlag(Integer.valueOf(1));
            log.setUserName(fieldGridRecord.getGridLeader());
            log.setRemarks(fieldGridRecord.getMsg());
            log.setPhone(fieldGridRecord.getPhone());
            log.setAuditTime(fieldGridRecord.getNoticeDate());
            this.fieldDoubleHistoryMapper.insertHistoryLog(log);
            Criteria criteria = Criteria.where((String)"field_double_status_id").is((Object)ds.getId());
            Update update = Update.update((String)"status", (Object)status);
            update.set("auditFlag", (Object)1);
            this.mongoTemplate.upsert(Query.query((CriteriaDefinition)criteria), update, JSONObject.class, "t_field_double_status");
            try {
                this.smsService.sendOneFieldMsg(ds.getRegionCode(), 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<JSONObject> queryGridLeaderFieldList(String regionCode, Integer start, Integer pageSize, String search, List<Integer> statusList, List<Integer> auditFlagList, String areaType) {
        List list = this.fieldDoubleStatusMapper.queryGridLeaderFieldList(regionCode, start, pageSize, search, statusList, auditFlagList, areaType);
        for (JSONObject json : list) {
            FieldDoubleHistory fieldDoubleHistory = this.fieldDoubleHistoryMapper.queryRecentLogByHistoryId(json.getInteger("history_id"));
            if (fieldDoubleHistory == null) continue;
            json.put("user_name", (Object)fieldDoubleHistory.getUserName());
        }
        return list;
    }

    public Integer countGridLeaderFieldList(String regionCode, String search, List<Integer> statusList, List<Integer> auditFlagList, String areaType) {
        return this.fieldDoubleStatusMapper.countGridLeaderFieldList(regionCode, search, statusList, auditFlagList, areaType);
    }

    public JSONObject queryDoubleFieldHistoryLogCount(String regionCode, Integer areaType) {
        JSONObject json = new JSONObject();
        Integer fixingCount = this.fieldDoubleStatusMapper.queryFieldDoubleFixingCountByDate(regionCode, null, areaType);
        Integer acceptCount = this.fieldDoubleStatusMapper.queryFieldDoubleAcceptCountByDate(regionCode, null, areaType, null);
        Integer fixedCount = this.fieldDoubleStatusMapper.queryFieldDoubleFixedCountByDate(regionCode, null, areaType, null);
        FieldDoubleStatisticsNew fieldDoubleStatisticsNew = this.fieldDoubleStatusMapper.queryFieldAreaTypeStatisticsByAreaType(regionCode, areaType);
        FieldAreaResultMap fieldAreaResultMap1 = new FieldAreaResultMap();
        fieldAreaResultMap1.setCounts(fixingCount);
        fieldAreaResultMap1.setArea(Double.valueOf(fieldDoubleStatisticsNew != null && fieldDoubleStatisticsNew.getFixingAmount() != null ? fieldDoubleStatisticsNew.getFixingAmount() : 0.0));
        FieldAreaResultMap fieldAreaResultMap2 = new FieldAreaResultMap();
        fieldAreaResultMap2.setCounts(acceptCount);
        fieldAreaResultMap2.setArea(Double.valueOf(fieldDoubleStatisticsNew != null && fieldDoubleStatisticsNew.getAcceptingAmount() != null ? fieldDoubleStatisticsNew.getAcceptingAmount() : 0.0));
        FieldAreaResultMap fieldAreaResultMap3 = new FieldAreaResultMap();
        fieldAreaResultMap3.setCounts(fixedCount);
        fieldAreaResultMap3.setArea(Double.valueOf(fieldDoubleStatisticsNew != null && fieldDoubleStatisticsNew.getFixedAmount() != null ? fieldDoubleStatisticsNew.getFixedAmount() : 0.0));
        json.put("1", (Object)fieldAreaResultMap1);
        json.put("2", (Object)fieldAreaResultMap2);
        json.put("3", (Object)fieldAreaResultMap3);
        return json;
    }

    public JSONObject queryFieldSummaryByRegionCode(String regionCode, Integer areaType) {
        Integer fixingCount = this.fieldDoubleStatusMapper.queryFieldDoubleFixingCountByDate(regionCode, null, areaType);
        Integer acceptCount = this.fieldDoubleStatusMapper.queryFieldDoubleAcceptCountByDate(regionCode, null, areaType, null);
        Integer fixedCount = this.fieldDoubleStatusMapper.queryFieldDoubleFixedCountByDate(regionCode, null, areaType, null);
        JSONObject json = new JSONObject();
        json.put("fixingCount", (Object)fixingCount);
        json.put("acceptingCount", (Object)acceptCount);
        json.put("fixedCount", (Object)fixedCount);
        FieldDoubleStatistics fieldDoubleStatistics = this.fieldDoubleStatusMapper.queryFieldSummaryByRegionCodeAndAreaType(regionCode, areaType);
        json.put("fixingArea", (Object)(fieldDoubleStatistics == null ? 0.0 : fieldDoubleStatistics.getFixingAmount()));
        json.put("acceptingArea", (Object)(fieldDoubleStatistics == null ? 0.0 : fieldDoubleStatistics.getAcceptingAmount()));
        json.put("fixedArea", (Object)(fieldDoubleStatistics == null ? 0.0 : fieldDoubleStatistics.getFixedAmount()));
        return json;
    }

    public JSONObject queryFieldSummaryByLevel(Integer companyId, String regionCode) {
        List recodeList = this.configService.queryDownRegions(regionCode);
        Double areaSum = this.fieldDoubleStatusMapper.queryFieldAreaSum(companyId, recodeList);
        String updateDate = this.fieldDoubleStatusMapper.queryMaxTime(companyId, recodeList);
        List<Integer> norList = Arrays.asList(0);
        LabelResultMap nor = this.fieldDoubleStatusMapper.queryFieldSummaryByStatusList(companyId, recodeList, norList);
        nor.setName("\u6b63\u5e38");
        List<Integer> likeList = Arrays.asList(1, 2, 3);
        LabelResultMap like = this.fieldDoubleStatusMapper.queryFieldSummaryByStatusList(companyId, recodeList, likeList);
        like.setName("\u7591\u4f3c");
        List<Integer> idenList = Arrays.asList(4, 5, 6);
        LabelResultMap iden = this.fieldDoubleStatusMapper.queryFieldSummaryByStatusList(companyId, recodeList, idenList);
        iden.setName("\u5df2\u786e\u8ba4");
        List<Integer> fixList = Arrays.asList(7, 8, 9);
        LabelResultMap fix = this.fieldDoubleStatusMapper.queryFieldSummaryByStatusList(companyId, recodeList, fixList);
        fix.setName("\u5df2\u6574\u6539");
        List<Integer> fixingList = Arrays.asList(10, 11, 12);
        LabelResultMap fixing = this.fieldDoubleStatusMapper.queryFieldSummaryByStatusList(companyId, recodeList, fixingList);
        fix.setName("\u6574\u6539\u4e2d");
        LinkedList<LabelResultMap> list = new LinkedList<LabelResultMap>();
        list.add(nor);
        list.add(like);
        list.add(iden);
        list.add(fix);
        list.add(fixing);
        JSONObject json = new JSONObject();
        json.put("areaSum", (Object)areaSum);
        json.put("list", list);
        json.put("updateDate", (Object)updateDate);
        return json;
    }

    public List<DoubleLabelResultMap> queryDFLandTypeByCode(String regionCode, Integer status) {
        List list = this.fieldDoubleStatusMapper.queryDFLandTypeByCode(regionCode, status);
        for (DoubleLabelResultMap it : list) {
            if (it.getStatus() == 1) {
                it.setName("\u679c\u56ed/\u82d7\u6728");
                continue;
            }
            if (it.getStatus() == 2) {
                it.setName("\u5751\u5858\u6c34\u9762");
                continue;
            }
            if (it.getStatus() == 3) {
                it.setName("\u5efa\u623f");
                continue;
            }
            if (it.getStatus() == 4) {
                it.setName("\u6797\u5730");
                continue;
            }
            if (it.getStatus() == 5) {
                it.setName("\u5927\u68da");
                continue;
            }
            if (it.getStatus() == 6) {
                it.setName("\u591a\u5e74\u751f\u7ecf\u6d4e\u4f5c\u7269");
                continue;
            }
            it.setName("\u6b63\u5e38");
        }
        return list;
    }

    public List<DoubleLabelResultMap> queryFieldSummaryByStatusList(List<Integer> fStatusList, String regionCode) {
        List list = this.fieldDoubleStatusMapper.queryFieldSummaryListByStatus(regionCode, fStatusList);
        block14: for (DoubleLabelResultMap it : list) {
            switch (it.getStatus()) {
                case 1: {
                    it.setName("\u7591\u4f3c\u975e\u519c\u7530\u5757");
                    continue block14;
                }
                case 2: {
                    it.setName("\u7591\u4f3c\u975e\u7cae\u7530\u5757");
                    continue block14;
                }
                case 3: {
                    it.setName("\u7591\u4f3c\u629b\u8352\u7530\u5757");
                    continue block14;
                }
                case 4: {
                    it.setName("\u786e\u8ba4\u975e\u519c\u7530\u5757");
                    continue block14;
                }
                case 5: {
                    it.setName("\u786e\u8ba4\u975e\u7cae\u7530\u5757");
                    continue block14;
                }
                case 6: {
                    it.setName("\u786e\u8ba4\u629b\u8352\u7530\u5757");
                    continue block14;
                }
                case 7: {
                    it.setName("\u5df2\u6574\u6539\u975e\u519c\u7530\u5757");
                    continue block14;
                }
                case 8: {
                    it.setName("\u5df2\u6574\u6539\u975e\u7cae\u7530\u5757");
                    continue block14;
                }
                case 9: {
                    it.setName("\u5df2\u6574\u6539\u629b\u8352\u7530\u5757");
                    continue block14;
                }
                case 10: {
                    it.setName("\u6574\u6539\u4e2d\u975e\u519c\u7530\u5757");
                    continue block14;
                }
                case 11: {
                    it.setName("\u6574\u6539\u4e2d\u975e\u7cae\u7530\u5757");
                    continue block14;
                }
                case 12: {
                    it.setName("\u6574\u6539\u4e2d\u629b\u8352\u7530\u5757");
                    continue block14;
                }
            }
            it.setName("\u6b63\u5e38\u7530\u5757");
        }
        return list;
    }

    public JSONObject queryManageFieldList(String userId, Integer begin, Integer pageSize, String fieldName) {
        List list = this.fieldDoubleStatusMapper.queryManageFieldList(userId, begin, pageSize, fieldName);
        for (FieldDoubleStatus fds : list) {
            fds.setImg("http://imgs.shuxitech.com/farm/field_img/" + fds.getImg());
        }
        Integer count = this.fieldDoubleStatusMapper.queryManageFieldListCount(userId, fieldName);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryPCDoubleUserFieldList(String search, Integer start, Integer pageSize, String regionCode, Integer status, Integer statusType, String beginDate, String endDate, String userName, String areaType) {
        Integer count = this.fieldDoubleStatusMapper.queryPCDoubleUserFieldCount(search, regionCode, status, statusType, beginDate, endDate, userName, areaType);
        List statusIdList = this.fieldDoubleStatusMapper.queryDoubleFieldIdListRecent(search, regionCode, status, statusType, beginDate, endDate, start, pageSize, userName, areaType);
        JSONArray array = new JSONArray();
        for (Integer fieldDoubleStatusId : statusIdList) {
            FieldDoubleStatus fieldDoubleStatus = this.fieldDoubleStatusMapper.queryById(fieldDoubleStatusId);
            if (fieldDoubleStatus == null) continue;
            if (fieldDoubleStatus.getImg() != null && StringUtils.isNotBlank((CharSequence)fieldDoubleStatus.getImg())) {
                fieldDoubleStatus.setImg("http://imgs.shuxitech.com/farm/field_img/" + fieldDoubleStatus.getImg());
            }
            JSONObject itJson = (JSONObject)JSONObject.toJSON((Object)fieldDoubleStatus);
            if (fieldDoubleStatus.getRegionCode() != null && StringUtils.isNotBlank((CharSequence)fieldDoubleStatus.getRegionCode())) {
                String town = this.configService.queryTownAddress(fieldDoubleStatus.getRegionCode());
                String hamlet = this.configService.queryHamletAddress(fieldDoubleStatus.getRegionCode());
                itJson.put("town", (Object)town);
                itJson.put("hamlet", (Object)hamlet);
            }
            itJson.remove((Object)"boundary");
            array.add((Object)itJson);
        }
        JSONObject json = new JSONObject();
        json.put("list", (Object)array);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryDoubleFieldListByRegion(Integer start, Integer pageSize, Integer type, String regionCode) {
        JSONObject json = new JSONObject();
        List<Object> typeList = new ArrayList();
        if (type == 0) {
            typeList = Arrays.asList(1, 2, 3);
        } else if (type == 1) {
            typeList = Arrays.asList(4, 5, 6);
        } else if (type == 2) {
            typeList = Arrays.asList(7, 8, 9);
        } else if (type == 3) {
            typeList = Arrays.asList(10, 11, 12);
        }
        List list = this.fieldDoubleStatusMapper.queryDoubleFieldListByRegion(start, pageSize, typeList, regionCode);
        for (FieldDoubleStatus dto : list) {
            dto.setImg("http://imgs.shuxitech.com/farm/field_img/" + dto.getImg());
        }
        Integer count = this.fieldDoubleStatusMapper.queryDoubleFieldCountByRegion(typeList, regionCode);
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    public List<DoubleLabelResultMap> queryFuncAndTypeDetailList(String regionCode, int type, List<Integer> statusList, Integer statusType) {
        return this.fieldDoubleStatusMapper.queryFuncAndTypeDetailListNew(regionCode, type, statusList, statusType);
    }

    public JSONArray queryFuncAndStatusDetailList(String regionCode) {
        JSONArray array = new JSONArray();
        List list0 = this.fieldDoubleStatusMapper.queryFuncAndStatusDetailList(regionCode, 0);
        List list1 = this.fieldDoubleStatusMapper.queryFuncAndStatusDetailList(regionCode, 1);
        List list2 = this.fieldDoubleStatusMapper.queryFuncAndStatusDetailList(regionCode, 2);
        Double area0 = list0.stream().filter(doubleLabelResultMap -> doubleLabelResultMap != null && doubleLabelResultMap.getArea() != null).mapToDouble(DoubleLabelResultMap::getArea).sum();
        Double area1 = list1.stream().filter(doubleLabelResultMap -> doubleLabelResultMap != null && doubleLabelResultMap.getArea() != null).mapToDouble(DoubleLabelResultMap::getArea).sum();
        Double area2 = list2.stream().filter(doubleLabelResultMap -> doubleLabelResultMap != null && doubleLabelResultMap.getArea() != null).mapToDouble(DoubleLabelResultMap::getArea).sum();
        DoubleLabelResultMap item3 = this.fieldDoubleStatusMapper.queryFuncAndStatusDetailListByCond(regionCode, 0);
        DoubleLabelResultMap item4 = this.fieldDoubleStatusMapper.queryFuncAndStatusDetailListByCond(regionCode, 1);
        DoubleLabelResultMap item5 = this.fieldDoubleStatusMapper.queryFuncAndStatusDetailListByCond(regionCode, 2);
        ValListResultMap val0 = new ValListResultMap(String.format("%.2f", area0), "\u7cae\u529f\u533a", item3);
        ValListResultMap val1 = new ValListResultMap(String.format("%.2f", area1), "\u6c38\u4e45\u519c\u7530\u533a", item4);
        ValListResultMap val2 = new ValListResultMap(String.format("%.2f", area2), "\u4e00\u822c\u8015\u5730", item5);
        array.add((Object)val0);
        array.add((Object)val1);
        array.add((Object)val2);
        return array;
    }

    public JSONObject queryFieldDoubleHistoryCarbonCopyList(String userId, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        Integer count = this.fieldDoubleHistoryMapper.queryHistoryCarbonCopyCount(userId);
        List fieldDoubleHistoryCarbonCopyList = this.fieldDoubleHistoryMapper.queryHistoryCarbonCopyList(userId, start, pageSize);
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)fieldDoubleHistoryCarbonCopyList);
        return jsonObject;
    }

    public JSONObject queryDoubleUserFieldListByStatus(Double lng, Double lat, String regionCode, Integer areaType, Integer type, Integer start, Integer pageSize) {
        List<Integer> statusList = type == 1 ? Arrays.asList(10, 11, 12) : Arrays.asList(7, 8, 9);
        List fieldDoubleStatusList = this.fieldDoubleHistoryMapper.queryStatusAreaListByRegionCodeAndAreaType(statusList, type, regionCode, areaType, lng, lat, start, pageSize, null);
        JSONObject json = new JSONObject();
        json.put("list", (Object)fieldDoubleStatusList);
        return json;
    }

    @Transactional
    public void maintainFieldDoubleStatistics(List<FieldDoubleStatisticsNew> fieldDoubleStatisticsNewList) {
        fieldDoubleStatisticsNewList.forEach(fieldDoubleStatisticsNew -> {
            FieldDoubleStatisticsNew item = this.fieldDoubleStatusMapper.queryFieldAreaTypeStatisticsByAreaType(fieldDoubleStatisticsNew.getRegionCode(), fieldDoubleStatisticsNew.getAreaType());
            if (item == null) {
                this.fieldDoubleStatusMapper.insertFieldDoubleStatistics(fieldDoubleStatisticsNew);
            } else {
                this.fieldDoubleStatusMapper.updateFieldDoubleStatistics(fieldDoubleStatisticsNew);
            }
        });
    }

    public JSONObject queryFieldAreaTypeStatistics(String regionCode, Integer areaType) {
        JSONObject jsonObject = new JSONObject();
        if (areaType != null) {
            FieldDoubleStatisticsNew fieldDoubleStatisticsNew = this.fieldDoubleStatusMapper.queryFieldAreaTypeStatisticsByAreaType(regionCode, areaType);
            Double todayFixedArea = this.fieldDoubleStatusMapper.queryFieldDoubleAreaFixedByAreaType(regionCode, areaType);
            Double todayFixingArea = this.fieldDoubleStatusMapper.queryFieldDoubleAreaFixingByAreaType(regionCode, areaType);
            jsonObject.put("item", (Object)fieldDoubleStatisticsNew);
            jsonObject.put("todayFixedArea", (Object)todayFixedArea);
            jsonObject.put("todayFixingArea", (Object)todayFixingArea);
        } else {
            List fieldDoubleStatisticsNewList = this.fieldDoubleStatusMapper.queryFieldAreaTypeStatistics(regionCode);
            jsonObject.put("list", (Object)fieldDoubleStatisticsNewList);
        }
        return jsonObject;
    }

    public List<FieldDoubleStatisticsNew> queryFieldStatisticsByParentCode(String regionCode, Integer areaType) {
        return this.fieldDoubleStatusMapper.queryFieldStatisticsByParentCode(regionCode, areaType);
    }

    public List<FieldDoubleStatisticsNew> queryFieldDoubleStatisticsByParentCode(String regionCode) {
        return this.fieldDoubleStatusMapper.queryFieldDoubleStatisticsByParentCode(regionCode);
    }

    public void insertFieldDoubleStatisticsList(List<FieldDoubleStatisticsNew> fieldDoubleStatisticsNewList) {
        this.fieldDoubleStatusMapper.insertFieldDoubleStatisticsList(fieldDoubleStatisticsNewList);
    }

    public JSONObject queryFieldDoubleStatisticsByDate(String regionCode, String dateTime, Integer areaType) {
        List fieldDoubleStatisticsNewList;
        FieldDoubleStatisticsNew fieldDoubleStatisticsNew;
        String tempTime;
        if (dateTime.equals(new SimpleDateFormat("yyyy-MM-dd").format(new Date()))) {
            tempTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            fieldDoubleStatisticsNew = this.fieldDoubleStatusMapper.queryFieldAreaTypeStatisticsByAreaType(regionCode, areaType);
            fieldDoubleStatisticsNewList = this.fieldDoubleStatusMapper.queryFieldStatisticsByParentCode(regionCode, areaType);
        } else {
            tempTime = dateTime + " 23:59:59";
            fieldDoubleStatisticsNew = this.fieldDoubleStatusMapper.queryFieldDoubleStatisticsByDate(regionCode, tempTime, areaType);
            fieldDoubleStatisticsNewList = this.fieldDoubleStatusMapper.queryFieldStatisticsByParentCodeAndDate(regionCode, tempTime, areaType);
        }
        Integer fixingCount = this.fieldDoubleStatusMapper.queryFieldDoubleFixingCountByDate(regionCode, tempTime, areaType);
        Integer acceptCount = this.fieldDoubleStatusMapper.queryFieldDoubleAcceptCountByDate(regionCode, tempTime, areaType, null);
        Integer fixedCount = this.fieldDoubleStatusMapper.queryFieldDoubleFixedCountByDate(regionCode, tempTime, areaType, null);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fixingCount", (Object)fixingCount);
        jsonObject.put("acceptCount", (Object)acceptCount);
        jsonObject.put("fixedCount", (Object)fixedCount);
        jsonObject.put("item", (Object)fieldDoubleStatisticsNew);
        jsonObject.put("list", (Object)fieldDoubleStatisticsNewList);
        return jsonObject;
    }

    public void updateStatisticsOfFieldDoubleField(String regionCode) {
        this.fieldDoubleStatusMapper.updateAllStatisticsToZero(regionCode);
        List doubleLabelResultMaps00 = this.fieldDoubleStatusMapper.queryAllDoubleSummary(regionCode, 0, "0");
        Map<String, List<DoubleLabelResultMap>> countyData = doubleLabelResultMaps00.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData.keySet()) {
            double countySum = countyData.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "normal_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> townData = doubleLabelResultMaps00.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData.keySet()) {
            double townSum = townData.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "normal_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> map = doubleLabelResultMaps00.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map.keySet()) {
            double villageSum = map.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "normal_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> gridData = doubleLabelResultMaps00.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData.keySet()) {
            double gridSum = gridData.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "normal_amount", "0");
        }
        List doubleLabelResultMaps110 = this.fieldDoubleStatusMapper.queryAllDoubleSummary(regionCode, 11, "0");
        Map<String, List<DoubleLabelResultMap>> countyData110 = doubleLabelResultMaps110.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData110.keySet()) {
            double countySum = countyData110.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "fixing_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> townData110 = doubleLabelResultMaps110.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData110.keySet()) {
            double townSum = townData110.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "fixing_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> map2 = doubleLabelResultMaps110.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map2.keySet()) {
            double villageSum = map2.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "fixing_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> gridData110 = doubleLabelResultMaps110.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData110.keySet()) {
            double gridSum = gridData110.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "fixing_amount", "0");
        }
        List doubleLabelResultMaps820 = this.fieldDoubleStatusMapper.queryAllDoubleSummaryInFix(regionCode, 8, 2, "0");
        Map<String, List<DoubleLabelResultMap>> countyData820 = doubleLabelResultMaps820.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData820.keySet()) {
            double countySum = countyData820.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "accepting_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> townData820 = doubleLabelResultMaps820.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData820.keySet()) {
            double townSum = townData820.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "accepting_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> map3 = doubleLabelResultMaps820.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map3.keySet()) {
            double villageSum = map3.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "accepting_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> gridData820 = doubleLabelResultMaps820.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData820.keySet()) {
            double gridSum = gridData820.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "accepting_amount", "0");
        }
        List doubleLabelResultMaps810 = this.fieldDoubleStatusMapper.queryAllDoubleSummaryInFix(regionCode, 8, 1, "0");
        Map<String, List<DoubleLabelResultMap>> countyData810 = doubleLabelResultMaps810.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData810.keySet()) {
            double countySum = countyData810.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "fixed_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> townData810 = doubleLabelResultMaps810.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData810.keySet()) {
            double townSum = townData810.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "fixed_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> map4 = doubleLabelResultMaps810.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map4.keySet()) {
            double villageSum = map4.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "fixed_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> gridData810 = doubleLabelResultMaps810.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData810.keySet()) {
            double gridSum = gridData810.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "fixed_amount", "0");
        }
        doubleLabelResultMaps110.addAll(doubleLabelResultMaps820);
        doubleLabelResultMaps110.addAll(doubleLabelResultMaps810);
        Map<String, List<DoubleLabelResultMap>> total06 = doubleLabelResultMaps110.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String s : total06.keySet()) {
            double gridSum = total06.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> total09 = doubleLabelResultMaps110.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : total09.keySet()) {
            double gridSum = total09.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> total012 = doubleLabelResultMaps110.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : total012.keySet()) {
            double gridSum = total012.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "0");
        }
        Map<String, List<DoubleLabelResultMap>> total015 = doubleLabelResultMaps110.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : total015.keySet()) {
            double gridSum = total015.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "0");
        }
        List doubleLabelResultMaps01 = this.fieldDoubleStatusMapper.queryAllDoubleSummary(regionCode, 0, "1");
        Map<String, List<DoubleLabelResultMap>> countyData01 = doubleLabelResultMaps01.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData01.keySet()) {
            double countySum = countyData01.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "normal_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> townData01 = doubleLabelResultMaps01.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData01.keySet()) {
            double townSum = townData01.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "normal_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> map5 = doubleLabelResultMaps01.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map5.keySet()) {
            double villageSum = map5.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "normal_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> gridData01 = doubleLabelResultMaps01.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData01.keySet()) {
            double gridSum = gridData01.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "normal_amount", "1");
        }
        List doubleLabelResultMaps111 = this.fieldDoubleStatusMapper.queryAllDoubleSummary(regionCode, 11, "1");
        Map<String, List<DoubleLabelResultMap>> countyData111 = doubleLabelResultMaps111.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData111.keySet()) {
            double countySum = countyData111.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "fixing_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> townData111 = doubleLabelResultMaps111.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData111.keySet()) {
            double townSum = townData111.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "fixing_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> map6 = doubleLabelResultMaps111.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map6.keySet()) {
            double villageSum = map6.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "fixing_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> gridData111 = doubleLabelResultMaps111.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData111.keySet()) {
            double gridSum = gridData111.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "fixing_amount", "1");
        }
        List doubleLabelResultMaps821 = this.fieldDoubleStatusMapper.queryAllDoubleSummaryInFix(regionCode, 8, 2, "1");
        Map<String, List<DoubleLabelResultMap>> countyData821 = doubleLabelResultMaps821.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData821.keySet()) {
            double countySum = countyData821.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "accepting_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> townData821 = doubleLabelResultMaps821.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData821.keySet()) {
            double townSum = townData821.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "accepting_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> map7 = doubleLabelResultMaps821.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map7.keySet()) {
            double villageSum = map7.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "accepting_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> gridData821 = doubleLabelResultMaps821.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData821.keySet()) {
            double gridSum = gridData821.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "accepting_amount", "1");
        }
        List doubleLabelResultMaps811 = this.fieldDoubleStatusMapper.queryAllDoubleSummaryInFix(regionCode, 8, 1, "1");
        Map<String, List<DoubleLabelResultMap>> countyData811 = doubleLabelResultMaps811.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData811.keySet()) {
            double countySum = countyData811.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "fixed_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> townData811 = doubleLabelResultMaps811.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData811.keySet()) {
            double townSum = townData811.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "fixed_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> map8 = doubleLabelResultMaps811.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map8.keySet()) {
            double villageSum = map8.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "fixed_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> gridData811 = doubleLabelResultMaps811.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData811.keySet()) {
            double gridSum = gridData811.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "fixed_amount", "1");
        }
        doubleLabelResultMaps111.addAll(doubleLabelResultMaps821);
        doubleLabelResultMaps111.addAll(doubleLabelResultMaps811);
        Map<String, List<DoubleLabelResultMap>> total16 = doubleLabelResultMaps111.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String s : total16.keySet()) {
            double gridSum = total16.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> total19 = doubleLabelResultMaps111.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : total19.keySet()) {
            double gridSum = total19.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> total112 = doubleLabelResultMaps111.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : total112.keySet()) {
            double gridSum = total112.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "1");
        }
        Map<String, List<DoubleLabelResultMap>> total115 = doubleLabelResultMaps111.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : total115.keySet()) {
            double gridSum = total115.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "1");
        }
        List doubleLabelResultMaps02 = this.fieldDoubleStatusMapper.queryAllDoubleSummary(regionCode, 0, "2");
        Map<String, List<DoubleLabelResultMap>> countyData02 = doubleLabelResultMaps02.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData02.keySet()) {
            double countySum = countyData02.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "normal_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> townData02 = doubleLabelResultMaps02.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData02.keySet()) {
            double townSum = townData02.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "normal_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> map9 = doubleLabelResultMaps02.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map9.keySet()) {
            double villageSum = map9.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "normal_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> gridData02 = doubleLabelResultMaps02.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData02.keySet()) {
            double gridSum = gridData02.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "normal_amount", "2");
        }
        List doubleLabelResultMaps112 = this.fieldDoubleStatusMapper.queryAllDoubleSummary(regionCode, 11, "2");
        Map<String, List<DoubleLabelResultMap>> countyData112 = doubleLabelResultMaps112.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData112.keySet()) {
            double countySum = countyData112.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "fixing_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> townData112 = doubleLabelResultMaps112.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData112.keySet()) {
            double townSum = townData112.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "fixing_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> map10 = doubleLabelResultMaps112.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map10.keySet()) {
            double villageSum = map10.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "fixing_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> gridData112 = doubleLabelResultMaps112.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData112.keySet()) {
            double gridSum = gridData112.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "fixing_amount", "2");
        }
        List doubleLabelResultMaps822 = this.fieldDoubleStatusMapper.queryAllDoubleSummaryInFix(regionCode, 8, 2, "2");
        Map<String, List<DoubleLabelResultMap>> countyData822 = doubleLabelResultMaps822.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData822.keySet()) {
            double countySum = countyData822.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "accepting_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> townData822 = doubleLabelResultMaps822.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData822.keySet()) {
            double townSum = townData822.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "accepting_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> map11 = doubleLabelResultMaps822.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map11.keySet()) {
            double villageSum = map11.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "accepting_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> gridData822 = doubleLabelResultMaps822.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData822.keySet()) {
            double gridSum = gridData822.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "accepting_amount", "2");
        }
        List doubleLabelResultMaps812 = this.fieldDoubleStatusMapper.queryAllDoubleSummaryInFix(regionCode, 8, 1, "2");
        Map<String, List<DoubleLabelResultMap>> countyData812 = doubleLabelResultMaps812.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String string : countyData812.keySet()) {
            double countySum = countyData812.get(string).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(countySum), string, "fixed_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> townData812 = doubleLabelResultMaps812.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : townData812.keySet()) {
            double townSum = townData812.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(townSum), s, "fixed_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> map12 = doubleLabelResultMaps812.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : map12.keySet()) {
            double villageSum = map12.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(villageSum), s, "fixed_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> gridData812 = doubleLabelResultMaps812.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : gridData812.keySet()) {
            double gridSum = gridData812.get(s).stream().filter(item -> item.getArea() != null).mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "fixed_amount", "2");
        }
        doubleLabelResultMaps112.addAll(doubleLabelResultMaps822);
        doubleLabelResultMaps112.addAll(doubleLabelResultMaps812);
        Map<String, List<DoubleLabelResultMap>> total26 = doubleLabelResultMaps112.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 6)));
        for (String s : total26.keySet()) {
            double gridSum = total26.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> total29 = doubleLabelResultMaps112.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 9)));
        for (String s : total29.keySet()) {
            double gridSum = total29.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> total212 = doubleLabelResultMaps112.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 12)));
        for (String s : total212.keySet()) {
            double gridSum = total212.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "2");
        }
        Map<String, List<DoubleLabelResultMap>> total215 = doubleLabelResultMaps112.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLabel()) && null != item.getArea()).collect(Collectors.groupingBy(d -> d.getLabel().substring(0, 15)));
        for (String s : total215.keySet()) {
            double gridSum = total215.get(s).stream().mapToDouble(c -> c.getArea()).sum();
            this.fieldDoubleStatusMapper.updateStatisticsNew(Double.valueOf(gridSum), s, "area_amount", "2");
        }
    }

    public void updateFieldDoubleFieldStatus(List<FieldDoubleStatus> list) {
        List<Integer> fixingList = Arrays.asList(10, 11, 12);
        for (FieldDoubleStatus item : list) {
            FieldDoubleStatus nowStatus = this.fieldDoubleStatusMapper.queryById(item.getId());
            if (fixingList.contains(nowStatus.getStatus()) && nowStatus.getStatus() != 0) {
                this.fieldDoubleStatusMapper.updateFieldDoubleTime(item.getId());
                continue;
            }
            this.fieldDoubleStatusMapper.update(item);
            FieldDoubleHistory history = new FieldDoubleHistory(nowStatus.getStatus(), item.getId(), item.getStatus(), item.getType(), nowStatus.getType(), nowStatus.getAreaType(), Integer.valueOf(1), nowStatus.getActualDutyMan(), nowStatus.getDutyMan(), nowStatus.getDutyPhone(), item.getCropName());
            this.fieldDoubleStatusMapper.insertHistory(history);
            JSONObject historyJson = new JSONObject();
            historyJson.put("id", (Object)history.getId());
            historyJson.put("statusId", (Object)history.getFieldDoubleStatusId());
            historyJson.put("auditFlag", (Object)history.getAuditFlag());
            this.syncFieldStatusHistoryLog(historyJson.toJSONString(), "/ly/field/double-log/insert");
            this.fieldDoubleStatusMapper.updateFieldHistoryId(item.getId(), history.getId());
            String regionCode = nowStatus.getRegionCode();
            ArrayList<String> regionList = new ArrayList<String>();
            if (regionCode == null || regionCode.length() <= 0) continue;
            for (int i = 2; i <= regionCode.length() / 3; ++i) {
                regionList.add(regionCode.substring(0, i * 3));
            }
        }
    }

    public List<FieldDoubleHistory> queryFieldDoubleHistory(Integer fieldDoubleId) {
        List fieldDoubleHistoryList = this.fieldDoubleStatusMapper.queryFieldDoubleStatusHistoryList(fieldDoubleId);
        fieldDoubleHistoryList.forEach(fieldDoubleHistory -> {
            fieldDoubleHistory.setFieldDoubleHistoryLogList(this.fieldDoubleStatusMapper.queryFieldDoubleHistoryLogById(fieldDoubleHistory.getId(), fieldDoubleId));
            fieldDoubleHistory.setFieldDoubleHistoryPic(this.fieldDoubleStatusMapper.queryFieldDoubleHistoryPicById(fieldDoubleHistory.getId(), fieldDoubleId));
        });
        return fieldDoubleHistoryList;
    }

    public void updateRegionFieldSummary(String regionCode) {
        List list0 = this.fieldDoubleStatusMapper.queryDoubleSummaryInTime(regionCode, 0);
        for (Object item0 : list0) {
            this.fieldDoubleStatusMapper.updateStatisticsNew(item0.getArea(), item0.getLabel(), "normal_amount", null);
        }
        List list11 = this.fieldDoubleStatusMapper.queryDoubleSummaryInTime(regionCode, 11);
        for (Object item0 : list11) {
            this.fieldDoubleStatusMapper.updateStatisticsNew(item0.getArea(), item0.getLabel(), "fixing_amount", null);
        }
        List list80 = this.fieldDoubleStatusMapper.queryDoubleSummaryInFix(regionCode, 8, 2);
        for (DoubleLabelResultMap item0 : list80) {
            this.fieldDoubleStatusMapper.updateStatisticsNew(item0.getArea(), item0.getLabel(), "accepting_amount", null);
        }
        List list81 = this.fieldDoubleStatusMapper.queryDoubleSummaryInFix(regionCode, 8, 1);
        for (DoubleLabelResultMap item0 : list81) {
            this.fieldDoubleStatusMapper.updateStatisticsNew(item0.getArea(), item0.getLabel(), "fixed_amount", null);
        }
    }

    public JSONObject queryDoubleUserFieldListByStatus1(String regionCode, Integer areaType, Integer type, Integer start, Integer pageSize) {
        List<Integer> statusList = type == 1 ? Arrays.asList(10, 11, 12) : Arrays.asList(7, 8, 9);
        List fieldDoubleStatusList = this.fieldDoubleHistoryMapper.queryStatusAreaListByRegionCodeAndAreaType1(statusList, type, regionCode, areaType, start, pageSize);
        JSONObject json = new JSONObject();
        json.put("list", (Object)fieldDoubleStatusList);
        return json;
    }

    public void syncFieldStatusHistoryLog(String jsonStr, String url) {
        try {
            HttpSendUtil.sendHttpPost((String)(this.datasyncUrl + url), (String)"", (String)"", (String)jsonStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject queryFieldAddrInfo(Integer id, String name, String regionCode, Integer start, Integer pageSize) {
        JSONObject json = new JSONObject();
        List list = this.fieldDoubleStatusMapper.queryFieldPage(id, name, regionCode, start, pageSize);
        Integer count = this.fieldDoubleStatusMapper.queryFieldPageCount(id, name, regionCode);
        if (list != null && list.size() > 0) {
            list.forEach(it -> {
                if (StringUtils.isNotBlank((CharSequence)it.getImg())) {
                    it.setImg("http://imgs.shuxitech.com/farm/field_img/" + it.getImg());
                }
            });
        }
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public Long queryFieldDoubleStatusCount(String regionCode, Integer year, String date) {
        return this.fieldDoubleStatusMapper.queryFieldDoubleStatusCount(regionCode, year, date);
    }

    public List<DpDataTempVo> fieldDoubleStatusArea(String regionCode) {
        return this.fieldDoubleStatusMapper.fieldDoubleStatusArea(regionCode);
    }

    public List<String> queryLotList(Integer year) {
        return this.fieldDoubleStatusMapper.queryLotList(year);
    }

    public DpDataTempVo queryStatistics(String regionCode, Integer year, String date) {
        return this.fieldDoubleStatusMapper.queryStatistics(regionCode, year, date);
    }

    public AreaTypeVo queryAreaTypeStatistics(String regionCode, Integer type, Integer year, String date) {
        return this.fieldDoubleStatusMapper.queryAreaTypeStatistics(regionCode, type, year, date);
    }

    public JSONObject queryWarningDetail(Integer id, Integer relId) {
        List listp2 = Arrays.asList(this.roleP2.split(",")).stream().mapToInt(num -> Integer.parseInt(num)).boxed().collect(Collectors.toList());
        JSONObject json = new JSONObject();
        FieldDoubleStatus dto = this.fieldDoubleStatusMapper.queryWarningDetail(id, relId);
        dto.setImg("http://imgs.shuxitech.com/farm/field_img/" + dto.getImg());
        json.put("fieldInfo", (Object)dto);
        FieldDoubleHistoryPic rectifyImgList = this.fieldDoubleHistoryMapper.queryFieldRectifyImg(id, dto.getHistoryId());
        json.put("rectifyImg", (Object)rectifyImgList);
        String parentCode = this.fieldDoubleStatusMapper.queryParentCodeByRegionCode(dto.getRegionCode());
        List villageUserList = this.lytUserService.queryHeadUserListByFieldStatusId(parentCode, (Integer)listp2.get(listp2.size() - 1));
        json.put("villageNameList", (Object)villageUserList.stream().map(LytUser::getUserName).collect(Collectors.joining(",")));
        parentCode = this.fieldDoubleStatusMapper.queryParentCodeByRegionCode(parentCode);
        List townUserList = this.lytUserService.queryHeadUserListByRoleId(parentCode, Integer.valueOf(777777));
        json.put("townNameList", (Object)townUserList.stream().map(LytUser::getUserName).collect(Collectors.joining(",")));
        json.put("townPhoneList", (Object)townUserList.stream().map(LytUser::getMobile).collect(Collectors.joining(",")));
        parentCode = this.fieldDoubleStatusMapper.queryParentCodeByRegionCode(parentCode);
        List countyUserList = this.lytUserService.queryHeadUserListByRoleId(parentCode, Integer.valueOf(1549398233));
        json.put("countyNameList", (Object)countyUserList.stream().map(LytUser::getUserName).collect(Collectors.joining(",")));
        FieldDoubleHistory identifyInfo = this.fieldDoubleStatusMapper.queryRecentStatusById(id);
        json.put("identifyInfo", (Object)identifyInfo);
        List logList = this.fieldDoubleHistoryMapper.queryStatusLogListById(identifyInfo.getHistoryId());
        json.put("logList", (Object)logList);
        return json;
    }
}

