/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.AgriserveLandlord;
import com.farm.bean.GridUserInfo;
import com.farm.bean.LytDistrict;
import com.farm.bean.LytOrganization;
import com.farm.bean.LytRole;
import com.farm.bean.LytRoleUser;
import com.farm.bean.LytUser;
import com.farm.bean.OrganizationUser;
import com.farm.bean.resultMap.UserSmsResultMap;
import com.farm.controller.zzd.GovernmentUserController;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.mapper.LytDistrictMapper;
import com.farm.mapper.LytOrganizationMapper;
import com.farm.mapper.LytRoleMapper;
import com.farm.mapper.LytUserMapper;
import com.farm.service.LytPermissionService;
import com.farm.service.LytUserService;
import com.farm.service.OrganService;
import com.farm.util.AES;
import com.farm.util.HttpSendUtil;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RefreshScope
public class LytUserServiceImpl
implements LytUserService {
    private static final Logger log = LoggerFactory.getLogger(LytUserServiceImpl.class);
    @Value(value="${lyt.clientSecret}")
    private String clientSecret;
    @Value(value="${lyt.clientId}")
    private String clientId;
    @Value(value="${lyt.url}")
    private String lytUrl;
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;
    @Value(value="${farm.companyId}")
    private String companyId;
    @Value(value="${lyt.lesseeCode}")
    private String lesseeCode;
    @Value(value="${lyt.config.roleP0}")
    private String roleP0;
    @Value(value="${lyt.config.roleP1}")
    private String roleP1;
    @Value(value="${lyt.config.roleP2}")
    private String roleP2;
    @Value(value="${lyt.config.role2}")
    private String role2;
    @Value(value="${lyt.config.role3}")
    private String role3;
    @Value(value="${lyt.config.farmOrgId}")
    private String farmOrgId;
    @Value(value="${lyt.config.farmRoleId}")
    private String farmRoleId;
    @Autowired
    private GovernmentUserController governmentUserController;
    @Autowired
    private LytOrganizationMapper lytOrganizationMapper;
    @Autowired
    private LytDistrictMapper lytDistrictMapper;
    @Autowired
    private LytUserMapper lytUserMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private LytRoleMapper lytRoleMapper;
    @Resource
    private LytPermissionService permissionService;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private LytOrganizationMapper organizationMapper;
    @Autowired
    private OrganService organService;

    public String queryToken() {
        JSONObject json = new JSONObject();
        json.put("client_id", (Object)this.clientId);
        json.put("grant_type", (Object)"client_credentials");
        json.put("client_secret", (Object)this.clientSecret);
        String token = (String)this.redisTemplate.opsForValue().get((Object)this.clientId);
        if (StringUtils.isBlank((String)token)) {
            try {
                String response = HttpSendUtil.sendHttpPost((String)this.lytUrl, (String)"oauth2/token", (String)"", (String)json.toJSONString());
                JSONObject resJson = JSONObject.parseObject((String)response);
                String accessToken = resJson.getString("access_token");
                Long expiresIn = resJson.getLong("expires_in");
                log.error("\u8fc7\u671f\u6709\u6548\u65f6\u95f4\uff1a{}", (Object)expiresIn);
                token = "Bearer " + accessToken;
                this.redisTemplate.opsForValue().set((Object)this.clientId, (Object)token, expiresIn.longValue(), TimeUnit.SECONDS);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        token = (String)this.redisTemplate.opsForValue().get((Object)this.clientId);
        return token;
    }

    public LytUser queryUserAllInfoByPhone(String phone, String appUserId) {
        LytUser lytUser = new LytUser();
        lytUser.setMobile(phone);
        List list = this.lytUserMapper.queryAll(lytUser);
        if (list != null && list.size() > 0) {
            List roleList;
            lytUser = (LytUser)list.get(0);
            List organList = this.lytOrganizationMapper.queryAllByUserId(lytUser.getUserId());
            if (organList != null && organList.size() > 0) {
                lytUser.setOrgList(organList);
            }
            if ((roleList = this.lytRoleMapper.queryAllByUserId(lytUser.getUserId())) != null && roleList.size() > 0) {
                lytUser.setRoleList(roleList);
            }
            List permissionList = this.permissionService.queryAllByUserId(lytUser.getUserId(), Integer.valueOf(3));
            lytUser.setPermissionList(permissionList);
            return lytUser;
        }
        return null;
    }

    public void updateOrgInfo(JSONArray array, String lesseeCode) {
        LinkedList<LytOrganization> list = new LinkedList<LytOrganization>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            LytOrganization lytOrganization = (LytOrganization)JSONObject.toJavaObject((JSON)json, LytOrganization.class);
            list.add(lytOrganization);
        }
        List organList = new LinkedList<LytOrganization>();
        organList.add((LytOrganization)list.get(0));
        organList = this.covertAll((LytOrganization)list.get(0), organList);
        for (int i = 0; i < organList.size(); ++i) {
            if (!StringUtils.isBlank((String)((LytOrganization)organList.get(i)).getLesseeCode())) continue;
            ((LytOrganization)organList.get(i)).setLesseeCode(lesseeCode);
        }
        this.lytOrganizationMapper.insertOrUpdateBatch(organList);
    }

    public void updateDistrictInfo(JSONArray array) {
        LinkedList<LytDistrict> list = new LinkedList<LytDistrict>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            LytDistrict lytDistrict = (LytDistrict)JSONObject.toJavaObject((JSON)json, LytDistrict.class);
            list.add(lytDistrict);
        }
        List<Object> lytDistrictList = new LinkedList<LytDistrict>();
        lytDistrictList.add((LytDistrict)list.get(0));
        lytDistrictList = this.covertAllDistrict((LytDistrict)list.get(0), lytDistrictList);
        this.lytDistrictMapper.insertOrUpdateBatch(lytDistrictList);
    }

    public void updateUserOrgInfo(JSONArray array, String dbOrgId, String code) {
        ArrayList<OrganizationUser> list = new ArrayList<OrganizationUser>();
        for (int i = 0; i < array.size(); ++i) {
            OrganizationUser orgUser = new OrganizationUser(dbOrgId, array.getJSONObject(i).getString("userId"));
            list.add(orgUser);
        }
        if (list != null && list.size() > 0) {
            this.lytOrganizationMapper.sertOrUpdateOrgUserBatch(list, code);
        }
    }

    public List<String> queryUserOrgList(String code) {
        List list = this.lytOrganizationMapper.queryUserOrgList(code);
        return list;
    }

    public List<String> queryUserIdList(String code) {
        List list = this.lytOrganizationMapper.queryUserIdList(code);
        return list;
    }

    public void updateUserListInfo(List<LytUser> userList, String code) {
        this.lytUserMapper.insertOrUpdateBatch(userList);
        for (int i = 0; i < userList.size(); ++i) {
            String userId = userList.get(i).getUserId();
            List organizations = userList.get(i).getOrgList();
            LinkedList<OrganizationUser> orgUserList = new LinkedList<OrganizationUser>();
            OrganizationUser orgUser = null;
            if (organizations != null && organizations.size() > 0) {
                for (int j = 0; j < organizations.size(); ++j) {
                    if (StringUtils.isBlank((String)((LytOrganization)organizations.get(j)).getLesseeCode())) {
                        ((LytOrganization)organizations.get(j)).setLesseeCode(code);
                    }
                    orgUser = new OrganizationUser(((LytOrganization)organizations.get(j)).getOrgId().toString(), userId);
                    orgUserList.add(orgUser);
                }
                this.lytOrganizationMapper.insertOrUpdateBatch(organizations);
                List districtList = userList.get(i).getAdmAreaList();
                if (districtList != null && districtList.size() > 0) {
                    List areaIdList = districtList.stream().map(it -> it.getAdmId()).collect(Collectors.toList());
                    this.lytDistrictMapper.insertOrUpdateUserArea(areaIdList, userId);
                }
                this.lytOrganizationMapper.sertOrUpdateOrgUserBatch(orgUserList, code);
            }
            try {
                List roleList = userList.get(i).getRoleList();
                if (roleList == null || roleList.size() <= 0) continue;
                ArrayList<LytRoleUser> roleUsers = new ArrayList<LytRoleUser>();
                for (LytRole role : roleList) {
                    LytRoleUser roleUser = new LytRoleUser(userId, role.getId().toString(), this.lesseeCode);
                    roleUsers.add(roleUser);
                }
                this.lytRoleMapper.upSertRoleUserBatch(roleUsers, this.lesseeCode);
                continue;
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u7528\u6237\u5173\u8054\u89d2\u8272\u62a5\u9519", (Object)e.getMessage());
            }
        }
    }

    public void updateLytRoleTree(LytRole lytRole, String lesseeCode) {
        List<Object> roleList = new LinkedList<LytRole>();
        roleList.add(lytRole);
        roleList = this.covertAllRole(lytRole, roleList);
        this.lytRoleMapper.insertOrUpdateBatch(roleList, lesseeCode);
    }

    public void updateOrgRoleUserList(JSONArray rows, String code) {
        if (rows != null && rows.size() > 0) {
            List list = JSONArray.parseArray((String)rows.toString(), LytRoleUser.class);
            this.lytRoleMapper.upSertRoleUserBatch(list, code);
        }
    }

    public JSONObject syncToSxUser(LytUser lytUser, Integer flag) {
        JSONObject userInfo = new JSONObject();
        if (lytUser == null || StringUtils.isBlank((String)lytUser.getSxUserId()) || flag == 1) {
            userInfo = this.governmentUserController.queryUserInfoByPhone(lytUser.getMobile());
        } else {
            userInfo.put("data", (Object)lytUser);
        }
        String params = "?companyId=" + this.companyId;
        JSONObject result = new JSONObject();
        try {
            String response = HttpSendUtil.sendHttpPost((String)this.farmServerUrl, (String)"/user/lyt/login", (String)params, (String)userInfo.toString());
            result = JSONObject.parseObject((String)response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateSxUserId(List<LytUser> userList) {
        this.lytUserMapper.updateSxUserId(userList);
    }

    public List<LytRole> queryUserRoleIdList(String code) {
        return this.lytRoleMapper.queryRoleUserGt0List(code);
    }

    @Transactional
    public LytUser queryLytAppUserInfo(String appUserId, String token) {
        AES aes;
        JSONObject resJson;
        LytUser lytUser = new LytUser();
        JSONObject json = new JSONObject();
        json.put("appUserId", (Object)appUserId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", token);
        headers.put("Content-type", "application/x-www-form-urlencoded;charset=utf-8");
        String result = HttpSendUtil.sendHttpGet((String)(this.lytUrl + "lytlhsrv/srv/oauth/getUserInfo?appUserId=" + appUserId), headers);
        log.error("\u9f99\u6e38\u901a\u65b0\u7528\u6237\u70b9\u51fb\u8fdb\u5165\u667a\u6167\u7cae\u8111\u4fe1\u606f\uff1a", (Object)result);
        if (!StringUtil.isNullOrEmpty((String)result) && (resJson = JSONObject.parseObject((String)(result = (aes = new AES(token.replaceFirst("Bearer ", "") + appUserId)).Decrypt(result)))).getInteger("rt") == 1) {
            if ((resJson = resJson.getJSONObject("object")) == null) {
                return lytUser;
            }
            String avatar = resJson.getString("appUserIcon");
            String mobile = resJson.getString("appUserPhone");
            String realName = resJson.getString("realName");
            String userRole = resJson.getString("userRole");
            lytUser = new LytUser(realName, avatar, mobile);
            lytUser.setOrigin(Integer.valueOf(1));
            lytUser.setUserId(appUserId);
            this.lytUserMapper.insertOrUpdate(lytUser);
            LytRoleUser roleUser = new LytRoleUser(appUserId, this.farmRoleId, this.lesseeCode);
            this.lytRoleMapper.upSertRoleUserBatch(Arrays.asList(roleUser), this.lesseeCode);
            OrganizationUser organizationUser = new OrganizationUser(this.farmOrgId, appUserId);
            this.organizationMapper.sertOrUpdateOrgUserBatch(Arrays.asList(organizationUser), this.lesseeCode);
            lytUser = this.queryUserAllInfoByPhone(mobile, "");
        }
        return lytUser;
    }

    public Set<Integer> queryUserLevel(String userId, List<LytRole> roleList) {
        LinkedHashSet<Integer> levelSet = new LinkedHashSet<Integer>();
        levelSet.add(4);
        List listp0 = Arrays.asList(this.roleP0.split(",")).stream().mapToInt(num -> Integer.parseInt(num)).boxed().collect(Collectors.toList());
        List listp1 = Arrays.asList(this.roleP1.split(",")).stream().mapToInt(num -> Integer.parseInt(num)).boxed().collect(Collectors.toList());
        List listp2 = Arrays.asList(this.roleP2.split(",")).stream().mapToInt(num -> Integer.parseInt(num)).boxed().collect(Collectors.toList());
        List list2 = Arrays.asList(this.role2.split(",")).stream().mapToInt(num -> Integer.parseInt(num)).boxed().collect(Collectors.toList());
        List list3 = Arrays.asList(this.role3.split(",")).stream().mapToInt(num -> Integer.parseInt(num)).boxed().collect(Collectors.toList());
        if (roleList != null && roleList.size() > 0) {
            for (int i = 0; i < roleList.size(); ++i) {
                Integer rolePId = roleList.get(i).getRolePid();
                if (listp0.contains(rolePId)) {
                    levelSet.add(0);
                    continue;
                }
                if (listp1.contains(rolePId)) {
                    levelSet.add(1);
                    continue;
                }
                if (!listp2.contains(rolePId)) continue;
                Integer roleId = roleList.get(i).getRoleId();
                if (list2.contains(roleId)) {
                    levelSet.add(2);
                    continue;
                }
                if (!list3.contains(roleId)) continue;
                levelSet.add(3);
            }
        }
        return levelSet;
    }

    public List<String> queryUserIdListByRole() {
        return this.lytRoleMapper.queryUserIdListByRole();
    }

    public Set<String> queryUserRegionList(String userId) {
        List regionCodeList = this.lytDistrictMapper.queryUserRegionList(userId);
        HashSet<String> recodeSet = new HashSet<String>();
        for (String regionCode : regionCodeList) {
            if (regionCode.endsWith("000000")) {
                regionCode = regionCode.substring(0, regionCode.lastIndexOf("000000"));
            } else if (regionCode.endsWith("000")) {
                regionCode = regionCode.substring(0, regionCode.lastIndexOf("000"));
            }
            recodeSet.add(regionCode);
        }
        return recodeSet;
    }

    public JSONObject queryGridUserList(String regionCode, Integer start, Integer pageSize) {
        JSONObject json = new JSONObject();
        Integer count = this.lytUserMapper.queryGridUserCount(regionCode);
        List list = this.lytUserMapper.queryGridUserList(regionCode, start, pageSize);
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject postGridUser(GridUserInfo gridUserInfo) {
        if (gridUserInfo != null) {
            gridUserInfo.setCompanyId(Integer.valueOf(this.companyId));
            GridUserInfo sqlUser = this.lytUserMapper.queryGridUserByPhone(gridUserInfo.getPhone());
            if (sqlUser != null) {
                gridUserInfo.setId(sqlUser.getId());
                this.lytUserMapper.updateGridUser(gridUserInfo);
            } else {
                this.lytUserMapper.insertGridUser(gridUserInfo);
            }
        }
        this.fieldDoubleStatusMapper.updateFieldGridUser(gridUserInfo.getId(), gridUserInfo.getGridCode());
        return new JSONObject();
    }

    public GridUserInfo queryGridUserByPhone(String phone) {
        return this.lytUserMapper.queryGridUserByPhone(phone);
    }

    public List<UserSmsResultMap> queryGridUserMsgList() {
        return this.lytUserMapper.queryGridUserMsgList();
    }

    public void insertOrUpdateUserArea(JSONArray areaArray, String userId) {
        LinkedList<String> regionCodeList = new LinkedList<String>();
        String regionCode = "";
        for (int i = 0; i < areaArray.size(); ++i) {
            regionCode = areaArray.getJSONObject(i).getString("regionCode");
            if (regionCode.length() == 6) {
                regionCode = regionCode.concat("000000");
            } else if (regionCode.length() == 9) {
                regionCode = regionCode.concat("000");
            }
            regionCodeList.add(regionCode);
        }
        List areaIdList = this.lytDistrictMapper.queryAdmIdList(regionCodeList);
        this.lytDistrictMapper.insertOrUpdateUserArea(areaIdList, userId);
    }

    public LytUser upSertLytUser(String mobile, String userName, String avatar, String userId) {
        LytUser lytUser = this.lytUserMapper.queryByPhone(mobile);
        if (lytUser == null) {
            lytUser = new LytUser();
            lytUser.setUserId(userId);
            if (StringUtils.isNotBlank((String)avatar)) {
                lytUser.setAvatar(avatar);
            }
            lytUser.setMobile(mobile);
            lytUser.setUserName(userName);
            lytUser.setOrigin(Integer.valueOf(2));
            this.lytUserMapper.insertOrUpdate(lytUser);
        }
        return lytUser;
    }

    public void delUser(String userId) {
        LytUser lytUser = this.lytUserMapper.queryById(userId);
        if (lytUser.getOrigin() == 2) {
            this.lytUserMapper.deleteById(userId);
            this.lytRoleMapper.deleteByUserId(userId);
            this.lytDistrictMapper.deleteGridByPhone(lytUser.getMobile());
            this.lytDistrictMapper.deleteUserId(userId);
        }
    }

    public LytUser queryUserAllInfoByUserId(String userId) {
        LytUser lytUser = new LytUser();
        lytUser.setUserId(userId);
        List list = this.lytUserMapper.queryAll(lytUser);
        if (list != null && list.size() > 0) {
            List roleList;
            lytUser = (LytUser)list.get(0);
            List organList = this.lytOrganizationMapper.queryAllByUserId(lytUser.getUserId());
            if (organList != null && organList.size() > 0) {
                lytUser.setOrgList(organList);
            }
            if ((roleList = this.lytRoleMapper.queryAllByUserId(lytUser.getUserId())) != null && roleList.size() > 0) {
                lytUser.setRoleList(roleList);
            }
            List permissionList = this.permissionService.queryAllByUserId(lytUser.getUserId(), Integer.valueOf(3));
            lytUser.setPermissionList(permissionList);
            return lytUser;
        }
        return null;
    }

    public void delUserArea(String userId) {
        this.lytDistrictMapper.deleteUserId(userId);
    }

    public void delGridUser(String userId) {
        LytUser user = this.lytUserMapper.queryById(userId);
        this.lytDistrictMapper.deleteGridByPhone(user.getMobile());
    }

    public LytUser queryUserAllInfoByPhoneOrName(String phone, String userName) {
        LytUser lytUser = new LytUser();
        if (StringUtils.isNotBlank((String)phone)) {
            lytUser.setMobile(phone);
        } else if (StringUtils.isNotBlank((String)userName)) {
            lytUser.setUserName(userName);
        }
        List list = this.lytUserMapper.queryAll(lytUser);
        if (list != null && list.size() > 0) {
            List roleList;
            lytUser = (LytUser)list.get(0);
            List organList = this.lytOrganizationMapper.queryAllByUserId(lytUser.getUserId());
            if (organList != null && organList.size() > 0) {
                lytUser.setOrgList(organList);
            }
            if ((roleList = this.lytRoleMapper.queryAllByUserId(lytUser.getUserId())) != null && roleList.size() > 0) {
                lytUser.setRoleList(roleList);
            }
            List permissionList = this.permissionService.queryPcPermissionByUser(lytUser.getUserId());
            lytUser.setPermissionList(permissionList);
        }
        return lytUser;
    }

    public void updateUserInfo(LytUser lytUser) {
        this.lytUserMapper.updateSxUserId(Arrays.asList(lytUser));
    }

    public JSONObject queryUserInfoByZzd(String tenantId, String accountId, String nickName) {
        JSONObject json = new JSONObject();
        List phoneList = new ArrayList();
        String phone = this.lytUserMapper.queryUserPhoneByZzd(tenantId, accountId);
        if (StringUtils.isBlank((String)phone) && (phoneList = this.lytUserMapper.queryUserPhoneByUserName(nickName)) != null && phoneList.size() > 0) {
            StringBuffer phoneStr = new StringBuffer();
            for (String it : phoneList) {
                phoneStr.append(it).append(",");
            }
            try {
                JSONArray array = this.organService.queryEmployeeByMobiles(phoneStr.substring(0, phoneStr.length() - 1), Long.valueOf(tenantId));
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject phoneJson = array.getJSONObject(i);
                    if (!Objects.equals(phoneJson.getInteger("accountId").toString(), accountId)) continue;
                    phone = phoneJson.getString("mobile");
                    log.error("\u6267\u884c\u63d2\u5165\u8bed\u53e5\u6570\u636e\uff1a{}", (Object)phoneJson.toString());
                    this.lytUserMapper.upSertZzdUserPhone(tenantId, accountId, phone);
                    break;
                }
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u7528\u6237accountId\u6570\u636e\u62a5\u9519 {}", (Object)e.getMessage());
            }
        }
        json.put("phone", (Object)phone);
        json.put("phoneList", phoneList);
        return json;
    }

    public JSONObject queryLandlordByPhone(String phone) {
        JSONObject json = new JSONObject();
        AgriserveLandlord it = new AgriserveLandlord();
        Integer landlordType = 2;
        try {
            it = this.lytUserMapper.queryLandlordByPhone(phone);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (it != null && it.getType() != null) {
            landlordType = it.getType();
        }
        json.put("landlordType", (Object)landlordType);
        return json;
    }

    public List<LytUser> queryHeadUserListByFieldStatusId(String regionCode, Integer roleId) {
        return this.lytUserMapper.queryHeadUserListByFieldStatusId(regionCode, roleId);
    }

    public List<LytUser> queryHeadUserListByRoleId(String regionCode, Integer roleId) {
        return this.lytUserMapper.queryHeadUserListByRoleId(regionCode, roleId);
    }

    private List<LytRole> covertAllRole(LytRole role, List<LytRole> roleList) {
        List subList = role.getSubList();
        if (subList != null && subList.size() > 0) {
            roleList.addAll(subList);
            for (int i = 0; i < subList.size(); ++i) {
                roleList = this.covertAllRole((LytRole)subList.get(i), roleList);
            }
        }
        return roleList;
    }

    private List<LytDistrict> covertAllDistrict(LytDistrict lytDistrict, List<LytDistrict> lytDistrictList) {
        List subList = lytDistrict.getChildren();
        if (subList != null && subList.size() > 0) {
            lytDistrictList.addAll(subList);
            for (int i = 0; i < subList.size(); ++i) {
                lytDistrictList = this.covertAllDistrict((LytDistrict)subList.get(i), lytDistrictList);
            }
        }
        return lytDistrictList;
    }

    private List<LytOrganization> covertAll(LytOrganization lytOrganization, List<LytOrganization> organList) {
        List subList = lytOrganization.getSubList();
        if (subList != null && subList.size() > 0) {
            organList.addAll(subList);
            for (int i = 0; i < subList.size(); ++i) {
                organList = this.covertAll((LytOrganization)subList.get(i), organList);
            }
        }
        return organList;
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("222");
        list.add("444");
        list.add("666");
        System.out.println(Arrays.toString(list.toArray()));
    }
}

