/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.xxpt.gateway.shared.api.request.OapiGetJsapiTokenJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiGettokenJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiMoziEmployeeGetByMobilesRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiRpcOauth2DingtalkAppUserJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.response.OapiGetJsapiTokenJsonResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiGettokenJsonResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiMoziEmployeeGetByMobilesResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiRpcOauth2DingtalkAppUserJsonResponse;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentPostClient;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiRequest;
import com.farm.bean.BaseUserImport;
import com.farm.bean.BaseUserInfoBean;
import com.farm.bean.BaseUserInfoBeanExport;
import com.farm.bean.LytOrganization;
import com.farm.bean.LytUser;
import com.farm.bean.OrganizationUser;
import com.farm.config.ZzdConfig;
import com.farm.mapper.LytOrganizationMapper;
import com.farm.mapper.LytRoleMapper;
import com.farm.mapper.LytUserMapper;
import com.farm.service.ConfigService;
import com.farm.service.OrganService;
import com.farm.util.EasyExcelUtil;
import com.farm.util.RandomUtil;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OrganServiceImpl
implements OrganService {
    private static final Logger log = LoggerFactory.getLogger(OrganServiceImpl.class);
    @Autowired
    private LytOrganizationMapper organizationMapper;
    @Value(value="${lyt.lesseeCode}")
    private String lesseeCode;
    @Autowired
    private LytUserMapper lytUserMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ConfigService configService;
    @Autowired
    private LytRoleMapper lytRoleMapper;
    @Value(value="${branch}")
    private String branch;

    public List<LytOrganization> queryAllEmptySxOrgIdList(String companyId) {
        LinkedList<LytOrganization> list = new LinkedList();
        List<Integer> parentIdList = Arrays.asList(0);
        list = this.queryAllByLevelDown(list, parentIdList);
        list = list.stream().filter(it -> it.getSxOrgId() == null).collect(Collectors.toList());
        return list;
    }

    public List<LytUser> queryAllEmptyUserIdList(String lesseeCode, Integer limit, int pageSize) {
        List list = this.lytUserMapper.queryEmptySxUserIdList(lesseeCode, limit, pageSize);
        return list;
    }

    public List<LytOrganization> queryOrganList(String userId, String orgId) {
        ArrayList<LytOrganization> list = new ArrayList();
        if (StringUtils.isBlank((String)orgId)) {
            LytOrganization lo = this.organizationMapper.queryById(Integer.valueOf(20001));
            list.add(lo);
        } else {
            list = this.organizationMapper.queryChildOrgByParentId(orgId);
        }
        return list;
    }

    public List<LytOrganization> queryAllByLevelDown(List<LytOrganization> list, List<Integer> orgIdList) {
        List sonList = this.organizationMapper.queryAllListByP(orgIdList, this.lesseeCode);
        if (sonList != null && sonList.size() > 0) {
            orgIdList = sonList.stream().map(it -> it.getOrgId()).collect(Collectors.toList());
            list.addAll(sonList);
            return this.queryAllByLevelDown(list, orgIdList);
        }
        return list;
    }

    public static List<LytOrganization> getChildsList(List<LytOrganization> list, int pid) {
        ArrayList<LytOrganization> arr = new ArrayList<LytOrganization>();
        for (LytOrganization item : list) {
            if (pid != item.getOrgPid()) continue;
            arr.addAll(OrganServiceImpl.getChildsList(list, (int)item.getOrgId()));
            arr.add(item);
        }
        return arr;
    }

    public JSONObject queryUserList(String userId, String orgId, Integer begin, Integer pageSize, String search) {
        List jsonObjects;
        HashSet<String> ids = this.organizationMapper.queryChildOrgList(orgId);
        if (ids == null) {
            ids = new HashSet<String>();
        }
        ids.add(orgId);
        if (!StringUtils.isEmpty((String)search) && !CollectionUtils.isEmpty((Collection)(jsonObjects = this.lytUserMapper.queryUserAndOrgBySearch(search)))) {
            for (JSONObject jso : jsonObjects) {
                if (null == jso || !jso.containsKey((Object)"org_id") || StringUtils.isEmpty((String)jso.getString("org_id"))) continue;
                ids.add(jso.getString("org_id"));
            }
        }
        List list = this.lytUserMapper.queryuserListByOrgId(ids, begin, pageSize, search);
        for (BaseUserInfoBean b : list) {
            if (StringUtils.isBlank((String)b.getMobile()) || b.getMobile().length() != 11) continue;
            b.setMobile(b.getMobile().substring(0, 3) + "****" + b.getMobile().substring(7, b.getMobile().length()));
        }
        Integer count = this.lytUserMapper.queryuserListByOrgIdCount(ids, search);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public void exportQueryUserListInfo(HttpServletResponse response, String orgId) throws IOException {
        HashSet<String> ids = this.organizationMapper.queryChildOrgList(orgId);
        if (ids == null) {
            ids = new HashSet<String>();
        }
        ids.add(orgId);
        List list = this.lytUserMapper.queryuserListByOrgId(ids, null, null, "");
        ArrayList baseUserInfoBeanExportList = new ArrayList();
        list.forEach(item -> baseUserInfoBeanExportList.add(BaseUserInfoBeanExport.generateExport((BaseUserInfoBean)item)));
        EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u7528\u6237\u4fe1\u606f", BaseUserInfoBeanExport.class, (String)"\u7528\u6237\u4fe1\u606f", baseUserInfoBeanExportList);
    }

    public void addOrUpdateOraganization(String userId, String orgId, String orgPid, String orgName, Integer fromType, Integer organizationType) {
        if (StringUtil.isNullOrEmpty((String)orgId)) {
            orgId = String.valueOf(RandomUtil.genRandomOrgStr());
            this.organizationMapper.addOraganization(orgPid, orgName, fromType, organizationType, this.lesseeCode, orgId);
        } else {
            this.organizationMapper.updateOraganization(orgId, orgPid, orgName, fromType, organizationType);
        }
    }

    public void delOraganization(String[] idArray) {
        for (String id : idArray) {
            this.organizationMapper.deleteById(Integer.valueOf(id));
        }
    }

    public void upsertOrgUser(JSONArray orgArray, String userId) {
        this.organizationMapper.delOrgUserByUserId(userId);
        LinkedList<OrganizationUser> list = new LinkedList<OrganizationUser>();
        for (int i = 0; i < orgArray.size(); ++i) {
            OrganizationUser organizationUser = new OrganizationUser(orgArray.getJSONObject(i).getString("orgId"), userId);
            list.add(organizationUser);
        }
        this.organizationMapper.sertOrUpdateOrgUserBatch(list, this.lesseeCode);
    }

    public Integer queryAllEmptyUserIdCount(String lesseeCode) {
        return this.lytUserMapper.queryAllEmptyUserIdCount(lesseeCode);
    }

    public String queryAccessToken() {
        String ddTokenKey = "ddAccessToken";
        String accessToken = "";
        if (this.redisTemplate.hasKey((Object)ddTokenKey).booleanValue()) {
            accessToken = (String)this.redisTemplate.opsForValue().get((Object)ddTokenKey);
            log.error("\u76f4\u63a5\u7f13\u5b58\u53d6\u5230\u7684token\u83b7\u53d6\u7ed3\u679c\uff1a{}", (Object)accessToken);
        } else {
            ZzdConfig zzdConfig = new ZzdConfig();
            IntelligentGetClient intelligentGetClient = zzdConfig.genExecutableClient().newIntelligentGetClient("/gettoken.json");
            OapiGettokenJsonRequest oapiGettokenJsonRequest = new OapiGettokenJsonRequest();
            oapiGettokenJsonRequest.setAppkey(ZzdConfig.zzdAppKey);
            oapiGettokenJsonRequest.setAppsecret(ZzdConfig.zzdAppSecret);
            OapiGettokenJsonResponse apiResult = (OapiGettokenJsonResponse)intelligentGetClient.get((OapiRequest)oapiGettokenJsonRequest);
            log.error("token\u83b7\u53d6\u7ed3\u679c\uff1a{},{},{},{},{}", new Object[]{apiResult.getBizErrorCode(), apiResult.getCode(), apiResult.getHostId(), apiResult.getMessage(), apiResult.getSuccess()});
            if (apiResult.getSuccess().booleanValue()) {
                log.error("toke\u771f\u5b9e\u83b7\u53d6\u7ed3\u679c\uff1a{},{},{},{}", new Object[]{apiResult.getContent().getResponseCode(), apiResult.getContent().getData(), apiResult.getContent().getResponseMessage(), apiResult.getContent().getSuccess()});
                JSONObject json = JSONObject.parseObject((String)apiResult.getContent().getData());
                accessToken = json.getString("accessToken");
                Long expiresIn = json.getLong("expiresIn");
                this.redisTemplate.opsForValue().set((Object)ddTokenKey, (Object)accessToken, expiresIn.longValue(), TimeUnit.SECONDS);
            }
        }
        return accessToken;
    }

    public JSONObject queryJsApiTokenByAcToken(String accessToken) {
        ZzdConfig zzdConfig = new ZzdConfig();
        IntelligentGetClient intelligentGetClient = zzdConfig.genExecutableClient().newIntelligentGetClient("/get_jsapi_token.json");
        OapiGetJsapiTokenJsonRequest oapiGetJsapiTokenJsonRequest = new OapiGetJsapiTokenJsonRequest();
        oapiGetJsapiTokenJsonRequest.setAccessToken(accessToken);
        OapiGetJsapiTokenJsonResponse apiResult = (OapiGetJsapiTokenJsonResponse)intelligentGetClient.get((OapiRequest)oapiGetJsapiTokenJsonRequest);
        JSONObject json = new JSONObject();
        if (apiResult.getSuccess().booleanValue()) {
            json = JSONObject.parseObject((String)apiResult.getContent().getData());
        }
        return json;
    }

    public JSONArray queryEmployeeByMobiles(String mobiles, Long tenantId) {
        ZzdConfig zzdConfig = new ZzdConfig();
        IntelligentGetClient intelligentGetClient = zzdConfig.genExecutableClient().newIntelligentGetClient("/mozi/employee/get_by_mobiles");
        OapiMoziEmployeeGetByMobilesRequest oapiMoziEmployeeGetByMobilesRequest = new OapiMoziEmployeeGetByMobilesRequest();
        oapiMoziEmployeeGetByMobilesRequest.setAreaCode("86");
        oapiMoziEmployeeGetByMobilesRequest.setMobiles(mobiles);
        oapiMoziEmployeeGetByMobilesRequest.setTenantId(tenantId);
        oapiMoziEmployeeGetByMobilesRequest.setNamespace("local");
        OapiMoziEmployeeGetByMobilesResponse apiResult = (OapiMoziEmployeeGetByMobilesResponse)intelligentGetClient.get((OapiRequest)oapiMoziEmployeeGetByMobilesRequest);
        return JSONArray.parseArray((String)apiResult.getContent().getData());
    }

    public JSONObject queryUserInfoByAuthCode(String authCode, String accessToken) {
        ZzdConfig zzdConfig = new ZzdConfig();
        IntelligentPostClient intelligentPostClient = zzdConfig.genExecutableClient().newIntelligentPostClient("/rpc/oauth2/dingtalk_app_user.json");
        OapiRpcOauth2DingtalkAppUserJsonRequest oapiRpcOauth2DingtalkAppUserJsonRequest = new OapiRpcOauth2DingtalkAppUserJsonRequest();
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAccess_token(accessToken);
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAuth_code(authCode);
        OapiRpcOauth2DingtalkAppUserJsonResponse apiResult = (OapiRpcOauth2DingtalkAppUserJsonResponse)intelligentPostClient.post((OapiRequest)oapiRpcOauth2DingtalkAppUserJsonRequest);
        log.error("\u8f93\u51faauthCode\u83b7\u53d6\u7ed3\u679c\uff1a{},{},{},{},{}", new Object[]{apiResult.getBizErrorCode(), apiResult.getCode(), apiResult.getHostId(), apiResult.getMessage(), apiResult.getSuccess()});
        log.error("\u8f93\u51faauthCode\u5b98\u65b9\u83b7\u53d6\u7684\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)apiResult.getContent());
        JSONObject json = JSONObject.parseObject((String)apiResult.getContent());
        return json;
    }

    public Boolean batchInsert(List<BaseUserImport> list) {
        LytOrganization lytOrganization;
        List userList = this.lytUserMapper.queryListByPhone(list);
        ArrayList insertList = new ArrayList();
        ArrayList allList = new ArrayList();
        if (list != null && list.size() > 0) {
            list.forEach(it -> {
                boolean flag = false;
                for (BaseUserImport info : userList) {
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)it.getMobile(), (CharSequence)info.getMobile())) continue;
                    flag = true;
                    info.setOrgName(it.getOrgName());
                    break;
                }
                if (!flag) {
                    it.setUserId("sx" + it.getMobile());
                    insertList.add(it);
                }
            });
        }
        if (insertList != null && insertList.size() > 0) {
            int userNum = this.lytUserMapper.insertBatch(insertList);
            int n = this.lytRoleMapper.importRoleUserBatch(insertList, this.lesseeCode);
        }
        List lytOrganizations = null;
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.branch, (CharSequence)"prod")) {
            lytOrganizations = this.organizationMapper.queryChildOrgByParentId("38244358");
            lytOrganization = this.organizationMapper.queryById(Integer.valueOf(1658125603));
            lytOrganizations.add(lytOrganization);
        } else {
            lytOrganizations = this.organizationMapper.queryChildOrgByParentId("38244358");
            lytOrganization = this.organizationMapper.queryById(Integer.valueOf(1665213484));
            lytOrganizations.add(lytOrganization);
        }
        allList.addAll(insertList);
        allList.addAll(userList);
        this.organizationMapper.delOrgUserByUserIds(allList);
        LinkedList orgList = new LinkedList();
        List finalLytOrganizations = lytOrganizations;
        allList.forEach(it -> {
            for (LytOrganization organization : finalLytOrganizations) {
                OrganizationUser organizationUser;
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)it.getOrgName(), (CharSequence)organization.getOrgName())) {
                    organizationUser = new OrganizationUser(String.valueOf(organization.getOrgId()), it.getUserId());
                    orgList.add(organizationUser);
                    continue;
                }
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)it.getOrgName(), (CharSequence)"\u9f99\u6e38\u53bf") || !org.apache.commons.lang3.StringUtils.equals((CharSequence)organization.getOrgName(), (CharSequence)"\u9f99\u6e38\u53bf\u673a\u5173\u5e72\u90e8")) continue;
                organizationUser = new OrganizationUser(String.valueOf(organization.getOrgId()), it.getUserId());
                orgList.add(organizationUser);
            }
        });
        this.organizationMapper.sertOrUpdateOrgUserBatch(orgList, this.lesseeCode);
        return true;
    }
}

