/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DoubleFieldFile;
import com.farm.bean.RegionStatusArea;
import com.farm.bean.resultMap.FieldDSMap;
import com.farm.bean.resultMap.FieldDSMapPlus;
import com.farm.mapper.DoubleFieldFileMapper;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.mapper.LytRoleMapper;
import com.farm.mapper.RegionStatusAreaMapper;
import com.farm.service.ConfigService;
import com.farm.service.RegionStatusAreaService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="regionStatusAreaService")
public class RegionStatusAreaServiceImpl
implements RegionStatusAreaService {
    @Resource
    private RegionStatusAreaMapper regionStatusAreaMapper;
    @Autowired
    private ConfigService configService;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private LytRoleMapper lytRoleMapper;
    @Autowired
    private DoubleFieldFileMapper doubleFieldFileMapper;

    public RegionStatusArea queryById(Integer id) {
        return this.regionStatusAreaMapper.queryById(id);
    }

    public List<RegionStatusArea> queryAllByLimit(int offset, int limit) {
        return this.regionStatusAreaMapper.queryAllByLimit(offset, limit);
    }

    public RegionStatusArea insert(RegionStatusArea regionStatusArea) {
        this.regionStatusAreaMapper.insert(regionStatusArea);
        return regionStatusArea;
    }

    public RegionStatusArea update(RegionStatusArea regionStatusArea) {
        this.regionStatusAreaMapper.update(regionStatusArea);
        return this.queryById(regionStatusArea.getId());
    }

    public List<RegionStatusArea> queryAllByRegionCode(String regionCode, String date) {
        return null;
    }

    public Object queryDailyDataStatistics(String regionCode, String date, Integer codeType) {
        String today = LocalDate.now().toString();
        List<String> regionList = new ArrayList<String>();
        if (codeType == 1) {
            regionList = this.configService.queryDownRegions(regionCode);
        } else {
            regionList.add(regionCode);
        }
        Integer aField = 0;
        Double aArea = 0.0;
        Integer bField = 0;
        Double bArea = 0.0;
        Integer cField = 0;
        Double cArea = 0.0;
        Integer dField = 0;
        Double dArea = 0.0;
        List list = new ArrayList();
        if (date.indexOf(today) > -1) {
            List<Integer> type = Arrays.asList(1, 2, 3, 10, 11, 12);
            List typeList = this.fieldDoubleStatusMapper.queryFieldListByDate(date, (List)type, regionList);
            list.addAll(typeList);
            type = Arrays.asList(4, 5, 6);
            typeList = this.fieldDoubleStatusMapper.queryIdenListByDate(date, type, regionList);
            list.addAll(typeList);
            type = Arrays.asList(7, 8, 9);
            typeList = this.fieldDoubleStatusMapper.queryFixListByDate(date, type, regionList);
            list.addAll(typeList);
        } else {
            list = this.regionStatusAreaMapper.queryInfoByRegionCodeList(regionList, date);
        }
        for (RegionStatusArea rsa : list) {
            Integer status = rsa.getStatus();
            Integer count = rsa.getCounts();
            Double area = (double)rsa.getArea();
            if (status == 1 || status == 2 || status == 3) {
                aField = aField + count;
                aArea = aArea + area;
                continue;
            }
            if (status == 4 || status == 5 || status == 6) {
                bField = bField + count;
                bArea = bArea + area;
                continue;
            }
            if (status == 7 || status == 8 || status == 9) {
                cField = cField + count;
                cArea = cArea + area;
                continue;
            }
            if (status != 10 && status != 11 && status != 12) continue;
            dField = dField + count;
            dArea = dArea + area;
        }
        Object obj = this.queryVillageDataStatistics(regionList);
        JSONObject json = new JSONObject();
        json.put("aField", (Object)aField);
        json.put("aArea", (Object)String.format("%.2f", aArea));
        json.put("bField", (Object)bField);
        json.put("bArea", (Object)String.format("%.2f", bArea));
        json.put("cField", (Object)cField);
        json.put("cArea", (Object)String.format("%.2f", cArea));
        json.put("dField", (Object)dField);
        json.put("dArea", (Object)String.format("%.2f", dArea));
        json.put("obj", obj);
        return json;
    }

    public Object queryVillageDataStatistics(List<String> regionList) {
        List list = this.regionStatusAreaMapper.queryVillageDataByRegionList(regionList);
        ArrayList data = new ArrayList();
        for (Map map : list) {
            Integer status = Integer.valueOf(map.get("status").toString());
            Double area = Double.valueOf(map.get("area").toString());
            Double a = 0.0;
            Double b = 0.0;
            Double c = 0.0;
            Double d = 0.0;
            if (status == 1 || status == 2 || status == 3) {
                a = area;
            } else if (status == 4 || status == 5 || status == 6) {
                b = area;
            } else if (status == 7 || status == 8 || status == 9) {
                c = area;
            } else if (status == 10 || status == 11 || status == 12) {
                d = area;
            }
            if (data.size() == 0) {
                HashMap<String, String> n = new HashMap<String, String>();
                n.put("regionCode", map.get("regionCode").toString());
                n.put("regionName", map.get("regionName").toString());
                n.put("a", String.format("%.2f", a));
                n.put("b", String.format("%.2f", b));
                n.put("c", String.format("%.2f", c));
                n.put("d", String.format("%.2f", d));
                data.add(n);
                continue;
            }
            boolean flag = false;
            for (Map map2 : data) {
                if (!((String)map2.get("regionCode")).equals(map.get("regionCode").toString())) continue;
                map2.put("a", String.format("%.2f", a + Double.valueOf((String)map2.get("a"))));
                map2.put("b", String.format("%.2f", b + Double.valueOf((String)map2.get("b"))));
                map2.put("c", String.format("%.2f", c + Double.valueOf((String)map2.get("c"))));
                map2.put("d", String.format("%.2f", d + Double.valueOf((String)map2.get("d"))));
                flag = true;
            }
            if (flag) continue;
            HashMap<String, String> n = new HashMap<String, String>();
            n.put("regionCode", map.get("regionCode").toString());
            n.put("regionName", map.get("regionName").toString());
            n.put("a", String.format("%.2f", a));
            n.put("b", String.format("%.2f", b));
            n.put("c", String.format("%.2f", c));
            n.put("d", String.format("%.2f", d));
            data.add(n);
        }
        return data;
    }

    public Object queryUserDataStatistics(String regionCode) {
        List regionList = this.fieldDoubleStatusMapper.queryChildList(regionCode);
        List list = this.regionStatusAreaMapper.queryInfoByRegionList(regionList);
        ArrayList data = new ArrayList();
        for (Map map : list) {
            Integer status = Integer.valueOf(map.get("status").toString());
            Double area = Double.valueOf(map.get("area").toString());
            Double a = 0.0;
            Double b = 0.0;
            Double c = 0.0;
            Double d = 0.0;
            if (status == 1 || status == 2 || status == 3) {
                a = area;
            } else if (status == 4 || status == 5 || status == 6) {
                b = area;
            } else if (status == 7 || status == 8 || status == 9) {
                c = area;
            } else if (status == 10 || status == 11 || status == 12) {
                d = area;
            }
            if (data.size() == 0) {
                HashMap<String, String> n = new HashMap<String, String>();
                n.put("userId", map.get("userId").toString());
                n.put("userName", String.valueOf(map.get("userName")));
                n.put("a", String.format("%.2f", a));
                n.put("b", String.format("%.2f", b));
                n.put("c", String.format("%.2f", c));
                n.put("d", String.format("%.2f", d));
                data.add(n);
                continue;
            }
            boolean flag = false;
            for (Map map2 : data) {
                if (!((String)map2.get("userId")).equals(map.get("userId").toString())) continue;
                map2.put("a", String.format("%.2f", a + Double.valueOf((String)map2.get("a"))));
                map2.put("b", String.format("%.2f", b + Double.valueOf((String)map2.get("b"))));
                map2.put("c", String.format("%.2f", c + Double.valueOf((String)map2.get("c"))));
                map2.put("d", String.format("%.2f", d + Double.valueOf((String)map2.get("d"))));
                flag = true;
            }
            if (flag) continue;
            HashMap<String, String> n = new HashMap<String, String>();
            n.put("userId", map.get("userId").toString());
            n.put("userName", String.valueOf(map.get("userName")));
            n.put("a", String.format("%.2f", a));
            n.put("b", String.format("%.2f", b));
            n.put("c", String.format("%.2f", c));
            n.put("d", String.format("%.2f", d));
            data.add(n);
        }
        return data;
    }

    public List<FieldDSMap> queryDownSummaryGroupStatus(String regionCode, String date, String areaType, String statusType) {
        List list = new ArrayList();
        statusType = Objects.equals(statusType, "1") ? "(1,4,7)" : (Objects.equals(statusType, "2") ? "(2,5,8)" : (Objects.equals(statusType, "3") ? "(3,6,9)" : ""));
        list = Objects.equals(date, LocalDate.now().toString()) ? this.regionStatusAreaMapper.querySummaryGroupStatusInTime(regionCode, regionCode.length() + 3, areaType, statusType) : this.regionStatusAreaMapper.querySummaryGroupStatus(regionCode, date, regionCode.length() + 3, areaType, statusType);
        Map<String, List<RegionStatusArea>> map = list.stream().collect(Collectors.groupingBy(it -> it.getRegionCode()));
        LinkedList<FieldDSMap> list1 = new LinkedList<FieldDSMap>();
        for (String regionCode1 : map.keySet()) {
            list1.add(this.queryFieldDSMap(map.get(regionCode1), regionCode1));
        }
        return list1;
    }

    public FieldDSMap querySummaryGroupStatus(String regionCode, String date, String areaType, String statusType) {
        List list = new ArrayList();
        statusType = Objects.equals(statusType, "1") ? "(1,4,7,10)" : (Objects.equals(statusType, "2") ? "(2,5,8,11)" : (Objects.equals(statusType, "3") ? "(3,6,9,12)" : ""));
        list = Objects.equals(date, LocalDate.now().toString()) ? this.regionStatusAreaMapper.querySummaryGroupStatusInTime(regionCode, regionCode.length(), areaType, statusType) : this.regionStatusAreaMapper.querySummaryGroupStatus(regionCode, date, regionCode.length(), areaType, statusType);
        return this.queryFieldDSMap(list, regionCode);
    }

    public JSONObject queryGridLeaderList(String regionCode) {
        String today = LocalDate.now().toString();
        String roleId = "7777777";
        List list = this.regionStatusAreaMapper.queryGridLeaderList(regionCode, roleId);
        LinkedList<FieldDSMapPlus> resList = new LinkedList<FieldDSMapPlus>();
        for (FieldDSMapPlus dsMapPlus : list) {
            FieldDSMap dsMap = this.querySummaryGroupStatus(dsMapPlus.getRegionCode(), today, "0", "2");
            dsMapPlus = new FieldDSMapPlus(dsMap, dsMapPlus.getPhone(), dsMapPlus.getUserName());
            resList.add(dsMapPlus);
        }
        JSONObject json = new JSONObject();
        json.put("list", resList);
        return json;
    }

    public void sendGridLeaderFixInfo(DoubleFieldFile fieldFile, JSONArray array, JSONArray regionCodeArray) {
        DoubleFieldFile[] dffArray = new DoubleFieldFile[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            DoubleFieldFile it = new DoubleFieldFile();
            BeanUtils.copyProperties((Object)fieldFile, (Object)it);
            it.setPhone(array.getString(i));
            it.setRegionCode(regionCodeArray.getString(i));
            dffArray[i] = it;
        }
        List<DoubleFieldFile> list = Arrays.asList(dffArray);
        this.doubleFieldFileMapper.insertBatch(list);
    }

    public List<DoubleFieldFile> queryDsFilelist(String phone, String regionCode, Integer start, Integer pageSize) {
        return this.doubleFieldFileMapper.queryDsFilelist(phone, regionCode, start.intValue(), pageSize.intValue());
    }

    public FieldDSMap queryFieldDSMap(List<RegionStatusArea> list, String regionCode) {
        Double likeArea = 0.0;
        Double idenArea = 0.0;
        Double fixingArea = 0.0;
        Double fixArea = 0.0;
        Integer likeCount = 0;
        Integer idenCount = 0;
        Integer fixingCount = 0;
        Integer fixCount = 0;
        for (RegionStatusArea it : list) {
            if (Arrays.asList(1, 2, 3).contains(it.getStatus())) {
                likeArea = likeArea + it.getArea();
                likeCount = likeCount + it.getCounts();
                continue;
            }
            if (Arrays.asList(4, 5, 6).contains(it.getStatus())) {
                idenArea = idenArea + it.getArea();
                idenCount = idenCount + it.getCounts();
                continue;
            }
            if (Arrays.asList(7, 8, 9).contains(it.getStatus())) {
                fixArea = fixArea + it.getArea();
                fixCount = fixCount + it.getCounts();
                continue;
            }
            if (!Arrays.asList(10, 11, 12).contains(it.getStatus())) continue;
            fixingArea = fixingArea + it.getArea();
            fixingCount = fixingCount + it.getCounts();
        }
        String regionName = this.configService.queryRegionName(regionCode);
        FieldDSMap dsMap = new FieldDSMap(likeArea, idenArea, fixingArea, fixArea, likeCount, idenCount, fixingCount, fixCount, regionCode, regionName);
        return dsMap;
    }
}

