/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.LytRole;
import com.farm.bean.LytRoleUser;
import com.farm.bean.LytUser;
import com.farm.bean.PermissionBean;
import com.farm.mapper.LytOrganizationMapper;
import com.farm.mapper.LytPermissionMapper;
import com.farm.mapper.LytRoleMapper;
import com.farm.service.RoleService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="roleService")
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private LytOrganizationMapper lytOrganizationMapper;
    @Autowired
    private LytRoleMapper lytRoleMapper;
    @Value(value="${lyt.lesseeCode}")
    private String lesseeCode;
    @Autowired
    private LytPermissionMapper lytPermissionMapper;

    public JSONObject queryRoleList(String userId, Integer begin, Integer pageSize, String roleName, String rolePid) {
        Integer count = this.lytRoleMapper.queryRoleInfoByOrgCount(roleName, userId, rolePid);
        List list = this.lytRoleMapper.queryRoleInfoByOrg(roleName, begin, pageSize, userId, rolePid);
        list.forEach(item -> {
            List childList = this.lytRoleMapper.queryRoleChildList(item.getRoleId());
            childList.forEach(child -> child.setAreaNum(this.lytRoleMapper.queryAreaNumByRoleId(child.getRoleId())));
            item.setChildList(childList);
            if (StringUtils.isNotBlank((CharSequence)item.getPermissionId())) {
                item.setPermissionId(this.lytRoleMapper.queryPermissionIdStr(item.getPermissionId()));
            }
        });
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryUserPermissionList(String userId) {
        List list = this.lytRoleMapper.queryParentInfo();
        JSONArray arr = new JSONArray();
        for (PermissionBean l : list) {
            List childList = this.lytRoleMapper.queryChildList(l.getId());
            if (childList == null || childList.size() <= 0) continue;
            JSONObject js = new JSONObject();
            js.put("permison", (Object)l);
            js.put("childList", (Object)childList);
            arr.add((Object)js);
        }
        JSONObject json = new JSONObject();
        json.put("data", (Object)arr);
        return json;
    }

    public void addUserPermission(String userId, Integer roleId, String permissionIds) {
        this.lytRoleMapper.deleteRolePermissionByRoleId(roleId);
        if (!StringUtils.isBlank((CharSequence)permissionIds)) {
            List<String> list = Arrays.asList(permissionIds.split(","));
            this.lytRoleMapper.addUserPermission(roleId, list);
        }
    }

    public void postRoleUser(JSONArray roleArray, String userId) {
        this.lytRoleMapper.deleteByUserId(userId);
        List list = roleArray.toJavaList(LytRoleUser.class);
        for (LytRoleUser lytRoleUser : list) {
            lytRoleUser.setUserId(userId);
        }
        this.lytRoleMapper.upSertRoleUserBatch(list, this.lesseeCode);
    }

    public void addOrUpdateUserRole(String userId, Integer roleId, String roleName, Integer rolePid, Integer group, String permissionIds) {
        if (roleId == null) {
            LytRole role = new LytRole();
            role.setFromType(Integer.valueOf(2));
            role.setIsGroup(group);
            role.setRoleName(roleName);
            role.setRolePid(rolePid);
            this.lytRoleMapper.addRole(role);
            roleId = role.getRoleId();
            ArrayList<LytRoleUser> list = new ArrayList<LytRoleUser>();
            LytRoleUser l = new LytRoleUser();
            l.setRoleId(String.valueOf(roleId));
            l.setUserId(userId);
            list.add(l);
            this.lytRoleMapper.upSertRoleUserBatch(list, this.lesseeCode);
        } else {
            this.lytRoleMapper.updateRole(roleName, rolePid, group, roleId);
        }
        this.lytRoleMapper.deleteRolePermissionByRoleId(roleId);
        if (!StringUtils.isBlank((CharSequence)permissionIds)) {
            List<String> list = Arrays.asList(permissionIds.split(","));
            this.lytRoleMapper.addUserPermission(roleId, list);
        }
    }

    public void delUserRole(String userId, Integer roleId) {
        this.lytRoleMapper.delRolePermission(roleId);
        this.lytRoleMapper.delRoleRegions(roleId);
        this.lytRoleMapper.delRoleUser(roleId);
        this.lytRoleMapper.delRole(roleId);
    }

    public JSONObject queryAllPermissionList() {
        List permissionList = this.lytPermissionMapper.queryAllPermissionList();
        JSONObject json = new JSONObject();
        json.put("list", (Object)permissionList);
        return json;
    }

    public List<LytUser> queryUserListByRoleId(Integer roleId) {
        return this.lytRoleMapper.queryUserListByRoleId(roleId);
    }
}

