/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.xxpt.gateway.shared.api.request.OapiMessageWorkNotificationRequest;
import com.alibaba.xxpt.gateway.shared.api.response.OapiMessageWorkNotificationResponse;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiRequest;
import com.farm.bean.LytSms;
import com.farm.config.ZzdConfig;
import com.farm.mapper.LytSmsMapper;
import com.farm.mapper.RegionStatusAreaMapper;
import com.farm.service.ConfigService;
import com.farm.service.SmsService;
import com.farm.util.HttpSendUtil;
import com.farm.util.SmsUtil;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmsServiceImpl
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    @Autowired
    private LytSmsMapper lytSmsMapper;
    @Value(value="${lyt.serverUrl}")
    private String lytServerUrl;
    @Value(value="${lyt.governUrl}")
    private String lytGovernUrl;
    @Autowired
    private RegionStatusAreaMapper regionStatusAreaMapper;
    @Autowired
    private ConfigService configService;

    public void sendSmsToGridUser(String address, String likeArea, String idenArea, String fixArea, String date, String gridPhone, String gridName) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        JSONObject json = new JSONObject();
        json.put("name", (Object)address);
        json.put("time", (Object)date);
        json.put("p1", (Object)idenArea);
        json.put("p2", (Object)fixArea);
        json.put("p3", (Object)likeArea);
        json.put("p4", (Object)"");
        Integer resFlag = SmsUtil.sendGridUserInfo((JSONObject)json, (String)gridPhone, (String)uuid);
        LytSms lytSms = new LytSms(uuid, json.toString(), gridPhone, resFlag, Integer.valueOf(10012));
        this.lytSmsMapper.insert(lytSms);
    }

    public void sendSmsToFieldUser(String gridName, String gridPhone, String fieldUserName, String toPhone, String address) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        SmsUtil.sendFieldUserInfo((String)gridName, (String)fieldUserName, (String)address, (String)gridPhone, (String)toPhone, (String)uuid);
    }

    public JSONObject sendPushMsg(String content, String resourceUrl, String title, String mobiles) {
        JSONObject json = new JSONObject();
        json.put("appNo", (Object)"GOV-001-LYT-FNFL");
        json.put("msgNo", (Object)UUID.randomUUID().toString());
        json.put("content", (Object)content);
        json.put("resourceType", (Object)"78");
        json.put("resourceUrl", (Object)resourceUrl);
        json.put("title", (Object)title);
        json.put("type", (Object)1);
        json.put("receiverIds", (Object)"");
        json.put("mobiles", (Object)mobiles);
        JSONObject resJson = new JSONObject();
        try {
            String result = HttpSendUtil.sendHttpPost((String)this.lytServerUrl, (String)"/msg-service/appMsgPush/push", (String)"", (String)json.toJSONString());
            log.error("\u63a8\u9001\u7ed3\u679c\uff1a{},{}", (Object)json.toJSONString(), (Object)result);
            resJson = JSONObject.parseObject((String)result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resJson;
    }

    public void sendAlIdenFieldMsg(Integer idenCount, String phone, String regionCode) {
        String content = "\u60a8\u6709" + idenCount + "\u5757\u7530\u5df2\u5ba1\u6838\u786e\u8ba4\u4e3a\u4e24\u975e\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u519c\u6237\u6574\u6539\uff01";
        this.sendPushMsg(content, this.lytGovernUrl + "/farm_lyt/#/twoNonGridLeader?regionCode=" + regionCode, "\u4e24\u975e\u5217\u8868", phone);
    }

    public void sendOneFieldMsg(String regionCode, int type) {
        if (type == 0) {
            regionCode = regionCode.substring(0, 12);
            List phoneList = this.regionStatusAreaMapper.queryGridLeaderListByRegionCode(regionCode, "7777777");
            StringBuffer phoneStr = new StringBuffer();
            for (String phone : phoneList) {
                phoneStr.append(phone).append(",");
            }
            this.sendAlIdenFieldMsg(Integer.valueOf(1), phoneStr.substring(0, phoneStr.lastIndexOf(",")), regionCode);
        } else if (type == 1) {
            List phoneList = this.regionStatusAreaMapper.queryGridUser(regionCode);
            StringBuffer phoneStr = new StringBuffer();
            for (String phone : phoneList) {
                phoneStr.append(phone).append(",");
            }
            this.sendFixingFieldMsg(1, phoneStr.substring(0, phoneStr.lastIndexOf(",")), regionCode);
        }
    }

    public void sendFixingFieldMsg(int count, String phone, String regionCode) {
        String content = "\u60a8\u6709" + count + "\u5757\u7530\u5df2\u8054\u7cfb\u519c\u6237\u6574\u6539\uff0c\u8bf7\u6309\u65f6\u6838\u67e5\u6574\u6539\u60c5\u51b5\uff01";
        this.sendPushMsg(content, this.lytGovernUrl + "/farm_lyt/#/twoNon?regionCode=" + regionCode, "\u4e24\u975e\u5217\u8868", phone);
    }

    public JSONObject sendZzdMsgNotification(String receiverIds, String tenantId, String messageUrl, String content, String title) {
        if (StringUtils.isBlank((String)messageUrl)) {
            messageUrl = this.lytGovernUrl + "/farm_lyt/#";
        }
        JSONObject reqJson = new JSONObject();
        JSONObject linkJson = new JSONObject();
        linkJson.put("messageUrl", (Object)messageUrl);
        linkJson.put("picUrl", (Object)"");
        linkJson.put("title", (Object)title);
        linkJson.put("text", (Object)content);
        reqJson.put("msgtype", (Object)"link");
        reqJson.put("link", (Object)linkJson);
        String msg = reqJson.toString();
        ZzdConfig zzdConfig = new ZzdConfig();
        IntelligentGetClient intelligentGetClient = zzdConfig.genExecutableClient().newIntelligentGetClient("/message/workNotification");
        OapiMessageWorkNotificationRequest oapiMessageWorkNotificationRequest = new OapiMessageWorkNotificationRequest();
        oapiMessageWorkNotificationRequest.setOrganizationCodes("");
        oapiMessageWorkNotificationRequest.setReceiverIds(receiverIds);
        oapiMessageWorkNotificationRequest.setTenantId(tenantId);
        oapiMessageWorkNotificationRequest.setBizMsgId(UUID.randomUUID().toString());
        oapiMessageWorkNotificationRequest.setMsg(msg);
        OapiMessageWorkNotificationResponse apiResult = (OapiMessageWorkNotificationResponse)intelligentGetClient.get((OapiRequest)oapiMessageWorkNotificationRequest);
        log.error("\u6253\u5370\u63a8\u9001\u7684\u8fd4\u56de\u7ed3\u679c\uff1a", (Object)apiResult.toString());
        log.error("\u6253\u5370\u63a8\u9001\u8be6\u7ec6\u8fd4\u56de\u7ed3\u679c\uff1a{},{},{}", new Object[]{apiResult.getCode(), apiResult.getContent(), apiResult.getBizErrorCode()});
        return JSONObject.parseObject((String)apiResult.getMessage());
    }
}

