/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.LytUser;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.mapper.LytOrganizationMapper;
import com.farm.mapper.RegionStatusAreaMapper;
import com.farm.service.LytUserService;
import com.farm.service.OrganService;
import com.farm.service.TaskService;
import com.farm.util.HttpSendUtil;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    @Autowired
    private LytOrganizationMapper organizationMapper;
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;
    @Value(value="${farm.companyId}")
    private String companyId;
    @Value(value="${lyt.lesseeCode}")
    private String lesseeCode;
    @Autowired
    private OrganService organService;
    @Autowired
    private LytUserService userService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private RegionStatusAreaMapper regionStatusAreaMapper;

    public void syncOrganizationToSx() {
        List list = this.organService.queryAllEmptySxOrgIdList(this.lesseeCode);
        if (list.size() == 0) {
            return;
        }
        JSONObject body = new JSONObject();
        body.put("array", (Object)list);
        body.put("companyId", (Object)this.companyId);
        try {
            String response = HttpSendUtil.sendHttpPost((String)this.farmServerUrl, (String)"/organ/syncLyt", (String)"", (String)body.toString());
            JSONObject resJson = JSONObject.parseObject((String)response).getJSONObject("resData");
            if (resJson.containsKey((Object)"array")) {
                JSONArray orgList = resJson.getJSONArray("array");
                for (int i = 0; i < orgList.size(); ++i) {
                    JSONObject itJson = orgList.getJSONObject(i);
                    this.organizationMapper.updateSxOrgId(itJson.getString("orgId"), itJson.getString("sxOrgId"));
                }
            } else {
                log.error("farm_server\u63a5\u53e3\u66f4\u65b0\u7ec4\u7ec7\u67b6\u6784\u62a5\u9519\u4e86\uff1a{}", (Object)response);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void syncUserInfoToSx(int pageSize) {
        Integer count = this.organService.queryAllEmptyUserIdCount(this.lesseeCode);
        if (count == 0) {
            return;
        }
        Integer page = count / pageSize + 1;
        for (int p = 0; p < page + 1; ++p) {
            Integer limit = p * pageSize;
            List list = this.organService.queryAllEmptyUserIdList(this.lesseeCode, limit, pageSize);
            JSONObject body = new JSONObject();
            body.put("array", (Object)list);
            body.put("companyId", (Object)this.companyId);
            try {
                String response = HttpSendUtil.sendHttpPost((String)this.farmServerUrl, (String)"/organ/syncLytUser", (String)"", (String)body.toString());
                JSONObject resJson = JSONObject.parseObject((String)response).getJSONObject("resData");
                if (resJson.containsKey((Object)"array")) {
                    JSONArray orgList = resJson.getJSONArray("array");
                    JSONObject itJson = new JSONObject();
                    ArrayList<LytUser> userList = new ArrayList<LytUser>();
                    for (int i = 0; i < orgList.size(); ++i) {
                        itJson = orgList.getJSONObject(i);
                        LytUser lytUser = new LytUser();
                        lytUser.setSxUserId(itJson.getString("sxUserId"));
                        lytUser.setUserId(itJson.getString("userId"));
                        userList.add(lytUser);
                    }
                    this.userService.updateSxUserId(userList);
                    continue;
                }
                log.error("farm_server\u63a5\u53e3 \u540c\u6b65\u7528\u6237\u4fe1\u606f\u62a5\u9519\u4e86\uff1a{}", (Object)response);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Integer syncUserOrganInfoToSx() {
        List list;
        String key = "syncUserOrgan-lastOperate";
        String lastOperateData = (String)this.redisTemplate.opsForValue().get((Object)key);
        Integer count = this.organizationMapper.queryUserOrganNoEmptyCount(this.lesseeCode);
        Long timeSecond = this.organizationMapper.queryMaxUpdateTimeSecond(this.lesseeCode);
        if (StringUtils.isNotBlank((String)lastOperateData)) {
            Integer redisCount = Integer.parseInt(lastOperateData.split(",")[0]);
            Long redisTimeSecond = Long.valueOf(lastOperateData.split(",")[1]);
            if (count.equals(redisCount) && timeSecond.equals(redisTimeSecond)) {
                return 1;
            }
        }
        if ((list = this.organizationMapper.queryUserOrganNotSyncList(this.lesseeCode)) != null && list.size() > 0) {
            JSONObject requestBody = new JSONObject();
            requestBody.put("array", (Object)list);
            requestBody.put("companyId", (Object)this.companyId);
            try {
                log.error("\u65e5\u5fd7\uff1a{}", (Object)requestBody.toString());
                String response = HttpSendUtil.sendHttpPost((String)this.farmServerUrl, (String)"/organ/syncLytUser-organ", (String)"", (String)requestBody.toString());
                Integer resCode = JSONObject.parseObject((String)response).getInteger("resCode");
                if (resCode == 0) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)(count + "," + timeSecond));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public Integer syncFieldInfoToSx(int pageSize) {
        Integer status = 0;
        Integer count = this.fieldDoubleStatusMapper.countByStatus(status);
        if (count > 0) {
            Integer page = count / 1000 + 1;
            for (int i = 0; i < page; ++i) {
                List list = this.fieldDoubleStatusMapper.queryListByStatus(status, i, pageSize);
                JSONArray fieldArray = new JSONArray(Collections.singletonList(list));
                try {
                    System.out.println(fieldArray.toJSONString());
                    String response = HttpSendUtil.sendHttpPost((String)this.farmServerUrl, (String)"/importData/field", (String)"", (String)fieldArray.toJSONString());
                    JSONArray array = JSONObject.parseObject((String)response).getJSONArray("resData");
                    JSONObject itField = new JSONObject();
                    for (int j = 0; j < array.size(); ++j) {
                        itField = array.getJSONObject(j);
                        this.fieldDoubleStatusMapper.updateSxFieldId(itField.getInteger("fieldId"), itField.getInteger("id"));
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u7530\u5757\u6570\u636e\u62a5\u9519{}", (Object)e.getMessage());
                    break;
                }
            }
        }
        return count;
    }

    public void updateDailyDataStatistics() {
        String date = LocalDate.now().toString();
        List list0 = this.regionStatusAreaMapper.queryAllSumByStatusAreaType(date, Integer.valueOf(0));
        list0.stream().forEach(it -> it.setAreaType(Integer.valueOf(0)));
        List list1 = this.regionStatusAreaMapper.queryAllSumByStatusAreaType(date, Integer.valueOf(1));
        list1.stream().forEach(it -> it.setAreaType(Integer.valueOf(1)));
        List list2 = this.regionStatusAreaMapper.queryAllSumByStatusAreaType(date, Integer.valueOf(2));
        list2.stream().forEach(it -> it.setAreaType(Integer.valueOf(2)));
        list0.addAll(list1);
        list0.addAll(list2);
        this.regionStatusAreaMapper.insertOrUpdateBatch(list0);
    }
}

