/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.farm.bean.AgriserveMachineWarningInfo;
import com.farm.bean.AgriserveMachineWarningLog;
import com.farm.bean.FieldAddrResultMap;
import com.farm.bean.PestWarningInfo;
import com.farm.bean.RecycleWarningInfo;
import com.farm.bean.Warning;
import com.farm.bean.bo.WarningBo;
import com.farm.bean.bo.WarningStatusBo;
import com.farm.bean.dto.FlWarningDto;
import com.farm.bean.vo.FlWarningVo;
import com.farm.bean.vo.WarningCountVo;
import com.farm.bean.vo.WarningVo;
import com.farm.mapper.AgriserveMachineMapper;
import com.farm.mapper.WarningMapper;
import com.farm.service.WarningService;
import com.farm.util.JsonUtil;
import com.farm.util.ResultVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class WarningServiceImpl
extends ServiceImpl<WarningMapper, Warning>
implements WarningService {
    @Value(value="${branch}")
    private String branch;
    @Autowired
    private AgriserveMachineMapper agriserveMachineMapper;

    public Boolean saveOrUpdate(List<WarningBo> list) {
        String now = DateUtil.now();
        list.forEach(item -> {
            item.setStatus(Integer.valueOf(-1));
            item.setCreateTime(now);
            if (item.getModule() != null && item.getModule() == 1) {
                item.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                item.setLeader("\u738b\u4fca\u6770");
            }
        });
        List warnList = JSONObject.parseArray((String)JSONObject.toJSONString(list), Warning.class);
        return this.saveOrUpdateBatch((Collection)warnList);
    }

    public JSONObject queryList(Integer dateType, String date, String modules, String status, Integer warningType, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        Integer start = 0;
        if (pageNum != null && pageNum != null) {
            start = (pageNum - 1) * pageSize;
        }
        List list = ((WarningMapper)this.baseMapper).queryList(dateType, date, modules, status, warningType, start, pageSize);
        Integer count = ((WarningMapper)this.baseMapper).queryListCount(dateType, date, modules, status, warningType);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryNjWarningList(Integer dateType, String date, String modules, String status, Integer warningType, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        Integer start = 0;
        if (pageNum != null && pageNum != null) {
            start = (pageNum - 1) * pageSize;
        }
        List list = ((WarningMapper)this.baseMapper).queryNjList(dateType, date, modules, status, warningType, start, pageSize);
        Integer count = ((WarningMapper)this.baseMapper).queryNjListCount(dateType, date, modules, status, warningType);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public void delByModuleAndRule(Integer module, String rules) {
        ((WarningMapper)this.getBaseMapper()).delByModuleAndRule(module, rules);
    }

    public JSONObject queryDataGroup(String modules, Integer dateType, String date) {
        JSONObject json = new JSONObject();
        Integer hongCount = ((WarningMapper)this.baseMapper).queryWarningType(modules, Integer.valueOf(0), dateType, date);
        Integer huangCount = ((WarningMapper)this.baseMapper).queryWarningType(modules, Integer.valueOf(1), dateType, date);
        Integer bdmx = ((WarningMapper)this.baseMapper).queryBDMX(modules);
        String status = "1";
        Integer czCount = ((WarningMapper)this.baseMapper).queryListCountByStatus(modules, status, dateType, date);
        json.put("hongCount", (Object)hongCount);
        json.put("huangCount", (Object)huangCount);
        json.put("bdmx", (Object)bdmx);
        json.put("czjd", (Object)String.format("%.2f", hongCount + huangCount + czCount == 0 ? 0.0 : (double)czCount.intValue() / (double)(hongCount + huangCount + czCount) * 100.0));
        return json;
    }

    public JSONObject queryWarningScale(@RequestParam(value="dateType") Integer dateType, @RequestParam(value="date") String date) {
        JSONObject json = new JSONObject();
        Integer hslCount = ((WarningMapper)this.baseMapper).queryWarningScale(Integer.valueOf(1), dateType, date);
        Integer czCount = ((WarningMapper)this.baseMapper).queryWarningScale(Integer.valueOf(2), dateType, date);
        Integer kcCount = ((WarningMapper)this.baseMapper).queryWarningScale(Integer.valueOf(3), dateType, date);
        json.put("hslCount", (Object)hslCount);
        json.put("czCount", (Object)czCount);
        json.put("kcCount", (Object)kcCount);
        return json;
    }

    @Transactional
    public Boolean updateStatus(WarningStatusBo bo) {
        LambdaUpdateWrapper update = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(Warning::getId, (Collection)bo.getIds())).set(Warning::getStatus, (Object)bo.getStatus())).set(Warning::getAuditDate, (Object)DateUtil.now())).set(Warning::getStartTime, (Object)DateUtil.now())).set(Warning::getEndTime, (Object)DateUtil.now());
        int flag = ((WarningMapper)this.baseMapper).update(null, (Wrapper)update);
        if (CollectionUtil.isNotEmpty((Collection)bo.getIds()) && bo.getIds().size() > 0) {
            List logs = bo.getIds().stream().map(id -> {
                AgriserveMachineWarningLog log = new AgriserveMachineWarningLog();
                log.setRelId(id);
                log.setRelUnit(bo.getRelUnit());
                log.setTitle("\u5df2\u5904\u7f6e");
                log.setResponsibility(bo.getResponsibility());
                log.setPhone(bo.getPhone());
                return log;
            }).collect(Collectors.toList());
            ((WarningMapper)this.baseMapper).batchInsertLogs(logs);
        }
        return flag > 0;
    }

    public JSONObject queryDataGroupResult(String modules, Integer dateType, String date) {
        JSONObject json = new JSONObject();
        Integer allCount = ((WarningMapper)this.baseMapper).queryWarningType(modules, null, dateType, date);
        Integer czzCount = ((WarningMapper)this.baseMapper).queryListCountByStatus(modules, "0", dateType, date);
        Integer yjbCount = ((WarningMapper)this.baseMapper).queryListCountByStatus(modules, "1", dateType, date);
        json.put("allCount", (Object)allCount);
        json.put("czzCount", (Object)czzCount);
        json.put("yjbCount", (Object)yjbCount);
        return json;
    }

    public JSONObject queryHomeDataGroup() {
        List list = ((WarningMapper)this.baseMapper).queryWarningModule();
        List allCountList = ((WarningMapper)this.baseMapper).queryWarningCount("-1,0");
        if (CollectionUtil.isNotEmpty((Collection)allCountList) && allCountList.size() > 0) {
            allCountList.removeIf(vo -> vo.getModule() == 2);
            WarningCountVo count = ((WarningMapper)this.baseMapper).queryWarningCountByTime(Integer.valueOf(2));
            allCountList.add(count);
        }
        List yczCountList = ((WarningMapper)this.baseMapper).queryWarningCount("1");
        Long dataCount = 0L;
        dataCount = StringUtils.equals((CharSequence)this.branch, (CharSequence)"prod") ? ((WarningMapper)this.baseMapper).queryAllDataCount("lyywzz") : ((WarningMapper)this.baseMapper).queryAllDataCount("db_farm_ly");
        Integer bdmx = ((WarningMapper)this.baseMapper).queryBDMX(null);
        Integer allWarnCount = ((WarningMapper)this.baseMapper).queryWarningType(null, null, null, null);
        Integer czCount = ((WarningMapper)this.baseMapper).queryListCountByStatus(null, "1", null, null);
        boolean flag = false;
        boolean yczFlag = false;
        for (WarningCountVo muVo : list) {
            flag = false;
            yczFlag = false;
            if (allCountList != null && allCountList.size() > 0) {
                for (WarningCountVo coVo : allCountList) {
                    if (muVo.getModule().intValue() != coVo.getModule().intValue()) continue;
                    flag = true;
                }
                if (!flag) {
                    allCountList.add(muVo);
                }
            }
            if (yczCountList == null || yczCountList.size() <= 0) continue;
            for (WarningCountVo yczVo : yczCountList) {
                if (muVo.getModule().intValue() != yczVo.getModule().intValue()) continue;
                yczFlag = true;
            }
            if (yczFlag) continue;
            yczCountList.add(muVo);
        }
        if (allCountList == null || allCountList.size() == 0) {
            allCountList = list;
        }
        if (yczCountList == null || yczCountList.size() == 0) {
            yczCountList = list;
        }
        JSONObject json = new JSONObject();
        json.put("allCountList", (Object)allCountList);
        json.put("yczCountList", (Object)yczCountList);
        json.put("dataCount", (Object)dataCount);
        json.put("bdmx", (Object)bdmx);
        json.put("allWarnCount", (Object)allWarnCount);
        json.put("czjd", (Object)String.format("%.2f", (double)czCount.intValue() / (double)allWarnCount.intValue() * 100.0));
        return json;
    }

    public List<WarningCountVo> queryInsectWarnCount(Integer warningType, Integer dateType, String date) {
        return ((WarningMapper)this.baseMapper).queryInsectWarnCount(warningType, dateType, date);
    }

    public JSONObject queryWarnLogs(Integer id) {
        JSONObject jsonObject = new JSONObject();
        AgriserveMachineWarningInfo machine = this.agriserveMachineMapper.readById(id);
        if (!Objects.isNull(machine)) {
            if (machine.getType() == 0) {
                machine.setMachineType("\u62d6\u62c9\u673a");
            } else if (machine.getType() == 1) {
                machine.setMachineType("\u63d2\u79e7\u673a");
            } else if (machine.getType() == 2) {
                machine.setMachineType("\u6536\u5272\u673a");
            } else if (machine.getType() == 3) {
                machine.setMachineType("\u70d8\u5e72\u673a");
            } else if (machine.getType() == 4) {
                machine.setMachineType("\u65e0\u4eba\u673a");
            }
            if (StringUtils.isNotBlank((CharSequence)machine.getInsuranceFlag())) {
                machine.setInsuranceFlag("0".equals(machine.getInsuranceFlag()) ? "\u5426" : "\u662f");
            }
            if (StringUtils.isNotBlank((CharSequence)machine.getPhone())) {
                String[] split;
                List list = this.agriserveMachineMapper.getLord(machine.getPhone());
                if (CollectionUtil.isNotEmpty((Collection)list) && (split = ((String)list.get(0)).split("-")).length > 1) {
                    machine.setLng(split[0]);
                    machine.setLat(split[1]);
                }
                machine.setWarnType(machine.getRule() == 1 ? "\u7ea2\u8272\u9884\u8b66" : "\u9ec4\u8272\u9884\u8b66");
                jsonObject.put("baseInfo", (Object)machine);
            }
            List logs = ((WarningMapper)this.baseMapper).queryWarnLogs(id);
            jsonObject.put("list", (Object)logs);
        }
        return jsonObject;
    }

    public ResultVo getOneInsectWarning(Integer id) {
        PestWarningInfo info = ((WarningMapper)this.baseMapper).getOneInsectWarning(id);
        return ResultVo.success((Object)info);
    }

    public ResultVo getOneInsectDetail(Integer dateType, String date) {
        List result = ((WarningMapper)this.baseMapper).getOneInsectDetail(dateType, date);
        HashMap<String, String> collect = new HashMap<String, String>();
        if (CollectionUtil.isNotEmpty((Collection)result) && result.size() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (Map map : result) {
                String wlwId = map.get("device_id").toString();
                String insectType = ((WarningMapper)this.baseMapper).findByDeviceId(wlwId);
                if (insectType.contains("\uff0c")) {
                    String[] split = insectType.split("\uff0c");
                    set.addAll(Arrays.asList(split));
                    continue;
                }
                set.add(insectType);
            }
            if (CollectionUtil.isNotEmpty(set) && CollectionUtil.isNotEmpty((Collection)result) && result.size() > 0) {
                for (String type : set) {
                    String num = "0";
                    for (Map map : result) {
                        if (!map.get("insect_type").toString().contains(type)) continue;
                        if (!collect.containsKey(type)) {
                            num = map.get("num").toString();
                        } else {
                            long n = Long.parseLong(collect.get(type).toString()) + Long.parseLong(map.get("num").toString());
                            num = Long.toString(n);
                        }
                        collect.put(type, num);
                    }
                }
            }
        }
        return ResultVo.success(collect);
    }

    public ResultVo getOneRecycleWarning(Integer id) {
        RecycleWarningInfo info = ((WarningMapper)this.baseMapper).getOneRecycleWarning(id);
        return ResultVo.success((Object)info);
    }

    public JSONObject getCultivatedLandWarnLogs(Integer id) {
        JSONObject jsonObject = new JSONObject();
        List logs = ((WarningMapper)this.baseMapper).queryWarnLogs(id);
        jsonObject.put("list", (Object)logs);
        return jsonObject;
    }

    @Transactional
    public void insert(Warning warning) {
        ((WarningMapper)this.baseMapper).insertOne(warning);
    }

    public void insertOne(Warning warning) {
        ((WarningMapper)this.baseMapper).insertOneWarning(warning);
    }

    public JSONObject queryFlWarningList(Integer dateType, String date, String modules, String status, Integer warningType, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        Integer start = 0;
        if (pageNum != null && pageNum != null) {
            start = (pageNum - 1) * pageSize;
        }
        List list = ((WarningMapper)this.baseMapper).queryList(dateType, date, modules, status, warningType, start, pageSize);
        ArrayList<FlWarningVo> flWarningVos = new ArrayList<FlWarningVo>();
        if (CollUtil.isNotEmpty((Collection)list)) {
            List relIds = list.stream().map(WarningVo::getRelId).collect(Collectors.toList());
            List fieldAddrResultMaps = ((WarningMapper)this.baseMapper).selectByRelIds(relIds);
            List regionCodes = fieldAddrResultMaps.stream().map(m -> m.getRegionCode().substring(0, 9) + "000").collect(Collectors.toList());
            List flWarningAreaCode = ((WarningMapper)this.baseMapper).selectByAreaCode(regionCodes);
            List flWarningAreaCodeAndRoleId = ((WarningMapper)this.baseMapper).selectByAreaCodeAndRoleId(regionCodes, "56565656");
            for (WarningVo warning : list) {
                String relId = warning.getRelId();
                List fieldAddrResultMap = fieldAddrResultMaps.stream().filter(far -> relId.equals(far.getId().toString())).collect(Collectors.toList());
                FlWarningVo flWarningVo = (FlWarningVo)JsonUtil.getJsonToBean((Object)warning, FlWarningVo.class);
                if (CollUtil.isNotEmpty(fieldAddrResultMap)) {
                    List flWarningAreaCodeAndRoleIdDtos;
                    String regionCode = ((FieldAddrResultMap)fieldAddrResultMap.get(0)).getRegionCode().substring(0, 9) + "000";
                    List flWarningAreaCodeDtos = flWarningAreaCode.stream().filter(fw -> regionCode.equals(fw.getAreaCode())).collect(Collectors.toList());
                    if (CollUtil.isNotEmpty(flWarningAreaCodeDtos)) {
                        flWarningVo.setTownName(((FlWarningDto)flWarningAreaCodeDtos.get(0)).getAdmName());
                    }
                    if (CollUtil.isNotEmpty(flWarningAreaCodeAndRoleIdDtos = flWarningAreaCodeAndRoleId.stream().filter(fw -> regionCode.equals(fw.getAreaCode())).collect(Collectors.toList()))) {
                        flWarningVo.setTownDirector(((FlWarningDto)flWarningAreaCodeAndRoleIdDtos.get(0)).getUserName());
                        flWarningVo.setMobile(((FlWarningDto)flWarningAreaCodeAndRoleIdDtos.get(0)).getMobile());
                    }
                }
                flWarningVos.add(flWarningVo);
            }
        }
        Integer count = ((WarningMapper)this.baseMapper).queryListCount(dateType, date, modules, status, warningType);
        json.put("list", flWarningVos);
        json.put("count", (Object)count);
        return json;
    }
}

