/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.LytRoleUser;
import com.farm.bean.LytUser;
import com.farm.bean.OrganizationUser;
import com.farm.mapper.LytOrganizationMapper;
import com.farm.mapper.LytRoleMapper;
import com.farm.mapper.LytUserMapper;
import com.farm.service.LytUserService;
import com.farm.service.ZLBService;
import com.farm.util.HmacAuthUtil;
import com.farm.util.HttpSendUtil;
import com.farm.util.MD5Util;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="zLBService")
public class ZLBServiceImpl
implements ZLBService {
    private static final Logger log = LoggerFactory.getLogger(ZLBServiceImpl.class);
    @Autowired
    private LytUserService lytUserService;
    @Autowired
    private LytRoleMapper lytRoleMapper;
    @Autowired
    private LytUserMapper lytUserMapper;
    @Autowired
    private LytOrganizationMapper organizationMapper;
    @Value(value="${lyt.config.farmRoleId}")
    private String farmRoleId;
    @Value(value="${lyt.config.farmOrgId}")
    private String farmOrgId;
    @Value(value="${lyt.lesseeCode}")
    private String lesseeCode;

    public JSONObject ticketCertification(String ticket, String loginType) {
        String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("servicecode", "e54363f229aa4028a2703fcf45fd67f3");
        bodyMap.put("method", "ticketValidation");
        bodyMap.put("time", time);
        bodyMap.put("sign", MD5Util.MD5((String)("e54363f229aa4028a2703fcf45fd67f32e1d64ac7b964795973d00ac6488d3e9" + time)));
        bodyMap.put("st", ticket);
        if (loginType.equals("2")) {
            bodyMap.clear();
            bodyMap.put("ticketId", ticket);
            bodyMap.put("appId", "2002238542");
        }
        log.error("ticket\uff1a{}, loginType:{} ", (Object)ticket, (Object)loginType);
        String ticketCertificationUrl = loginType.equals("2") ? "https://ibcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220329000007/uc/sso/access_token" : "https://ibcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220228000002/sso/servlet/simpleauth";
        Map headerMap = HmacAuthUtil.generateHeader((String)ticketCertificationUrl, (String)"POST", (String)"e54363f229aa4028a2703fcf45fd67f3", (String)"2e1d64ac7b964795973d00ac6488d3e9", (String)loginType);
        try {
            String xmlStr = loginType.equals("2") ? HttpSendUtil.sendHttpPost((String)"", (String)"", (String)ticketCertificationUrl, (String)JSON.toJSONString(bodyMap), (Map)headerMap) : HttpSendUtil.sendPost1((String)ticketCertificationUrl, bodyMap, (Map)headerMap);
            log.error("xmlStr\uff1a{}", (Object)xmlStr);
            String token = loginType.equals("2") ? ((JSONObject)JSON.parse((String)xmlStr)).getJSONObject("data").getString("accessToken") : ZLBServiceImpl.xmlToJson((String)xmlStr).getJSONObject("SSO").getString("token");
            log.error("token\uff1a{}", (Object)token);
            return this.queryUserByToken(token, loginType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject queryUserByToken(String token, String loginType) {
        String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("servicecode", "e54363f229aa4028a2703fcf45fd67f3");
        bodyMap.put("method", "getUserInfo");
        bodyMap.put("time", time);
        bodyMap.put("sign", MD5Util.MD5((String)("e54363f229aa4028a2703fcf45fd67f32e1d64ac7b964795973d00ac6488d3e9" + time)));
        if (loginType.equals("2")) {
            bodyMap.clear();
        }
        bodyMap.put("token", token);
        String userInfoUrl = loginType.equals("2") ? "https://ibcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220329000008/uc/sso/getUserInfo" : "https://ibcdsg.zj.gov.cn:8443/restapi/prod/IC33000020220228000004/sso/servlet/simpleauth";
        Map headerMap = HmacAuthUtil.generateHeader((String)userInfoUrl, (String)"POST", (String)"e54363f229aa4028a2703fcf45fd67f3", (String)"2e1d64ac7b964795973d00ac6488d3e9", (String)loginType);
        try {
            JSONObject personInfo;
            String phone;
            LytUser lytUser;
            boolean isWechatReturn;
            String xml = loginType.equals("2") ? HttpSendUtil.sendHttpPost((String)"", (String)"", (String)userInfoUrl, (String)JSON.toJSONString(bodyMap), (Map)headerMap) : HttpSendUtil.sendPost1((String)userInfoUrl, bodyMap, (Map)headerMap);
            JSONObject jsonObject = loginType.equals("2") ? (JSONObject)JSON.parse((String)xml) : ZLBServiceImpl.xmlToJson((String)xml);
            JSONObject userObj = loginType.equals("2") ? jsonObject : jsonObject.getJSONObject("SSO");
            boolean isAlipayRutrun = userObj.containsKey((Object)"errmsg") && userObj.getString("errmsg").equals("\u6210\u529f");
            boolean bl = isWechatReturn = userObj.containsKey((Object)"success") && userObj.getString("success").equals("true");
            if (isAlipayRutrun) {
                LytUser lytUser2 = this.lytUserService.queryUserAllInfoByPhone(userObj.getString("mobile"), "");
                if (lytUser2 == null) {
                    String mobile = userObj.getString("mobile");
                    String realName = userObj.getString("username");
                    String userId = userObj.getString("userid");
                    lytUser2 = new LytUser(realName, "", mobile);
                    lytUser2.setOrigin(Integer.valueOf(1));
                    lytUser2.setUserId(userId);
                    this.lytUserMapper.insertOrUpdate(lytUser2);
                    this.lytUserMapper.insertUserCenter(userId, userObj.getString("idnum"));
                    LytRoleUser roleUser = new LytRoleUser(userId, this.farmRoleId, this.lesseeCode);
                    this.lytRoleMapper.upSertRoleUserBatch(Collections.singletonList(roleUser), this.lesseeCode);
                    OrganizationUser organizationUser = new OrganizationUser(this.farmOrgId, userId);
                    this.organizationMapper.sertOrUpdateOrgUserBatch(Collections.singletonList(organizationUser), this.lesseeCode);
                }
            } else if (isWechatReturn && (lytUser = this.lytUserService.queryUserAllInfoByPhone(phone = (personInfo = userObj.getJSONObject("data").getJSONObject("personInfo")).getString("phone"), "")) == null) {
                String realName = personInfo.getString("userName");
                String userId = personInfo.getString("userId");
                lytUser = new LytUser(realName, "", phone);
                lytUser.setOrigin(Integer.valueOf(1));
                lytUser.setUserId(userId);
                this.lytUserMapper.insertOrUpdate(lytUser);
                this.lytUserMapper.insertUserCenter(userId, personInfo.getString("idNo"));
                LytRoleUser roleUser = new LytRoleUser(userId, this.farmRoleId, this.lesseeCode);
                this.lytRoleMapper.upSertRoleUserBatch(Collections.singletonList(roleUser), this.lesseeCode);
                OrganizationUser organizationUser = new OrganizationUser(this.farmOrgId, userId);
                this.organizationMapper.sertOrUpdateOrgUserBatch(Collections.singletonList(organizationUser), this.lesseeCode);
            }
            return jsonObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject xmlToJson(String xml) throws Exception {
        JSONObject jsonObject = new JSONObject();
        Document document = DocumentHelper.parseText((String)xml);
        Element root = document.getRootElement();
        ZLBServiceImpl.iterateNodes((Element)root, (JSONObject)jsonObject);
        return jsonObject;
    }

    private static void iterateNodes(Element node, JSONObject json) {
        String nodeName = node.getName();
        if (json.containsKey((Object)nodeName)) {
            JSONArray array;
            Object Object2 = json.get((Object)nodeName);
            if (Object2 instanceof JSONArray) {
                array = (JSONArray)Object2;
            } else {
                array = new JSONArray();
                array.add(Object2);
            }
            List listElement = node.elements();
            if (listElement.isEmpty()) {
                String nodeValue = node.getTextTrim();
                array.add((Object)nodeValue);
                json.put(nodeName, (Object)array);
                return;
            }
            JSONObject newJson = new JSONObject();
            for (Element e : listElement) {
                ZLBServiceImpl.iterateNodes((Element)e, (JSONObject)newJson);
            }
            array.add((Object)newJson);
            json.put(nodeName, (Object)array);
            return;
        }
        List listElement = node.elements();
        if (listElement.isEmpty()) {
            String nodeValue = node.getTextTrim();
            json.put(nodeName, (Object)nodeValue);
            return;
        }
        JSONObject object = new JSONObject();
        for (Element e : listElement) {
            ZLBServiceImpl.iterateNodes((Element)e, (JSONObject)object);
        }
        json.put(nodeName, (Object)object);
    }
}

