/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.LytRoleUser;
import com.farm.bean.LytUser;
import com.farm.bean.OrganizationUser;
import com.farm.mapper.LytOrganizationMapper;
import com.farm.mapper.LytRoleMapper;
import com.farm.mapper.LytUserMapper;
import com.farm.service.LytUserService;
import com.farm.service.ZZDService;
import com.farm.util.HttpSendUtil;
import com.farm.util.MD5Util;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

@Service(value="zzdService")
public class ZZDServiceImpl
implements ZZDService {
    private static final Logger log = LoggerFactory.getLogger(ZZDServiceImpl.class);
    @Autowired
    private LytUserService lytUserService;
    @Autowired
    private LytRoleMapper lytRoleMapper;
    @Autowired
    private LytUserMapper lytUserMapper;
    @Autowired
    private LytOrganizationMapper organizationMapper;
    @Value(value="${lyt.config.farmRoleId}")
    private String farmRoleId;
    @Value(value="${lyt.config.farmOrgId}")
    private String farmOrgId;
    @Value(value="${lyt.lesseeCode}")
    private String lesseeCode;

    public JSONObject ticketCertification(String ticket) {
        Assert.hasLength((String)ticket, (String)"\u7968\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        String ak = "c63fe778ca7d67befeb108b80ddfcd02";
        String sk = "8bb2061e1b1f58b0f9759341f4e95254";
        String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String sign = MD5Util.MD5((String)(ticket + sk + time));
        String url = "https://lytapi4.longyou.gov.cn/srv/admin/system/oauth2/admin_info";
        URI uri = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("ak", new Object[]{ak}).queryParam("time", new Object[]{time}).queryParam("sign", new Object[]{sign}).queryParam("ticket", new Object[]{ticket}).build().toUri();
        try {
            String content = HttpSendUtil.sendHttpGet((String)uri.toString());
            JSONObject jsonObject = JSONObject.parseObject((String)content);
            Assert.isTrue((boolean)jsonObject.getBoolean("success"), (String)("\u8bf7\u6c42\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + jsonObject.getString("msg")));
            Assert.isTrue((boolean)jsonObject.getInteger("code").equals(200), (String)("\u8bf7\u6c42\u7528\u6237\u4fe1\u606f\u72b6\u6001\u7801\uff1a" + jsonObject.getInteger("code")));
            JSONObject userObj = jsonObject.getJSONObject("data");
            this.updateUserInfo(userObj);
            return jsonObject;
        }
        catch (Exception e) {
            log.error("\u5355\u70b9\u767b\u5f55\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void updateUserInfo(JSONObject userObj) {
        String phone = userObj.getString("phone");
        LytUser lytUser = this.lytUserService.queryUserAllInfoByPhone(phone, "");
        if (lytUser == null) {
            String nickname = userObj.getString("nickname");
            String openId = userObj.getString("open_id");
            lytUser = new LytUser(nickname, "", phone);
            lytUser.setOrigin(Integer.valueOf(1));
            lytUser.setUserId(openId);
            this.lytUserMapper.insertOrUpdate(lytUser);
            this.lytUserMapper.insertUserCenter(openId, null);
            LytRoleUser roleUser = new LytRoleUser(openId, this.farmRoleId, this.lesseeCode);
            this.lytRoleMapper.upSertRoleUserBatch(Collections.singletonList(roleUser), this.lesseeCode);
            OrganizationUser organizationUser = new OrganizationUser(this.farmOrgId, openId);
            this.organizationMapper.sertOrUpdateOrgUserBatch(Collections.singletonList(organizationUser), this.lesseeCode);
        }
    }
}

