/*
 * Decompiled with CFR 0.152.
 */
package com.farm.task;

import com.alibaba.fastjson.JSONObject;
import com.farm.service.ComponentService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AuditMsgTask {
    private static final Logger log = LoggerFactory.getLogger(AuditMsgTask.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ComponentService componentService;
    private final String[] cert = new String[]{"PD90105-3", "PD20200659", "PD20098407", "PD20200658", "PD20200657", "PD20200656", "PD20200655", "PD20200654", "PD20200653"};

    public Boolean putLock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)("lyt" + key), (Object)"", 2L, TimeUnit.SECONDS);
    }

    @Scheduled(cron="0 0 9 * * ?")
    public void httpproxyTask() {
        Boolean flag = this.putLock("httpproxyTask");
        if (flag.booleanValue()) {
            JSONObject json = new JSONObject();
            JSONObject paramJson = new JSONObject();
            for (int i = 0; i < 9; ++i) {
                paramJson.put("certificateNumber", (Object)this.cert[i]);
                json.put("paramJson", (Object)paramJson);
                JSONObject httpproxy = this.componentService.httpproxy(json);
                log.error("\u672c\u673a\u6267\u884c\uff1a\u56fd\u5bb6\u7ec4\u4ef6\u63a5\u53e3\u6bcf\u65e5\u8c03\u7528:" + httpproxy);
            }
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u56fd\u5bb6\u7ec4\u4ef6\u63a5\u53e3\u6bcf\u65e5\u8c03\u7528");
        }
    }
}

