/*
 * Decompiled with CFR 0.152.
 */
package com.farm.task;

import cn.hutool.core.collection.CollectionUtil;
import com.farm.bean.Warning;
import com.farm.mapper.InsectDataMapper;
import com.farm.service.WarningService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class InsectWarningTask {
    private static final Logger log = LoggerFactory.getLogger(InsectWarningTask.class);
    private final InsectDataMapper insectDataMapper;
    private final WarningService warningService;

    @Scheduled(cron="0 0 1 * * ? ")
    public void insectTask() {
        List dataList1 = this.insectDataMapper.selectDayData(Integer.valueOf(1), LocalDate.now().toString(), LocalDate.now().toString());
        List dataList2 = this.insectDataMapper.selectDayData(Integer.valueOf(2), LocalDate.now().toString(), LocalDate.now().toString());
        ArrayList warningList = new ArrayList();
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        if (CollectionUtil.isNotEmpty((Collection)dataList1) && dataList1.size() > 0) {
            dataList1.forEach(d -> {
                Warning warning = new Warning();
                warning.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                warning.setLeader("\u90d1\u7490\u83b9");
                warning.setWarningDate(d.getRecordTime());
                warning.setContent(d.getDeviceName() + "\u53d1\u73b0\u3010" + d.getInsectName() + "\u3011\u8d85\u8fc7" + d.getCount() + "\u5934");
                warning.setRelId(d.getId());
                warning.setCreateTime(time);
                warning.setModule(Integer.valueOf(2));
                warning.setRule(Integer.valueOf(3));
                if (d.getCount() >= 50 && d.getCount() < 100) {
                    warning.setWarningType(Integer.valueOf(1));
                } else if (d.getCount() >= 100) {
                    warning.setWarningType(Integer.valueOf(0));
                }
                warningList.add(warning);
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)dataList2) && dataList2.size() > 0) {
            dataList2.forEach(d -> {
                Warning warning = new Warning();
                warning.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                warning.setLeader("\u90d1\u7490\u83b9");
                warning.setWarningDate(d.getRecordTime());
                warning.setContent(d.getDeviceName() + "\u53d1\u73b0\u866b\u5bb3\u8d85\u8fc7" + d.getCount() + "\u5934");
                warning.setRelId(d.getId());
                warning.setCreateTime(time);
                warning.setModule(Integer.valueOf(2));
                warning.setRule(Integer.valueOf(3));
                if (d.getCount() >= 50 && d.getCount() < 100) {
                    warning.setWarningType(Integer.valueOf(1));
                } else if (d.getCount() >= 100) {
                    warning.setWarningType(Integer.valueOf(0));
                }
                warningList.add(warning);
            });
        }
        if (CollectionUtil.isNotEmpty(warningList) && warningList.size() > 0) {
            this.warningService.saveBatch(warningList);
        }
    }

    public InsectWarningTask(InsectDataMapper insectDataMapper, WarningService warningService) {
        this.insectDataMapper = insectDataMapper;
        this.warningService = warningService;
    }
}

