/*
 * Decompiled with CFR 0.152.
 */
package com.farm.task;

import cn.hutool.core.collection.CollectionUtil;
import com.farm.bean.AgriserveMachine;
import com.farm.bean.AgriserveMachineInspect;
import com.farm.bean.Warning;
import com.farm.service.AgriserveMachineService;
import com.farm.service.WarningService;
import com.farm.util.DateUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MachineInspectTask {
    private static final Logger log = LoggerFactory.getLogger(MachineInspectTask.class);
    private final AgriserveMachineService machineService;
    private final WarningService warningService;

    @Scheduled(cron="0 0 0 1 1 ? ")
    @Transactional
    public void refreshMachineInspect() {
        log.info("===========================\u6b63\u5728\u6267\u884c\u519c\u673a\u5e74\u68c0\u6570\u636e\u5237\u65b0===========================");
        List list = this.machineService.getBeforeInspect();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            List inspectList = list.stream().map(inspect -> {
                AgriserveMachineInspect result = new AgriserveMachineInspect();
                result.setMachineId(inspect.getMachineId());
                result.setInspection(DateUtil.addYears((String)inspect.getInspection(), (int)1));
                result.setIsInspect(Integer.valueOf(0));
                result.setIsSign(Integer.valueOf(0));
                return result;
            }).collect(Collectors.toList());
            this.machineService.batchInsert(inspectList);
        }
    }

    @Scheduled(cron="0 0 1 * * ? ")
    @Transactional
    public void refreshWarningt() {
        log.info("===========================\u6b63\u5728\u6267\u884c\u519c\u673a\u5e74\u68c0\u65f6\u95f4\u8d85\u8fc7\u4e00\u5e74\u53d1\u9884\u8b66===========================");
        String date = DateUtil.date2String((Date)new Date(), (DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        String subDate = DateUtil.addDate((String)date, (int)-1);
        List list = this.machineService.getInspect(subDate);
        for (AgriserveMachineInspect inspect : list) {
            AgriserveMachine machine = (AgriserveMachine)this.machineService.getById((Serializable)((Object)inspect.getMachineId()));
            Warning warning = new Warning();
            warning.setStatus(Integer.valueOf(-1));
            warning.setCompany("\u519c\u673a\u53d1\u5c55\u4e2d\u5fc3");
            warning.setLeader("\u65b9\u8d85");
            warning.setWarningType(Integer.valueOf(machine.getType() == 0 || machine.getType() == 2 ? 2 : 1));
            warning.setRelId(machine.getId().toString());
            warning.setContent((machine.getType() == 0 ? "\u62d6\u62c9\u673a" : (machine.getType() == 1 ? "\u63d2\u79e7\u673a" : (machine.getType() == 2 ? "\u6536\u5272\u673a" : (machine.getType() == 3 ? "\u70d8\u5e72\u673a" : "\u65e0\u4eba\u673a")))) + machine.getFrameNumber() + "\u5df2\u7ecf\u8d85\u8fc7\u4e00\u5e74\u672a\u5e74\u68c0");
            warning.setModule(Integer.valueOf(6));
            warning.setRule(Integer.valueOf(machine.getType() == 0 || machine.getType() == 2 ? 1 : 2));
            this.warningService.insert(warning);
        }
    }

    public MachineInspectTask(AgriserveMachineService machineService, WarningService warningService) {
        this.machineService = machineService;
        this.warningService = warningService;
    }
}

