/*
 * Decompiled with CFR 0.152.
 */
package com.farm.task;

import com.farm.bean.Warning;
import com.farm.service.AgriserveMachineService;
import com.farm.service.WarningService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MachineWarningTask {
    private static final Logger log = LoggerFactory.getLogger(MachineWarningTask.class);
    private final AgriserveMachineService machineService;
    private final WarningService warningService;

    public void machineTask() {
        List ids = this.machineService.selectWarningDataIds(Integer.valueOf(1));
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        ArrayList warningList = new ArrayList();
        List agriserveMachines = this.machineService.lifeYellowWarning(ids);
        if (agriserveMachines.size() > 0) {
            agriserveMachines.forEach(a -> {
                Warning warning = new Warning();
                warning.setCompany("\u519c\u673a\u5316\u53d1\u5c55\u4e2d\u5fc3");
                warning.setLeader("\u65b9\u8d85");
                warning.setWarningDate(time);
                warning.setWarningType(Integer.valueOf(1));
                warning.setContent("\u673a\u5177" + a.getEngineNumber() + "\u5e74\u9650\u5df2\u8fbe" + a.getYear() + "\u5e74");
                warning.setRelId(a.getId().toString());
                warning.setCreateTime(time);
                warning.setModule(Integer.valueOf(6));
                warning.setRule(Integer.valueOf(3));
                warningList.add(warning);
            });
        }
        if ((agriserveMachines = this.machineService.lifeRedWarning(ids = this.machineService.selectWarningDataIds(Integer.valueOf(2)))).size() > 0) {
            agriserveMachines.forEach(a -> {
                Warning warning = new Warning();
                warning.setCompany("\u519c\u673a\u5316\u53d1\u5c55\u4e2d\u5fc3");
                warning.setLeader("\u65b9\u8d85");
                warning.setWarningDate(time);
                warning.setWarningType(Integer.valueOf(0));
                warning.setContent("\u673a\u5177" + a.getEngineNumber() + "\u5e74\u9650\u5df2\u8fbe" + a.getYear() + "\u5e74");
                warning.setRelId(a.getId().toString());
                warning.setCreateTime(time);
                warning.setModule(Integer.valueOf(6));
                warning.setRule(Integer.valueOf(3));
                warningList.add(warning);
            });
        }
        if ((agriserveMachines = this.machineService.OneYearInspection(ids = this.machineService.selectWarningDataIds(Integer.valueOf(3)))).size() > 0) {
            agriserveMachines.forEach(a -> {
                Warning warning = new Warning();
                warning.setCompany("\u519c\u673a\u5316\u53d1\u5c55\u4e2d\u5fc3");
                warning.setLeader("\u65b9\u8d85");
                warning.setWarningDate(time);
                warning.setWarningType(Integer.valueOf(0));
                warning.setContent("\u673a\u5177" + a.getEngineNumber() + "\u5df2" + a.getYear() + "\u5e74\u672a\u5e74\u68c0");
                warning.setRelId(a.getId().toString());
                warning.setCreateTime(time);
                warning.setModule(Integer.valueOf(6));
                warning.setRule(Integer.valueOf(3));
                warningList.add(warning);
            });
        }
        this.warningService.saveBatch(warningList);
    }

    public MachineWarningTask(AgriserveMachineService machineService, WarningService warningService) {
        this.machineService = machineService;
        this.warningService = warningService;
    }
}

