/*
 * Decompiled with CFR 0.152.
 */
package com.farm.task;

import com.farm.controller.zzd.GovernmentUserController;
import com.farm.service.TaskService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class OrganizationTask {
    private static final Logger log = LoggerFactory.getLogger(OrganizationTask.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private GovernmentUserController governmentUserController;

    public Boolean putLock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)("lyt" + key), (Object)"1", 10L, TimeUnit.SECONDS);
    }

    public void syncOrganizationToSx() {
        Boolean flag = this.putLock("syncOrgan");
        if (flag.booleanValue()) {
            this.taskService.syncOrganizationToSx();
            log.error("\u672c\u673a\u6267\u884c\uff1a\u540c\u6b65\u7ec4\u7ec7\u4fe1\u606f\u5230\u6570\u6eaa\u6167\u79cd\u7530");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u540c\u6b65\u7ec4\u7ec7\u4fe1\u606f\u5230\u6570\u6eaa\u6167\u79cd\u7530");
        }
    }

    public void syncUserInfoToSx() {
        Boolean flag = this.putLock("syncUser");
        if (flag.booleanValue()) {
            this.taskService.syncUserInfoToSx(100);
            log.error("\u672c\u673a\u6267\u884c\uff1a\u540c\u6b65\u7528\u6237\u4fe1\u606f\u5230\u6570\u6eaa\u6167\u79cd\u7530");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u540c\u6b65\u7528\u6237\u4fe1\u606f\u5230\u6570\u6eaa\u6167\u79cd\u7530");
        }
    }

    public void syncUserOrganInfoToSx() {
        Boolean flag = this.putLock("syncUserOrgan");
        if (flag.booleanValue()) {
            Integer status = this.taskService.syncUserOrganInfoToSx();
            if (status == 1) {
                log.error("\u6682\u65e0\u65b0\u7528\u6237\u5173\u8054\u7ec4\u7ec7\u4fe1\u606f\u6570\u636e\u9700\u8981\u540c\u6b65");
            } else if (status == 0) {
                log.error("\u7528\u6237\u5173\u8054\u7ec4\u7ec7\u4fe1\u606f \u4fe1\u606f\u540c\u6b65\u5b8c\u6210");
            }
            log.error("\u672c\u673a\u6267\u884c\uff1a\u540c\u6b65 \u7528\u6237\u5173\u8054\u7ec4\u7ec7\u4fe1\u606f\u5230\u6570\u6eaa\u6167\u79cd\u7530");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u540c\u6b65 \u7528\u6237\u5173\u8054\u7ec4\u7ec7\u4fe1\u606f\u5230\u6570\u6eaa\u6167\u79cd\u7530");
        }
    }

    public void updateFieldToSx() {
        Boolean flag = this.putLock("syncFieldInfo");
        if (flag.booleanValue()) {
            Integer count = this.taskService.syncFieldInfoToSx(100);
            if (count == 0) {
                log.error("\u6682\u65e0\u65b0\u7530\u5757\u4fe1\u606f\u6570\u636e\u9700\u8981\u540c\u6b65");
            } else {
                log.error("\u65b0\u7530\u5757\u4fe1\u606f{}\u5757\uff0c\u4fe1\u606f\u540c\u6b65\u5b8c\u6210", (Object)count);
            }
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u540c\u6b65\u65b0\u7530\u5757\u4fe1\u606f \u5230\u6570\u6eaa\u6167\u79cd\u7530");
        }
    }

    @Scheduled(cron="0 58 23 ? * *")
    public void updateDailyDataStatistics() {
        Boolean flag = this.putLock("updateDailyDataStatistics");
        if (flag.booleanValue()) {
            this.taskService.updateDailyDataStatistics();
            log.error("\u672c\u673a\u6267\u884c\uff1a\u6bcf\u65e5\u66f4\u65b0\u7edf\u8ba1\u6240\u6709\u7530\u5feb\u7167");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u6bcf\u65e5\u66f4\u65b0\u7edf\u8ba1\u6240\u6709\u7530\u5feb\u7167");
        }
    }
}

