/*
 * Decompiled with CFR 0.152.
 */
package com.farm.task;

import cn.hutool.core.date.DateUtil;
import com.farm.bean.bo.WarningBo;
import com.farm.bean.vo.DpDataVo;
import com.farm.mapper.DpDataMapper;
import com.farm.service.WarningService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class RecycleWaringTask {
    private static final Logger log = LoggerFactory.getLogger(RecycleWaringTask.class);
    @Resource
    private DpDataMapper dpDataMapper;
    @Resource
    private WarningService warningService;

    @Scheduled(cron="0 0 0 1 6 *")
    public void handleWaring0() {
        DpDataVo dpDataVo = this.dpDataMapper.queryDataByTypeCode(Integer.valueOf(60003));
        List hsl = this.dpDataMapper.queryListByWaring(Integer.valueOf(60001), Integer.valueOf(1), DateUtil.now());
        ArrayList<WarningBo> list = new ArrayList<WarningBo>();
        if (dpDataVo != null && dpDataVo.getData() != null && dpDataVo.getData().getString("ndrwl") != null) {
            Double ndrwl = dpDataVo.getData().getDouble("ndrwl");
            AtomicReference<Double> sum = new AtomicReference<Double>(0.0);
            if (hsl != null && hsl.size() > 0) {
                hsl.forEach(item -> {
                    if (DateUtil.parse((CharSequence)item.getData().getString("time"), (String)"yyyy-MM-dd").getTime() <= DateUtil.parse((CharSequence)(DateUtil.year((Date)DateUtil.date()) + "-12-01"), (String)"yyyy-MM-dd").getTime()) {
                        Double h = item.getData().getDouble("h");
                        sum.updateAndGet(v -> v + h);
                    }
                });
                if (ndrwl == 0.0 || sum.get() / ndrwl < 0.3) {
                    WarningBo warningBo = new WarningBo();
                    warningBo.setStatus(Integer.valueOf(0));
                    warningBo.setContent("\u56de\u6536\u7387\u5e74\u5ea6\u4efb\u52a1\u4ec5\u5b8c\u6210" + String.format("%.2f", sum.get() / ndrwl * 100.0) + "%");
                    warningBo.setLeader("\u90d1\u7490\u83b9");
                    warningBo.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                    warningBo.setWarningDate(DateUtil.now());
                    warningBo.setWarningType(Integer.valueOf(0));
                    warningBo.setModule(Integer.valueOf(7));
                    warningBo.setRule(Integer.valueOf(2));
                    list.add(warningBo);
                }
            }
        }
        if (list.size() > 0) {
            this.warningService.saveOrUpdate(list);
        }
    }

    @Scheduled(cron="0 0 0 1 9 *")
    public void handleWaring1() {
        DpDataVo dpDataVo = this.dpDataMapper.queryDataByTypeCode(Integer.valueOf(60003));
        List hsl = this.dpDataMapper.queryListByWaring(Integer.valueOf(60001), Integer.valueOf(1), DateUtil.now());
        List czl = this.dpDataMapper.queryListByWaring(Integer.valueOf(60002), Integer.valueOf(1), DateUtil.now());
        ArrayList<WarningBo> list = new ArrayList<WarningBo>();
        if (dpDataVo != null && dpDataVo.getData() != null && dpDataVo.getData().getString("ndrwl") != null) {
            Double ndrwl = dpDataVo.getData().getDouble("ndrwl");
            AtomicReference<Double> sum = new AtomicReference<Double>(0.0);
            if (hsl != null && hsl.size() > 0) {
                hsl.forEach(item -> {
                    if (DateUtil.parse((CharSequence)item.getData().getString("time"), (String)"yyyy-MM-dd").getTime() <= DateUtil.parse((CharSequence)(DateUtil.year((Date)DateUtil.date()) + "-09-01"), (String)"yyyy-MM-dd").getTime()) {
                        Double h = item.getData().getDouble("h");
                        sum.updateAndGet(v -> v + h);
                    }
                });
                if (ndrwl == 0.0 || sum.get() / ndrwl < 0.6) {
                    WarningBo warningBo = new WarningBo();
                    warningBo.setStatus(Integer.valueOf(0));
                    warningBo.setContent("\u56de\u6536\u7387\u5e74\u5ea6\u4efb\u52a1\u4ec5\u5b8c\u6210" + String.format("%.2f", sum.get() / ndrwl * 100.0) + "%");
                    warningBo.setLeader("\u90d1\u7490\u83b9");
                    warningBo.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                    warningBo.setWarningDate(DateUtil.now());
                    warningBo.setWarningType(Integer.valueOf(0));
                    warningBo.setModule(Integer.valueOf(7));
                    warningBo.setRule(Integer.valueOf(3));
                    list.add(warningBo);
                }
            }
            if (czl != null && czl.size() > 0 && hsl != null && hsl.size() > 0) {
                AtomicReference<Double> czlSum = new AtomicReference<Double>(0.0);
                czl.forEach(item -> {
                    if (DateUtil.parse((CharSequence)item.getData().getString("time"), (String)"yyyy-MM-dd").getTime() <= DateUtil.parse((CharSequence)(DateUtil.year((Date)DateUtil.date()) + "-09-01"), (String)"yyyy-MM-dd").getTime()) {
                        Double h = item.getData().getDouble("h");
                        czlSum.updateAndGet(v -> v + h);
                    }
                });
                if (sum.get() == 0.0 || czlSum.get() / sum.get() < 0.8) {
                    WarningBo warningBo = new WarningBo();
                    warningBo.setStatus(Integer.valueOf(0));
                    warningBo.setContent("\u5904\u7f6e\u7387\u5e74\u5ea6\u4efb\u52a1\u4ec5\u5b8c\u6210" + String.format("%.2f", sum.get() / ndrwl * 100.0) + "%");
                    warningBo.setLeader("\u90d1\u7490\u83b9");
                    warningBo.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                    warningBo.setWarningDate(DateUtil.now());
                    warningBo.setWarningType(Integer.valueOf(1));
                    warningBo.setModule(Integer.valueOf(7));
                    warningBo.setRule(Integer.valueOf(5));
                    list.add(warningBo);
                }
            }
        }
        if (list.size() > 0) {
            this.warningService.saveOrUpdate(list);
        }
    }

    @Scheduled(cron="0 0 0 1 12 *")
    public void handleWaring2() {
        DpDataVo dpDataVo = this.dpDataMapper.queryDataByTypeCode(Integer.valueOf(60003));
        List hsl = this.dpDataMapper.queryListByWaring(Integer.valueOf(60001), Integer.valueOf(1), DateUtil.now());
        ArrayList<WarningBo> list = new ArrayList<WarningBo>();
        if (dpDataVo != null && dpDataVo.getData() != null && dpDataVo.getData().getString("ndrwl") != null) {
            Double ndrwl = dpDataVo.getData().getDouble("ndrwl");
            AtomicReference<Double> sum = new AtomicReference<Double>(0.0);
            if (hsl != null && hsl.size() > 0) {
                hsl.forEach(item -> {
                    if (DateUtil.parse((CharSequence)item.getData().getString("time"), (String)"yyyy-MM-dd").getTime() <= DateUtil.parse((CharSequence)(DateUtil.year((Date)DateUtil.date()) + "-12-01"), (String)"yyyy-MM-dd").getTime()) {
                        Double h = item.getData().getDouble("h");
                        sum.updateAndGet(v -> v + h);
                    }
                });
                if (ndrwl == 0.0 || sum.get() / ndrwl < 0.91) {
                    WarningBo warningBo = new WarningBo();
                    warningBo.setStatus(Integer.valueOf(0));
                    warningBo.setContent("\u56de\u6536\u7387\u5e74\u5ea6\u4efb\u52a1\u4ec5\u5b8c\u6210" + String.format("%.2f", sum.get() / ndrwl * 100.0) + "%");
                    warningBo.setLeader("\u90d1\u7490\u83b9");
                    warningBo.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                    warningBo.setWarningDate(DateUtil.now());
                    warningBo.setWarningType(Integer.valueOf(0));
                    warningBo.setModule(Integer.valueOf(7));
                    warningBo.setRule(Integer.valueOf(4));
                    list.add(warningBo);
                }
            }
        }
        if (list.size() > 0) {
            this.warningService.saveOrUpdate(list);
        }
    }

    @Scheduled(cron="0 0 0 31 12 *")
    public void handleWaring3() {
        ArrayList<WarningBo> list = new ArrayList<WarningBo>();
        List hsl = this.dpDataMapper.queryListByWaring(Integer.valueOf(60001), Integer.valueOf(1), DateUtil.now());
        List czl = this.dpDataMapper.queryListByWaring(Integer.valueOf(60002), Integer.valueOf(1), DateUtil.now());
        AtomicReference<Double> sum = new AtomicReference<Double>(0.0);
        if (czl != null && czl.size() > 0 && hsl != null && hsl.size() > 0) {
            hsl.forEach(item -> {
                Double h = item.getData().getDouble("h");
                sum.updateAndGet(v -> v + h);
            });
            AtomicReference<Double> czlSum = new AtomicReference<Double>(0.0);
            czl.forEach(item -> {
                Double h = item.getData().getDouble("h");
                czlSum.updateAndGet(v -> v + h);
            });
            if (sum.get() == 0.0 || czlSum.get() / sum.get() < 1.0) {
                WarningBo warningBo = new WarningBo();
                warningBo.setStatus(Integer.valueOf(0));
                warningBo.setContent("\u5904\u7f6e\u7387\u5e74\u5ea6\u4efb\u52a1\u4ec5\u5b8c\u6210" + String.format("%.2f", czlSum.get() / sum.get() * 100.0) + "%");
                warningBo.setLeader("\u90d1\u7490\u83b9");
                warningBo.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                warningBo.setWarningDate(DateUtil.now());
                warningBo.setWarningType(Integer.valueOf(0));
                warningBo.setModule(Integer.valueOf(7));
                warningBo.setRule(Integer.valueOf(6));
                list.add(warningBo);
            }
        }
        if (list.size() > 0) {
            this.warningService.saveOrUpdate(list);
        }
    }
}

