/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    private static final long DATE_MILLISECOND = 86400000L;
    public static final DateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateFormat DEFAULT_FORMAT_Y_M_D = new SimpleDateFormat("yyyy-MM-dd");
    private static final String START_OF_2022 = "2022-01-01";

    public static String addDate(String startDate, int days) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = dateFormat.parse(startDate);
            return dateFormat.format(new Date(date.getTime() + (long)days * 86400000L));
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("\u3010%s\u3011\u65e5\u671f\u8f6c\u5316\u9519\u8bef", startDate));
        }
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static List<String> findDates(String dStart, String dEnd) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> dateList = null;
        try {
            Calendar cStart = Calendar.getInstance();
            cStart.setTime(sdf.parse(dStart));
            dateList = new ArrayList<String>();
            dateList.add(dStart + " 00:00:00");
            while (sdf.parse(dEnd).after(cStart.getTime())) {
                cStart.add(5, 1);
                dateList.add(sdf.format(cStart.getTime()) + " 00:00:00");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateList;
    }

    public static Integer getYear(Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

    public static Date string2Date(String time, DateFormat format) {
        try {
            return format.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date string2Date(String time, String pattern) {
        try {
            return DateUtil.getDateParser((String)pattern).parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String date2String(Date date) {
        return DateUtil.date2String((Date)date, (DateFormat)DEFAULT_FORMAT);
    }

    public static String date2String(Date date, DateFormat format) {
        return format.format(date);
    }

    private static SimpleDateFormat getDateParser(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static Date addYears(Date date, int amount) {
        return DateUtil.add((Date)date, (int)amount);
    }

    public static String addYears(String dateStr, int amount) {
        Date date = DateUtil.stringToDates((String)dateStr);
        Date newDate = DateUtil.addYears((Date)date, (int)1);
        String newDateStr = DateUtil.date2String((Date)newDate, (DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        return newDateStr;
    }

    private static Date add(Date date, int amount) {
        if (null == date) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(1, amount);
        return calendar.getTime();
    }

    public static boolean between(Date srcDate, Date startDate, Date endDate) {
        if (startDate.after(srcDate)) {
            return false;
        }
        return !endDate.before(srcDate);
    }

    public static Date stringToDates(String str) {
        Date date = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            date = formatter.parse(str);
        }
        catch (ParseException e) {
            return date;
        }
        return date;
    }

    public static List<Date> getAllDays(Date startTime, Date endTime) {
        ArrayList<Date> listDay = new ArrayList<Date>();
        Date dtDay = new Date();
        dtDay = startTime;
        while (dtDay.compareTo(endTime) <= 0) {
            listDay.add(dtDay);
            dtDay = DateUtil.dateAddDays((Date)dtDay, (int)1);
        }
        return listDay;
    }

    public static Date dateAddDays(Date startDate, int days) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(5, c.get(5) + days);
        return c.getTime();
    }

    public static LocalDate dateToLocalDate(Date date) {
        if (date != null) {
            Instant instant = date.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate localDate = instant.atZone(zoneId).toLocalDate();
            return localDate;
        }
        return null;
    }

    public static String dateToString(Date date, String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern) && date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String dateString = formatter.format(date);
        return dateString;
    }
}

