/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.config.excelhandler.CustomSheetWriteHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportUtil {
    private static final Logger log = LoggerFactory.getLogger(ExportUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExport(HttpServletResponse response, JSONArray list, String chinaName, String keyName, List<JSONObject> selectValue) {
        ServletOutputStream out = null;
        InputStream fileInputStream = null;
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        try {
            out = response.getOutputStream();
            response.setContentType("mutipart/form-data");
            response.setCharacterEncoding("utf-8");
            String fileNam = chinaName + LocalDateTime.now().toString();
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileNam + ".xlsx", "UTF-8"));
            fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("model/" + keyName + ".xlsx");
            bos = new ByteArrayOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(fileInputStream);
            workbook.write((OutputStream)bos);
            byte[] bArray = bos.toByteArray();
            is = new ByteArrayInputStream(bArray);
            ExcelWriter excelWriter = selectValue != null && selectValue.size() > 0 ? ((ExcelWriterBuilder)EasyExcel.write((OutputStream)out).registerWriteHandler((WriteHandler)new CustomSheetWriteHandler(selectValue))).withTemplate(is).build() : EasyExcel.write((OutputStream)out).withTemplate(is).build();
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
            excelWriter.fill((Object)list, writeSheet);
            excelWriter.finish();
            out.flush();
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5bfc\u51fa\u9519\u8bef");
            e.printStackTrace();
        }
        finally {
            try {
                fileInputStream.close();
                is.close();
                bos.close();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

