/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmacAuthUtil {
    private static final Logger log = LoggerFactory.getLogger(HmacAuthUtil.class);

    public static Map<String, String> generateHeader(String urlStr, String requestMethod, String accessKey, String secretKey, String loginType) {
        log.info("params,urlStr={},requestMethod={},accessKey={},secretKey={}", new Object[]{urlStr, requestMethod, accessKey, secretKey});
        HashMap<String, String> header = new HashMap<String, String>();
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String date = dateFormat.format(new Date());
            URL url = new URL(urlStr);
            URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null);
            String message = requestMethod.toUpperCase() + "\n" + uri.getPath() + "\n\n" + accessKey + "\n" + date + "\n";
            Mac hasher = Mac.getInstance("HmacSHA256");
            hasher.init(new SecretKeySpec(secretKey.getBytes(), "HmacSHA256"));
            byte[] hash = hasher.doFinal(message.getBytes());
            DatatypeConverter.printHexBinary((byte[])hash);
            String sign = DatatypeConverter.printBase64Binary((byte[])hash);
            header.put("X-BG-HMAC-SIGNATURE", sign);
            header.put("X-BG-HMAC-ALGORITHM", "hmac-sha256");
            header.put("X-BG-HMAC-ACCESS-KEY", accessKey);
            header.put("X-BG-DATE-TIME", date);
        }
        catch (Exception e) {
            log.error("generate error", (Throwable)e);
            throw new RuntimeException("generate header error");
        }
        log.info("header info,{}", header);
        return header;
    }
}

