/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NfHttpUtils {
    private static final Logger log = LoggerFactory.getLogger(NfHttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, String param) {
        StringBuilder result = new StringBuilder();
        BufferedReader in = null;
        String urlNameString = url;
        try {
            String line;
            if (param != null || param != "") {
                urlNameString = urlNameString + "?" + param;
            }
            URL realUrl = new URL(urlNameString);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (ConnectException e) {
            e.printStackTrace();
        }
        catch (SocketTimeoutException | ConnectTimeoutException e) {
            e.printStackTrace();
            System.out.println("sendGet SocketTimeoutException, url=" + url + ",param=" + param);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("sendGet IOException, url=" + url + ",param=" + param);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("sendGet Exception, url=" + url + ",param=" + param);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("sendGet Exception, url=" + url + ",param=" + param);
            }
        }
        return result.toString();
    }

    public static JSONObject doPost(String path, JSONObject Info) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(path);
        post.setHeader("Content-Type", "application/json");
        post.addHeader("Authorization", "Basic YWRtaW46");
        String result = "";
        try {
            StringEntity s = new StringEntity(Info.toString(), "utf-8");
            s.setContentEncoding("application/json");
            post.setEntity((HttpEntity)s);
            HttpResponse httpResponse = client.execute((HttpUriRequest)post);
            InputStream inStream = httpResponse.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "utf-8"));
            StringBuilder strber = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                strber.append(line + "\n");
            }
            inStream.close();
            result = strber.toString();
            System.out.println(result);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                System.out.println("\u8bf7\u6c42\u670d\u52a1\u5668\u6210\u529f\uff0c\u505a\u76f8\u5e94\u5904\u7406");
            } else {
                System.out.println("\u8bf7\u6c42\u670d\u52a1\u7aef\u5931\u8d25");
            }
        }
        catch (Exception e) {
            System.out.println("\u8bf7\u6c42\u5f02\u5e38");
            throw new RuntimeException(e);
        }
        return JSONObject.parseObject((String)result);
    }

    public static JSONObject doPostNf(String path, String param, String apiId, String appKey, String signature, Long time) throws IOException {
        String url = "https://szsn.zjagri.cn/gateway/data/v1.2/";
        path = url + path;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(path);
        post.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        post.addHeader("X-Auth-ActionId", apiId);
        post.addHeader("X-Auth-Key", appKey);
        post.addHeader("X-Auth-Signature", signature);
        post.addHeader("X-Auth-Timestamp", String.valueOf(time));
        String result = "";
        try {
            StringEntity s = new StringEntity(param, "utf-8");
            s.setContentEncoding("application/json");
            post.setEntity((HttpEntity)s);
            HttpResponse httpResponse = client.execute((HttpUriRequest)post);
            System.out.println(httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                log.error("\u6d59\u6c5f\u4e61\u6751\u5927\u8111----\u8bf7\u6c42\u670d\u52a1\u7aef\u5931\u8d25");
            }
            InputStream inStream = httpResponse.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "utf-8"));
            StringBuilder strber = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                strber.append(line + "\n");
            }
            inStream.close();
            result = strber.toString();
        }
        catch (Exception e) {
            log.error("\u6d59\u6c5f\u4e61\u6751\u5927\u8111----\u519c\u5e9f\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38");
            e.printStackTrace();
        }
        return JSONObject.parseObject((String)result);
    }
}

