/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.farm.util.SqlUtil;
import com.farm.util.StringUtils;
import java.io.Serializable;

public class PageQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer pageSize;
    private Integer pageNum;
    private String orderByColumn;
    private String isAsc;
    public static final int DEFAULT_PAGE_NUM = 1;
    public static final int DEFAULT_PAGE_SIZE = Integer.MAX_VALUE;

    public <T> Page<T> build() {
        Integer pageNum = (Integer)ObjectUtil.defaultIfNull((Object)this.getPageNum(), (Object)1);
        Integer pageSize = (Integer)ObjectUtil.defaultIfNull((Object)this.getPageSize(), (Object)Integer.MAX_VALUE);
        if (pageNum <= 0) {
            pageNum = 1;
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        OrderItem orderItem = this.buildOrderItem();
        if (ObjectUtil.isNotNull((Object)orderItem)) {
            page.addOrder(new OrderItem[]{orderItem});
        }
        return page;
    }

    private OrderItem buildOrderItem() {
        if ("ascending".equals(this.isAsc)) {
            this.isAsc = "asc";
        } else if ("descending".equals(this.isAsc)) {
            this.isAsc = "desc";
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderByColumn)) {
            String orderBy = SqlUtil.escapeOrderBySql((String)this.orderByColumn);
            orderBy = StringUtils.toUnderScoreCase((String)orderBy);
            if ("asc".equals(this.isAsc)) {
                return OrderItem.asc((String)orderBy);
            }
            if ("desc".equals(this.isAsc)) {
                return OrderItem.desc((String)orderBy);
            }
        }
        return null;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public String getOrderByColumn() {
        return this.orderByColumn;
    }

    public String getIsAsc() {
        return this.isAsc;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public void setOrderByColumn(String orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public void setIsAsc(String isAsc) {
        this.isAsc = isAsc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageQuery)) {
            return false;
        }
        PageQuery other = (PageQuery)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        String this$orderByColumn = this.getOrderByColumn();
        String other$orderByColumn = other.getOrderByColumn();
        if (this$orderByColumn == null ? other$orderByColumn != null : !this$orderByColumn.equals(other$orderByColumn)) {
            return false;
        }
        String this$isAsc = this.getIsAsc();
        String other$isAsc = other.getIsAsc();
        return !(this$isAsc == null ? other$isAsc != null : !this$isAsc.equals(other$isAsc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        String $orderByColumn = this.getOrderByColumn();
        result = result * 59 + ($orderByColumn == null ? 43 : $orderByColumn.hashCode());
        String $isAsc = this.getIsAsc();
        result = result * 59 + ($isAsc == null ? 43 : $isAsc.hashCode());
        return result;
    }

    public String toString() {
        return "PageQuery(pageSize=" + this.getPageSize() + ", pageNum=" + this.getPageNum() + ", orderByColumn=" + this.getOrderByColumn() + ", isAsc=" + this.getIsAsc() + ")";
    }
}

