/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.util.HttpSendUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ZnmUtil {
    private static final Logger log = LoggerFactory.getLogger(ZnmUtil.class);
    @Value(value="${znm.host}")
    public String HOST;
    @Value(value="${znm.clientid}")
    public String CLIENTID;
    @Value(value="${znm.secret}")
    public String CLIENTSECRET;
    @Value(value="${znm.resolveurl}")
    public String RESOLVEURL;
    public static String TOKENURL = "/hydra-znm-api/api/v1/oauth/token";
    public static String CODEDOWNLOADURL = "/hydra-znm-api/api/v1/znm/codeDownload";
    public static String CODEAPPLYURL = "/hydra-znm-api/api/v1/znm/saveZnmCodeApply";
    public static String ACQZNMQRCODELIST = "/hydra-znm-api/api/v1/znm/getZnmQrCodeList";
    @Autowired
    private StringRedisTemplate redisTemplate;

    public String acquireToken() {
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)"znmToken");
        if (StringUtils.isNotBlank((String)accessToken)) {
            return accessToken;
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("clientId", (Object)this.CLIENTID);
        reqJson.put("clientSecret", (Object)this.CLIENTSECRET);
        reqJson.put("grantType", (Object)"client_credentials");
        JSONObject resJson = new JSONObject();
        try {
            String response = HttpSendUtil.sendHttpPost((String)this.HOST, (String)TOKENURL, (String)"", (String)reqJson.toJSONString());
            resJson = JSONObject.parseObject((String)response);
            JSONObject results = resJson.getJSONObject("results");
            Integer expiresIn = results.getInteger("expiresIn");
            accessToken = results.getString("tokenType") + " " + results.getString("accessToken");
            this.redisTemplate.opsForValue().set((Object)"znmToken", (Object)accessToken, (long)expiresIn.intValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return accessToken;
    }

    public String znmFarmerCodeApply(String address, String identityCard, String farmerName, String phone, String regionCode) {
        String token = this.acquireToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", token);
        JSONObject reqJson = new JSONObject();
        reqJson.put("clientId", (Object)this.CLIENTID);
        reqJson.put("codeFrom", (Object)2);
        reqJson.put("codeTotal", (Object)1);
        reqJson.put("qrCodeStyle", (Object)1);
        reqJson.put("resolveUrl", (Object)this.RESOLVEURL);
        reqJson.put("useForCode", (Object)"040200");
        reqJson.put("extendType", (Object)3);
        JSONArray farmerUploadDtoList = new JSONArray();
        JSONObject farmJson = new JSONObject();
        farmJson.put("address", (Object)address);
        farmJson.put("householdCode", (Object)identityCard);
        farmJson.put("farmerName", (Object)farmerName);
        farmJson.put("areaNumber", (Object)regionCode);
        farmJson.put("identityCard", (Object)identityCard);
        farmJson.put("mobileNumber", (Object)phone);
        farmerUploadDtoList.add((Object)farmJson);
        reqJson.put("farmerUploadDtoList", (Object)farmerUploadDtoList);
        try {
            String response = HttpSendUtil.sendHttpPost((String)this.HOST, (String)CODEAPPLYURL, (String)"", (String)reqJson.toJSONString(), headers);
            JSONObject resJson = JSONObject.parseObject((String)response);
            System.out.println(resJson.containsKey((Object)"results"));
            System.out.println(resJson.getJSONObject("results"));
            if (resJson.containsKey((Object)"results")) {
                JSONObject results = resJson.getJSONObject("results");
                return results.getString("znmBatchId");
            }
            log.error("\u7533\u8bf7\u6d59\u519c\u7801\u62a5\u9519\uff1a{}", (Object)resJson.toJSONString());
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return "";
    }

    public String znmFieldCodeApply(String dkbm, String farmerName, String fieldName) {
        String token = this.acquireToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", token);
        JSONObject reqJson = new JSONObject();
        reqJson.put("clientId", (Object)this.CLIENTID);
        reqJson.put("codeFrom", (Object)2);
        reqJson.put("codeTotal", (Object)1);
        reqJson.put("qrCodeStyle", (Object)1);
        reqJson.put("resolveUrl", (Object)this.RESOLVEURL);
        reqJson.put("useForCode", (Object)"030300");
        reqJson.put("extendType", (Object)3);
        JSONArray equipmentUploadDtoList = new JSONArray();
        JSONObject fieldJson = new JSONObject();
        fieldJson.put("belong", (Object)farmerName);
        fieldJson.put("areaNumber", (Object)"330825");
        fieldJson.put("belongType", (Object)"1");
        fieldJson.put("brand", (Object)farmerName);
        fieldJson.put("equipmentId", (Object)dkbm);
        fieldJson.put("equipmentName", (Object)fieldName);
        fieldJson.put("equipmentType", (Object)dkbm);
        equipmentUploadDtoList.add((Object)fieldJson);
        reqJson.put("equipmentUploadDtoList", (Object)equipmentUploadDtoList);
        try {
            String response = HttpSendUtil.sendHttpPost((String)this.HOST, (String)CODEAPPLYURL, (String)"", (String)reqJson.toJSONString(), headers);
            JSONObject resJson = JSONObject.parseObject((String)response);
            JSONObject results = resJson.getJSONObject("results");
            return results.getString("znmBatchId");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return "";
        }
    }

    public String znmCodeDownload(String znmBatchId) {
        String token = this.acquireToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", token);
        JSONObject resJson = new JSONObject();
        try {
            String response = HttpSendUtil.sendHttpGet((String)(this.HOST + CODEDOWNLOADURL + "?znmBatchId=" + znmBatchId), headers);
            resJson = JSONObject.parseObject((String)response);
            JSONObject jSONObject = resJson.getJSONObject("results");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return resJson.toJSONString();
    }

    public String downQrCodeList(String extendCode) {
        String token = this.acquireToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", token);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        JSONObject reqJson = new JSONObject();
        reqJson.put("address", (Object)"");
        reqJson.put("areaNumber", (Object)"");
        reqJson.put("colorReason", (Object)"\u519c\u6237\u6253\u5370\u4e8c\u7ef4\u7801\u5c55\u793a\u81ea\u5df1\u4fe1\u606f");
        reqJson.put("colorSettingMode", (Object)1);
        reqJson.put("extendCode", (Object)extendCode);
        reqJson.put("ip", (Object)"");
        reqJson.put("latitude", (Object)"");
        reqJson.put("longitude", (Object)"");
        reqJson.put("qrCodeColor", (Object)0);
        reqJson.put("qrSize", (Object)200);
        reqJson.put("showRim", (Object)0);
        reqJson.put("systemType", (Object)"");
        reqJson.put("systemVersion", (Object)"");
        list.add(reqJson);
        JSONObject resJson = new JSONObject();
        JSONObject requestJson = new JSONObject();
        requestJson.put("list", list);
        try {
            String response = HttpSendUtil.sendHttpPost((String)this.HOST, (String)ACQZNMQRCODELIST, (String)"", (String)requestJson.toJSONString(), headers);
            resJson = JSONObject.parseObject((String)response);
            JSONArray results = resJson.getJSONArray("results");
            int i = 0;
            if (i < results.size()) {
                return results.getJSONObject(i).getString("qrCodeBase64");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return resJson.toJSONString();
    }

    public static void main(String[] args) {
    }
}

