var earthRadiusMeters = 6371000.0;
var metersPerDegree = 2.0 * Math.PI * earthRadiusMeters / 360.0;
var radiansPerDegree = Math.PI / 180.0;
var degreesPerRadian = 180.0 / Math.PI;

/**
 * 计算平方米
 * points: [[x,y],[x,y]] 或者 [[{"lat":y,"lng":x},{"lat":y,"lng":x}]]
 * */
function calculateArea(points) {
    var pointArr = [];
    if (points.length > 2) {  // 数组内两个以上元素，
        pointArr = points;
    } else {
        var tmp = points[0];
        for(var i = 0; i < tmp.length; i++){
            pointArr.push([tmp[i].lng, tmp[i].lat]);
        }
    }
    if (pointArr.length > 2) {  // 数组内3个以上元素，才能计算面积
        var areaMeters2 = PlanarPolygonAreaMeters2(pointArr);
        if (areaMeters2 > 1000000.0) {
            areaMeters2 = SphericalPolygonAreaMeters2(pointArr);
        }
        return areaMeters2;
    }
}

/** 计算亩 */
function calculateAreaInMu(points) {
    return ((calculateArea(points) / 666.66).toFixed(1) + '');
}

/*球面多边形面积计算*/
function SphericalPolygonAreaMeters2(points) {
    var totalAngle = 0;
    for (var i = 0; i < points.length; i++) {
        var j = (i + 1) % points.length;
        var k = (i + 2) % points.length;
        totalAngle += Angle(points[i], points[j], points[k]);
    }
    var planarTotalAngle = (points.length - 2) * 180.0;
    var sphericalExcess = totalAngle - planarTotalAngle;
    if(sphericalExcess<0){
    	sphericalExcess+=180;
    }
    if (sphericalExcess > 420.0) {
        totalAngle = points.length * 360.0 - totalAngle;
        sphericalExcess = totalAngle - planarTotalAngle;
    } else if (sphericalExcess > 300.0 && sphericalExcess < 420.0) {
        sphericalExcess = Math.abs(360.0 - sphericalExcess);
    } else if(sphericalExcess>180 && sphericalExcess < 300.0){
    	sphericalExcess = Math.abs(sphericalExcess - 180);
    }
    return sphericalExcess * radiansPerDegree * earthRadiusMeters * earthRadiusMeters;
}

/*角度*/
function Angle(p1, p2, p3) {
    var bearing21 = Bearing(p2, p1);
    var bearing23 = Bearing(p2, p3);
    var angle = bearing21 - bearing23;
    if (angle < 0) {
        angle += 360;
    }
    return angle;
}


/*方向*/
function Bearing(from, to) {
    var lat1 = from[1] * radiansPerDegree;
    var lon1 = from[0] * radiansPerDegree;
    var lat2 = to[1] * radiansPerDegree;
    var lon2 = to[0] * radiansPerDegree;
    var angle = -Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2));
    if (angle < 0) {
        angle += Math.PI * 2.0;
    }
    angle = angle * degreesPerRadian;
    return angle;
}

/*平面多边形面积*/
function PlanarPolygonAreaMeters2(points) {
    var a = 0;
    for (var i = 0; i < points.length; ++i) {
        var j = (i + 1) % points.length;
        var xi = points[i][0] * metersPerDegree * Math.cos(points[i][1] * radiansPerDegree);
        var yi = points[i][1] * metersPerDegree;
        var xj = points[j][0] * metersPerDegree * Math.cos(points[j][1] * radiansPerDegree);
        var yj = points[j][1] * metersPerDegree;
        a += xi * yj - xj * yi;
    }
    return Math.abs(a / 2);
}

/*计算多边形周长*/
function PlanarPolygonPerimeter(points){
	var perimeter=0;
	for(var i=0;i<points.length;++i){
		if(i==points.length-1){
			perimeter+=pointDistance(points[i],points[0]);
		}else{
			perimeter+=pointDistance(points[i],points[i+1]);
		}
	}
	return perimeter;
}
/*两点之间距离*/
function pointDistance(pointA,pointB){
	var c=Math.sin(pointB[1])*Math.sin(pointA[1])+Math.cos(pointB[1])*Math.cos(pointA[1])*Math.cos(pointB[0]-pointA[0]);
	var distance=earthRadiusMeters*Math.acos(c)*radiansPerDegree;
	return distance;
}