/*
 * commonAjax.js
 * Description：共同ajax调用js
 * Creator：CaoJian
 * CreateDate：2014-03-18
 */
(function ($) {
    window.commonAjax = (function () {
        return {
            /**
             * 默认参数
             */
            defaultOption: {},
            /**
             * 共同ajax调用
             * @param url action路径
             * @param type 'POST'/'GET'
             * @param obj json格式参数
             * @param event 回调函数
             * @param errEvent 出错事件
             */
            ajaxSubmitLencoded: function (url, type, obj, event, errEvent) {
                commonAjax.tokenCheck();
                $.ajax({
                    url: url,
                    type: type,
                    data: JSON.stringify(obj),
                    contentType: "application/json",
                    dataType: "json",
                    timeout: 30000,
                    success: function (result) {
                        event(result);
                    },
                    error: function () {
                        typeof errEvent === "function" && errEvent();
                    },
                });
            },

            /**
             * 共同ajax调用
             * @param url action路径
             * @param type 'POST'/'GET'
             * @param obj json格式参数
             * @param event 回调函数
             * @param errEvent 出错事件
             */
            ajaxSubmit: function (url, type, obj, event, errEvent) {
                // commonAjax.tokenCheck();
                $.ajax({
                    url: url,
                    type: type,
                    data: JSON.stringify(obj),
                    contentType: "application/json;charset=UTF-8",
                    dataType: "json",
                    timeout: 30000,
                    success: function (result) {
                        event(result);
                    },
                    error: function () {
                        typeof errEvent === "function" && errEvent();
                    },
                });
            },
            /**
             * 共同ajax调用 同步方法
             * @param url action路径
             * @param type 'POST'/'GET'
             * @param obj json格式参数
             * @param event 回调函数
             * @param errEvent 出错事件
             */
            ajaxSubmitSync: function (url, type, obj, event, errEvent) {
                // commonAjax.tokenCheck();
                $.ajax({
                    url: url,
                    async: false,
                    type: type,
                    data: JSON.stringify(obj),
                    contentType: "application/json;charset=UTF-8",
                    dataType: "json",
                    timeout: 30000,
                    success: function (result) {
                        event(result);
                    },
                    error: function () {
                        typeof errEvent === "function" && errEvent();
                    },
                });
            },

            /**
             * 配合CommonAction的ajax
             * @param url action路径
             * @param type 'POST'/'GET'
             * @param obj json格式参数
             * @param event 回调函数
             * @param errEvent 出错事件
             */
            ajaxSubmitCommon: function (url, type, obj, event, errEvent) {
                // commonAjax.tokenCheck();
                $.ajax({
                    url: url,
                    type: type,
                    data: obj,
                    contentType: "application/x-www-form-urlencoded",
                    dataType: "json",
                    timeout: 30000,
                    success: function (result) {
                        event(result);
                    },
                    error: function () {
                        typeof errEvent === "function" && errEvent();
                    },
                });
            },
            ajaxSubmitCommonSync: function (url, type, obj, event, errEvent) {
                // commonAjax.tokenCheck();
                $.ajax({
                    url: url,
                    async: false,
                    type: type,
                    data: obj,
                    contentType: "application/x-www-form-urlencoded",
                    dataType: "json",
                    timeout: 30000,
                    success: function (result) {
                        event(result);
                    },
                    error: function () {
                        typeof errEvent === "function" && errEvent();
                    },
                });
            },

            /**
             * 获取url上的参数
             * @param name 参数名
             * @returns string
             */
            getQueryString: function (name) {
                var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
                // if (window != top) {
                //     var result = window.top.location.search.substr(1).match(reg);
                // } else {
                //     var result = window.location.search.substr(1).match(reg);
                // }
                var result = window.location.search.substr(1).match(reg);
                return result ? decodeURIComponent(result[2]) : "";
            },
            getUser: function () {
                // return commonAjax.getQueryString("_third") == "y"
                //     ? JSON.parse(localStorage.getItem("farmer"))
                //     : JSON.parse(sessionStorage.getItem("farmer"));

                return JSON.parse(localStorage.getItem("farmer"));
            },
            /**
             * 检查token有没有，
             * 如果没有token直接跳转到登录页面;
             * 如果token校验不通过，也直接跳转到登录页面；
             * 这两种情况都要清除缓存
             *
             * 当然，这种只能处理有引用commonAjax的页面；
             * 目前，其他没有commonAjax的页面也没有必要去进行token认证；因为不影响用户登录访问，不威胁服务器安全
             */
            tokenCheck: function () {
                if (window != top) {
                    var isOk = true;
                    try {
                        window.top.location.pathname; //如果跨域就报错
                    } catch (e) {
                        isOk = false;
                    }
                    if (isOk) {
                        if (window.top.location.pathname == "/farm_web/loginNew.html") {
                            // 当前是登录页，就不做判断了
                            return false;
                        }
                    } else {
                        if (window.location.pathname == "/farm_web/loginNew.html") {
                            // 当前是登录页，就不做判断了
                            return false;
                        }
                    }
                } else {
                    if (window.location.pathname == "/farm_web/loginNew.html") {
                        // 当前是登录页，就不做判断了
                        return false;
                    }
                }

                var sUserAgent = navigator.userAgent.toLowerCase();
                if (/ipad|iphone|midp|rv:1.2.3.4|ucweb|android|windows ce|windows mobile/.test(sUserAgent)) {
                    // 移动端 就不做判断
                    // 有个bug，当用户F12将pc页面切换为手机端时，就不会进行token认证了
                    // 目前可以通过禁止F12来完成
                    // 但是当用户使用手机访问pc网站时，也会出现不进行token认证的问题
                    return false;
                }
                // _third 字段为 y 时，代表是要将数字农业平台页面嵌入到第三方平台；先要在一个浏览器下打开我们的数溪WEB，然后在开始访问。这样就可以保证不用登录了。
                // 打开的web页面目前不可以关闭
                var _third = commonAjax.getQueryString("_third");
                var token = "";
                if (_third == "y") {
                    token = JSON.parse(localStorage.getItem("_t"));
                } else {
                    token = JSON.parse(localStorage.getItem("_t"));
                }
                if (!token) {
                    // 没有token字段，跳转登录
                    commonAjax.resetLoginStatus();
                } else {
                    $.ajax({
                        url: "/farm_web/user/tokenCheck",
                        type: "POST",
                        data: JSON.stringify({
                            userId: commonAjax.getUser().userId,
                            token: token,
                            appVersion: "pc",
                        }),
                        contentType: "application/json;charset=UTF-8",
                        dataType: "json",
                        timeout: 30000,
                        success: function (result) {
                            if (result["resCode"] === 0) {
                                if (!result.resData.flag || result.resData.status) {
                                    var msg = "";
                                    switch (result.resData.status) {
                                        case 1:
                                            // 商户冻结
                                            msg = "您的商户已被冻结，请联系商户管理员！";
                                            break;
                                        case 2:
                                            // 商户试用期到期
                                            msg = "您的试用期已到期，如需继续使用，请联系客服！";
                                            break;
                                        case 3:
                                            // 用户被冻结
                                            msg = "您的账号被非法冻结，请联系客服！";
                                            break;
                                        case 4:
                                            // token过期
                                            msg = "您的账号已被其他客户端登录，如不是您操作，请尽快修改密码！";
                                            break;
                                        case 5:
                                            // 用户不存在
                                            msg = "您的账号不存在，请联系客服";
                                            break;
                                        default:
                                            break;
                                    }
                                    commonAjax.resetLoginStatus(msg);
                                }
                            } else {
                                errMsg.showError(result["errCode"]);
                            }
                        },
                        error: function () {
                            typeof errEvent === "function" && errEvent();
                        },
                    });
                }
            },
            /**
             * 重置登录状态
             */
            resetLoginStatus: function (msg) {
                // 没有token字段，跳转登录
                sessionStorage.removeItem("farmer");
                sessionStorage.removeItem("_t");
                sessionStorage.removeItem("page");
                // localStorage.removeItem("farmer");
                // localStorage.removeItem("_t");
                // localStorage.removeItem("page");
                var version_v = localStorage.getItem("version_v");
                var version_userid = localStorage.getItem("version_userid");
                localStorage.clear();
                localStorage.setItem("version_v", version_v);
                localStorage.setItem("version_userid", version_userid);
                if (msg) {
                    localStorage.setItem("_m", msg);
                }
                var href = window.location.origin + "/farm_web/loginNew.html";
                if (window != top) {
                    var isOk = true;
                    try {
                        window.top.location.pathname; //如果跨域就报错
                    } catch (e) {
                        isOk = false;
                    }
                    if (isOk) {
                        window.top.location.href = href;
                    } else {
                        window.location.href = href;
                    }
                } else {
                    window.location.href = href;
                }
            },
            fobidBrower: function () {
                var debug = commonAjax.getQueryString("d");
                // if (!debug) {
                //     //当浏览器内宽和外宽的差大于20，或者内高和外高的差大于100的情况下,说明可能打开了控制台之类
                //     // TODO outerHeight - innerHeight 有bug，全屏状态下也是大于100的
                //     if (window.outerWidth - window.innerWidth > 20 || window.outerHeight - window.innerHeight > 100) {
                //         if (window != top) {
                //             if (window.top.location.pathname == "/farm_web/loginNew.html") {
                //                 // 当前是登录页，就不做判断了
                //                 return false;
                //             }
                //         } else {
                //             if (window.location.pathname == "/farm_web/loginNew.html") {
                //                 // 当前是登录页，就不做判断了
                //                 return false;
                //             }
                //         }
                //         // 打开控制台就跳转到登录页面
                //         commonAjax.resetLoginStatus();
                //     }
                // }

                document.onkeydown = function () {
                    if (!debug) {
                        if (window.event && window.event.keyCode == 123) {
                            event.keyCode = 0;
                            event.returnValue = false;
                        }
                        if (window.event && window.event.keyCode == 13) {
                            event.keyCode = 0;
                            event.returnValue = false;
                        }
                        // if (window.event && window.event.keyCode == 8) {
                        //     window.event.returnValue = false;
                        // }
                    }
                };

                document.oncontextmenu = function (event) {
                    if (!debug) {
                        // if (window.event) {
                        //     event = window.event;
                        // }
                        // try {
                        //     var the = event.srcElement;
                        //     if (!((the.tagName == "INPUT" && the.type.toLowerCase() == "text") || the.tagName == "TEXTAREA")) {
                        //         return false;
                        //     }
                        //     return true;
                        // } catch (e) {
                        //     return false;
                        // }
                        return false;
                    }
                };
            },
            /**
             * 查询当前用户的公司列表
             */
            getCompanies: function () {
                // return commonAjax.getQueryString("_third") == "y"
                //     ? JSON.parse(localStorage.getItem("companies"))
                //     : JSON.parse(sessionStorage.getItem("companies"));
                return JSON.parse(localStorage.getItem("companies"));
            },
            /**
             * 查询当前被选择的公司
             */
            getCompany: function () {
                // return commonAjax.getQueryString("_third") == "y"
                //     ? JSON.parse(localStorage.getItem("company"))
                //     : JSON.parse(sessionStorage.getItem("company"));
                return JSON.parse(localStorage.getItem("company"));
            },
            /**
             * 验证手机号
             */
            checkPhone: function (phone) {
                return /^(0|86|17951)?(1[3456789][0-9])[0-9]{8}$/.test(phone);
            },
            /****
             * 验证手机
             * ***/
            checkPhoneThree: function (phone) {
                var isPhone = /^(0|86|17951)?(1[3456789][0-9])[0-9]{8}$/;
                //var isMob=/^((\+?86)|(\(\+86\)))?(13[012356789][0-9]{8}|15[012356789][0-9]{8}|18[02356789][0-9]{8}|147[0-9]{8}|1349[0-9]{7})$/;
                var value = $(phone).val().trim();
                if (isPhone.test(value)) {
                    return true;
                } else {
                    $(phone).val("");
                    layer.msg("请输入正确的手机", { time: 1500 });
                }
            },

            /****
             * 验证手机和座机号
             * ***/
            checkPhoneTwo: function (phone) {
                var isPhone = /^([0-9]{3,4}-)?[0-9]{7,8}$/;
                var isMob = /^((\+?86)|(\(\+86\)))?(13[012356789][0-9]{8}|15[012356789][0-9]{8}|18[02356789][0-9]{8}|147[0-9]{8}|1349[0-9]{7})$/;
                var value = $(phone).val().trim();
                if (isMob.test(value) || isPhone.test(value)) {
                    return true;
                } else {
                    $(phone).val(" ");
                    layer.msg("请输入正确的手机/座机号", { time: 1500 });
                }
            },

            /**
             * 身份证格式验证
             */
            checkIdCard: function (_idCard) {
                // return /^(\d{15}$|^\d{18}$|^\d{17}(\d|X|x))$/.test(_idCard);
                return /^(^[1-9]\d{7}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])\d{3}$)|(^[1-9]\d{5}[1-9]\d{3}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])((\d{4})|\d{3}[Xx])$)$/.test(
                    _idCard
                );
            },

            /**
             * 统一社会信用代码验证
             * @param {*} blcode 统一社会信用代码
             */
            checkBL: function (blcode) {
                return /^([1-9A-GY]{1}[1239]{1}[1-5]{1}[0-9]{5}[0-9A-Z]{10})$/.test(blcode);
            },

            /**
             * 密码格式验证
             */
            checkPwd: function (pwd) {
                return /^[0-9a-zA-Z_]{6,12}$/.test(pwd);
            },

            /**
             * 只能输入中文
             * **/
            checkfont: function check(font) {
                if (!/^[\u4e00-\u9fa5]+$/gi.test(document.getElementById("uname").value)) {
                    alert("只能输入汉字");
                } else {
                    alert("提交成功");
                }
            },

            /**
             * 只能输入数字
             * gkd
             * 2019-12-17
             * ***/
            number: function (number) {
                //先把非数字的都替换掉，除了数字和.
                number.value = number.value.replace(/[^\d.]/g, "");
                return number;
            },
            /**
             * 输入金额保留2位小数
             * gkd
             * 2019-12-17
             * ***/
            numberMoney: function (obj) {
                obj.value = obj.value.replace(/[^\d.]/g, ""); //清除"数字"和"."以外的字符
                obj.value = obj.value.replace(/^\./g, ""); //验证第一个字符是数字而不是
                obj.value = obj.value.replace(/\.{2,}/g, "."); //只保留第一个. 清除多余的
                obj.value = obj.value.replace(".", "$#$").replace(/\./g, "").replace("$#$", ".");
                obj.value = obj.value.replace(/^(\-)*(\d+)\.(\d\d).*$/, "$1$2.$3"); //只能输入两个小数

                //number.value=number.value.replace(/^(\-)*(\d+)\.(\d\d).*$/,'$1$2.$3');
                //return obj.value
            },

            /***
             * 只能输入中文
             * gkd
             * 2019-12-20
             * ***/
            Chinese: function (number) {
                //先把非数字的都替换掉，除了数字和.
                number.value = number.value.replace(/[^\u4e00-\u9fa5]/g, "");
                return number;
            },

            /***
             * 不能能输入中文
             * gkd
             * 2019-12-20
             * ***/
            ChineseFalse: function (number) {
                //先把非数字的都替换掉，除了数字和.
                number.value = number.value.replace(/[\u4E00-\u9FA5]/g, "");
                return number;
            },

            /**只能输入中文和字母**/
            characterNo: function (number) {
                number.value = number.value.replace(/[\d]/g, "");
                return number;
            },

            /**
             * 只能输入数字
             * gkd
             * 2019-12-17
             * ***/
            number: function (number) {
                //先把非数字的都替换掉，除了数字和.
                number.value = number.value.replace(/[^\d.]/g, "");

                return number;
            },

            // 返回
            hisBack: function () {
                var web = this.getQueryString("web");
                if (/(iPhone|iPad|iPod|iOS)/i.test(navigator.userAgent)) {
                    //判断iPhone|iPad|iPod|iOS
                    if (web == "wk") {
                        window.webkit.messageHandlers.backClick.postMessage([]);
                    } else {
                        backClick();
                    }
                } else if (/(Android)/i.test(navigator.userAgent)) {
                    //判断Android
                    JSInterface.backClick();
                }
                history.back();
            },

            // 时间戳转日期格式
            getLocalTime: function (nS) {
                return new Date(parseInt(nS) * 1000).toLocaleString().replace(/:\d{1,2}$/, " ");
            }, //alert(getLocalTime(1551283200));

            /*** 判断接口数据获取的是否为空 **/
            ajaxdat: function (data) {
                if (data == "" || data.length == 0 || JSON.stringify(data) == "{}") {
                    return;
                }
            },
            /*** 判断值是否为空 **/
            judgeone: function (data) {
                if (data == "" || data == null || data == "NULL") {
                    data = "暂无";
                }
                return data;
            },

            /*** 判断值是否为空 **/
            judge: function (data) {
                if (data == "" || data == null || data == "NULL") {
                    data = "暂无数据";
                }
                return data;
            },

            /*** 判断值是否为空==为空的话显示空 **/
            judgetwo: function (data) {
                if (data == "" || data == null || data == undefined) {
                    data = "";
                }
                return data;
            },
            /*** 判断值是否为空==为空的话显示空 **/
            judgeThree: function (data) {
    
                if(data==0){
                    data =0;
                }else if (data == undefined || data == "" || data == null) {
                    data = "-";
                }
                return data;
            },
            /*** 判断值是否为空==为空的话显示空 **/
            judgeThreeb: function (data) {
                if (data == undefined || data == "" || data == null) {
                    data = "-";
                }else{
               
                    data=(Number(data)*100).toFixed(2)
                }
                return data;
            },


            /*** 月份中文转数组 **/
            month: function (data) {
                if (data == "一" || data == "1") {
                    data = "01";
                } else if (data == "二" || data == "2") {
                    data = "02";
                } else if (data == "三" || data == "3") {
                    data = "03";
                } else if (data == "四" || data == "4") {
                    data = "04";
                } else if (data == "五" || data == "5") {
                    data = "05";
                } else if (data == "六" || data == "6") {
                    data = "06";
                } else if (data == "七" || data == "7") {
                    data = "07";
                } else if (data == "八" || data == "8") {
                    data = "08";
                } else if (data == "九" || data == "9") {
                    data = "09";
                } else if (data == "十" || data == "10") {
                    data = "10";
                } else if (data == "十一" || data == "11") {
                    data = "11";
                } else {
                    data = "12";
                }
                return data;
            },

            /**实时动态强制更改用户录入***/
            twoMount: function (th) {
                var regStrs = [
                    ["^0(\\d+)$", "$1"], //禁止录入整数部分两位以上，但首位为0
                    ["[^\\d\\.]+$", ""], //禁止录入任何非数字和点
                    ["\\.(\\d?)\\.+", ".$1"], //禁止录入两个以上的点
                    ["^(\\d+\\.\\d{2}).+", "$1"], //禁止录入小数点后两位以上
                ];
                for (i = 0; i < regStrs.length; i++) {
                    var reg = new RegExp(regStrs[i][0]);
                    th.value = th.value.replace(reg, regStrs[i][1]);
                }
            },

            /***获取当前时间***/
            getNowFormatDate: function () {
                var date = new Date();
                var seperator1 = "-";
                var seperator2 = ":";
                var month = date.getMonth() + 1;
                var strDate = date.getDate();
                if (month >= 1 && month <= 9) {
                    month = "0" + month;
                }
                if (strDate >= 0 && strDate <= 9) {
                    strDate = "0" + strDate;
                }
                var currentdate =
                    date.getFullYear() +
                    seperator1 +
                    month +
                    seperator1 +
                    strDate +
                    " " +
                    date.getHours() +
                    seperator2 +
                    date.getMinutes() +
                    seperator2 +
                    date.getSeconds();
                return currentdate;
            },

            /****把亩数返回字段中含有中文的字符的替换**/
            modArea: function (area) {
                if (area == "" || area == null || area == "NULL") {
                    area = " ";
                } else {
                    var areaA = area.replace("亩", ".");
                    var areaB = areaA.replace("分", "");
                    area = areaB;
                }
                return area;
            },
        };
    })();
    // commonAjax.tokenCheck();
    // commonAjax.fobidBrower();
})(jQuery);
