/** 田图像 */
(function ($) {
    window.fieldImgs = (function () {
        var areaIdArr = []; //新增用于地图图片地址栏

        var typeList = ["rgb", "drone", "ndvi", "rgb", "rgb", "rgb"];
        var layerTile;
        return {
            /** 默认参数  */
            defaultOption: {
                userId: "", // 用户Id
                fieldId: "", // 田Id
                minimap: "", // 瓦片列表
                boundaries: [], // 边界列表
                tiles: {}, // 瓦片
                tileType: "0", // 瓦片类型
                center: "", // 田中心
                tileDiv:
                    '<div class="titleDivCs"><img src="{IMGSRC}"/><span  acqDate="{DATE}" tiletype="{TILETYPE}" mtype="{TYPE}" areaId="{AREAID}">{DATE}</span></div>',
                web: "",
            },

            /** 初始化 */
            init: function () {
                fieldImgs.defaultOption.fieldId = commonAjax.getQueryString("fieldId");
                fieldImgs.defaultOption.page = commonAjax.getQueryString("page");
                fieldImgs.defaultOption.keyword = commonAjax.getQueryString("keyword");
                fieldImgs.defaultOption.web = commonAjax.getQueryString("web");
                fieldImgs.btn_click();
                fieldImgs.getFieldInfo();
            },

            /** 获取指定田的详情 */
            getFieldInfo: function () {
                var param = { fieldId: fieldImgs.defaultOption.fieldId };
                commonAjax.ajaxSubmit("../field/getFieldInfo", "POST", param, function (result) {
                    if (result["resCode"] === 0) {
                        var field = result["resData"];
                        fieldImgs.showField(field);
                    } else {
                        errorMsg.showError(result["errCode"]);
                    }
                });
            },
            /** 获取指定田的图像 */
            getFieldImgs: function () {
                var param = { fieldId: fieldImgs.defaultOption.fieldId };
                commonAjax.ajaxSubmit("../field/getFieldTiles", "POST", param, function (result) {
                    if (result["resCode"] === 0) {
                        var data = result.resData;
                        var tiles = {};
                        for (var i = 0; i < data.length; i++) {
                            var type = data[i].type;
                            var list = data[i].list;
                            tiles[type] = {};
                            for (var j in list) {
                                var each = list[j];
                                var year = each.acqDate.substr(0, 4);

                                areaIdArr.push(each.area_id);

                                if (!tiles[type].hasOwnProperty(year)) {
                                    tiles[type][year] = [];
                                }
                                tiles[type][year].push(each.acqDate);
                            }
                        }
                        fieldImgs.defaultOption.tiles = tiles;

                        fieldImgs.addYearSwiper(0);

                        !!$(".s_year")[0] && $(".s_year")[0].click();
                    } else {
                        errorMsg.showError(result["errCode"]);
                    }
                });
            },

            /** 添加年列表 */
            addYearSwiper: function (type) {
                $(".swiper-wrapper").html("");
                // 年份显示
                if (!fieldImgs.defaultOption.tiles[type]) {
                    $("#swiper_year").hide();
                } else {
                    $("#swiper_year").show();
                }
                for (var year in fieldImgs.defaultOption.tiles[type]) {
                    yearSwiper.prependSlide('<div class="swiper-slide s_year">' + year + "</div>");
                }
            },
            /** 添加瓦片 */
            addTileControl: function (year) {
                console.log("全局：" + areaIdArr);

                $("input[type=checkbox]:checked").click();
                fieldImgs.defaultOption.minimap && fieldImgs.defaultOption.minimap.remove();
                var tiles = fieldImgs.defaultOption.tiles;

                var poly = L.polygon(fieldImgs.defaultOption.boundaries, {
                    fillOpacity: 0,
                });

                var b = [];
                for (var k in fieldImgs.defaultOption.boundaries[0]) {
                    b.push([+fieldImgs.defaultOption.boundaries[0][k].lng, +fieldImgs.defaultOption.boundaries[0][k].lat]);
                }

                var overLayers = {};
                // 植被指数暂时和彩色图相同
                var tt = fieldImgs.defaultOption.tileType == 2 ? 0 : fieldImgs.defaultOption.tileType;

                var maxZoom = tt == "1" ? 22 : 16;

                var tileList = tiles[tt][year];
                var html = "";
                for (var j = 0; j < tileList.length; j++) {
                    var date = tileList[j];
                    var areaId = areaIdArr[j];
                    //console.log(areaId)
                    // var imgsrc='';
                    // if(areaId!=''){
                    //     imgsrc='http://imgs.shuxitech.com/tile/bak/'+typeList[fieldImgs.defaultOption.tileType]+ '/' + areaId +'/'+fieldImgs.defaultOption.fieldId+'/'+ date + '.png';
                    // }else{
                    var imgsrc =
                        "http://imgs.shuxitech.com/tile/bak/" +
                        typeList[fieldImgs.defaultOption.tileType] +
                        "/" +
                        fieldImgs.defaultOption.fieldId +
                        "/" +
                        date +
                        ".png";
                    // };
                    html += fieldImgs.defaultOption.tileDiv
                        .replace("{IMGSRC}", imgsrc)
                        .replace("{DATE}", date)
                        .replace("{DATE}", date)
                        .replace("{TYPE}", tt)
                        .replace("{AREAID}", areaId)
                        .replace("{TILETYPE}", typeList[fieldImgs.defaultOption.tileType]);
                }
                $(".content").html(html);
                fieldImgs.bindClick();
                $(".titleDivCs")[0].click();
            },

            /** 添加地形瓦片 作废 add by gaokangdong 2018-12-20 */
            addDemTiles: function () {
                var b = [];
                for (var k in fieldImgs.defaultOption.boundaries[0]) {
                    b.push([+fieldImgs.defaultOption.boundaries[0][k].lng, +fieldImgs.defaultOption.boundaries[0][k].lat]);
                }
                //var baseLayer = new L.tileLayer('http://47.92.64.96:{s}/tile/dem/{z}/{x}/{y}.png', {
                //var baseLayer = new L.tileLayer('http://47.92.64.96:{s}/tile/dem/{z}/{x}/{y}.png', {
                //var areaId = areaIdArr[j];
                var areaId = "2018";
                var imgsrc = "";
                if (areaId != "") {
                    imgsrc = "http://47.92.64.96:{s}/tile/dem/" + areaId + "/{z}/{x}/{y}.png";
                } else {
                    imgsrc = "http://47.92.64.96:{s}/tile/dem/{z}/{x}/{y}.png";
                }
                var baseLayer = new L.tileLayer(imgsrc, {
                    maxZoom: 14,
                    tms: true,
                    subdomains: [1888, 1999],
                }).addTo(map);
            },

            /** 地图上画田边界 */
            showField: function (field) {
                var b_arr = field["boundary"].split(",");
                var boundary = [];
                for (var i = 0; i < b_arr.length; i += 2) {
                    boundary.push({ lng: b_arr[i], lat: b_arr[i + 1] });
                }
                fieldImgs.defaultOption.boundaries.push(boundary);
                // L.polygon(boundary, {fillOpacity: 0}).addTo(map);
                var poly = L.polygon(boundary, { fillOpacity: 0 }).addTo(map);
                map.fitBounds(fieldImgs.defaultOption.boundaries);
                fieldImgs.defaultOption.center = poly.getCenter();
                fieldImgs.getFieldImgs();
            },
            /**地图缩略图点击事件*/
            bindClick: function () {
                $(".titleDivCs").click(function () {
                    var tileDate = $(this).children("span").attr("acqDate");
                    var mtype = $(this).children("span").attr("mtype");
                    var tileType = $(this).children("span").attr("tileType");

                    var areaId = $(this).children("span").attr("areaId");
                    var imgsrc = "";
                    if (areaId != "") {
                        imgsrc = "http://47.92.64.96:{s}/tile/" + tileType + "/" + areaId + "/" + tileDate + "/{z}/{x}/{y}.png";
                    } else {
                        imgsrc = "http://47.92.64.96:{s}/tile/" + tileType + "/" + tileDate + "/{z}/{x}/{y}.png";
                    }
                    var baseLayer = new L.tileLayer(imgsrc, {
                        maxZoom: 22,
                        tms: true,
                        subdomains: [1888],
                    });
                    //删除之前的layerTile
                    !!layerTile && layerTile.remove();

                    var b = [];
                    for (var k in fieldImgs.defaultOption.boundaries[0]) {
                        b.push([+fieldImgs.defaultOption.boundaries[0][k].lng, +fieldImgs.defaultOption.boundaries[0][k].lat]);
                    }
                    layerTile = new L.TileLayer.BoundaryCanvas.createFromLayer(baseLayer, {
                        boundary: { type: "Polygon", coordinates: [b] },
                    });
                    layerTile.addTo(map);
                    if (map._zoom > 16) {
                        map.setZoom([16], [fieldImgs.defaultOption.tileType]);
                    }
                });
            },

            /** 点击事件 */
            btn_click: function () {
                /** 地图类型点击事件 */
                $(".c_type").click(function () {
                    !!fieldImgs.defaultOption.minimap && fieldImgs.defaultOption.minimap.remove();
                    $(".c_type").removeClass("active");
                    $(this).addClass("active");
                    fieldImgs.defaultOption.tileType = $(this).attr("data");

                    // 跳转无人机页面的按钮
                    if (/(iPhone|iPad|iPod|iOS)/i.test(navigator.userAgent)) {
                        //判断iPhone|iPad|iPod|iOS
                        if (fieldImgs.defaultOption.tileType == "1") {
                            $("#toDrone").show();
                            // $("#toDrone").hide();
                        } else {
                            $("#toDrone").hide();
                        }
                    }

                    if (fieldImgs.defaultOption.tileType == "3") {
                        // 地形图
                        $("#swiper_year").hide(); // 隐藏年份选择
                        fieldImgs.addDemTiles(); // 添加地形瓦片
                    } else {
                        $("#swiper_year").show();
                        fieldImgs.addYearSwiper(fieldImgs.defaultOption.tileType == "2" ? 0 : fieldImgs.defaultOption.tileType);
                        !!$(".s_year")[0] && $(".s_year")[0].click();
                    }
                });

                /** 自动点击第一个并跳转到适应的比例 */
                $("body").on("click", "input[type=radio]", function () {
                    if (fieldImgs.defaultOption.tileType == "1") {
                        map.fitBounds(fieldImgs.defaultOption.boundaries);
                        return;
                    }
                    if (map._zoom > 16) {
                        map.setZoom([16, 18, 16, 14, 10][fieldImgs.defaultOption.tileType]);
                    }
                    // map.setZoom([5,22][fieldImgs.defaultOption.tileType]);
                    !!fieldImgs.defaultOption.center && map.panTo(fieldImgs.defaultOption.center);
                });

                /** 年点击事件 */
                $("body").on("click", ".s_year", function () {
                    $(".s_year").removeClass("swiper-slide-active");
                    $(this).addClass("swiper-slide-active");
                    var year = $(this).text();
                    fieldImgs.addTileControl(year);
                });

                /** 点击返回 */
                $(".back").click(function () {
                    if (/(iPhone|iPad|iPod|iOS)/i.test(navigator.userAgent)) {
                        //判断iPhone|iPad|iPod|iOS
                        if (fieldImgs.defaultOption.web == "wk") {
                            window.webkit.messageHandlers.backClick.postMessage([]);
                        } else {
                            backClick();
                        }
                    } else if (/(Android)/i.test(navigator.userAgent)) {
                        //判断Android
                        JSInterface.backClick();
                    }
                    history.back();
                });
            },
        };
    })();
})(jQuery);
