(function ($) {
    var jimiConfig = function () {
        return {
            // token过期处理
            tokenTimeout: function () {
                let jimiStorage = localStorage.getItem("Jimi");
                // 如果本地有token缓存
                if (jimiStorage) {
                    let jimi = JSON.parse(jimiStorage);
                    // if ("token is expired" === jimi.token) {
                    //     // 如果超过token时效， 则退出登陆
                    //     sessionStorage.removeItem('farmer');
                    //     sessionStorage.removeItem('page');
                    //     localStorage.removeItem('Jimi');
                    //     layer.msg('登录认证过期,即将跳转登录页', {
                    //         time: 800
                    //     }, function () {
                    //         window.location.href = window.location.origin + '/farm_web/login.html';
                    //     });
                    // } else {
                    //     return;
                    // }
                    let expiresIn = jimi.expiresIn;
                    let timeUnix = moment(jimi.time).unix();
                    let nowUnix = moment().unix();
                    // 不超过token时效，就不重新请求几米token
                    if ((Number(timeUnix) + Number(expiresIn)) > Number(nowUnix)) {
                        return;
                    } else {
                        // 如果超过token时效，则退出登陆
                        sessionStorage.removeItem('farmer');
                        sessionStorage.removeItem('page');
                        localStorage.removeItem('Jimi');
                        layer.msg('登录认证过期,即将跳转登录页', {
                            time: 800
                        }, function () {
                            window.location.href = window.location.origin + '/farm_web/login.html';
                        });
                    }
                }
            },
            // token 
            tokenExpiresIn: function () {
                let jimiStorage = localStorage.getItem("Jimi");
                // 如果本地有token缓存
                if (jimiStorage) {
                    let jimi = JSON.parse(jimiStorage);
                    // if ("token is expired" === jimi.token) {
                    //     // 如果超过token时效， 则退出登陆
                    //     sessionStorage.removeItem('farmer');
                    //     sessionStorage.removeItem('page');
                    //     localStorage.removeItem('Jimi');
                    //     layer.msg('登录认证过期,即将跳转登录页', {
                    //         time: 800
                    //     }, function () {
                    //         window.location.href = window.location.origin + '/farm_web/login.html';
                    //     });
                    // }
                    let expiresIn = jimi.expiresIn;
                    let timeUnix = moment(jimi.time).unix();
                    let nowUnix = moment().unix();
                    // 不超过token时效，就继续下面请求
                    if ((Number(timeUnix) + Number(expiresIn)) > Number(nowUnix)) {} else {
                        // 如果超过token时效，则退出登陆
                        sessionStorage.removeItem('farmer');
                        sessionStorage.removeItem('page');
                        localStorage.removeItem('Jimi');
                        layer.msg('登录认证过期,即将跳转登录页', {
                            time: 800
                        }, function () {
                            window.parent.location.href = window.location.origin + '/farm_web/login.html';
                        });
                    }
                } else {
                    // 如果超过token时效，则退出登陆
                    sessionStorage.removeItem('farmer');
                    sessionStorage.removeItem('page');
                    localStorage.removeItem('Jimi');
                    layer.msg('登录认证过期,即将跳转登录页', {
                        time: 800
                    }, function () {
                        window.parent.location.href = window.location.origin + '/farm_web/login.html';
                    });
                }
            },
            getAccessToken: function () {
                let jimiStorage = localStorage.getItem("Jimi");
                let jimi = JSON.parse(jimiStorage);
                let accessToken = jimi.accessToken;
                return accessToken;
            }
        }
    }();
    window.jimiConfig = jimiConfig;
})(jQuery);