(function($) {
    var picker = function() {
        var getInputId = null;
        return {
            defaultOption: {
                inputId: null,
                cropSubId: '',
                cropName: ''
            },

            init: function(inputId) {
                getInputId = inputId;
                picker.getCrop();
                // 初始化点击事件
                picker.btn_click();
            },
            /**
             * 点击事件
             */
            btn_click: function() {
                $('.crop-picker').on('click', '.picker-btn', function() {
                    if ($(this).hasClass('active')) {
                        $(this).removeClass('active');
                    } else {
                        $(this).addClass('active');
                    }
                    $(this).next().slideToggle('fast');
                });

                $('#' + getInputId).click(function(event) {
                    event.stopPropagation();
                    $('.crop-picker').toggle('fast');
                });



                $('.crop-picker').on('click', '.sub-name', function() {
                    var name = $(this).html();
                    picker.defaultOption.cropSubId = $(this).attr("data-id");
                    picker.defaultOption.cropName = $(this).parent().attr("data-name");
                    $('#' + getInputId).val(name);
                    $('.crop-picker').toggle('fast');
                });

                $('.crop-picker').on('click', '.icon-fork', function() {
                    $('.crop-picker').hide();
                });
            },
            /**
             * 获取农作物列表
             */
            getCrop: function(className) {
                commonAjax.ajaxSubmit('../crop/getCropList', 'POST', null, function(result) {
                    if (result.resCode == '0') {
                        var data = result.resData;
                        picker.groupTypeList(data);
                    }
                });
            },
            /**
             * 组成分类列表
             */
            groupTypeList: function(arr) {
                var html = '';
                var li = '<li class="type-list">' +
                    '<div class="picker-btn item-type">{0}<i class="iconfont icon-right"></i></div>' +
                    '<ul class="crop-body">{1}</ul>' +
                    '</li>';
                for (var i = 0; i < arr.length; i++) {
                    html += li.replace('{0}', arr[i].typeName)
                        .replace('{1}', picker.groupCropList(arr[i].cropList));
                }
                $('#crop-item').html(html);


            },
            /**
             * 组成农作物列表
             */
            groupCropList: function(arr) {
                var html = '';
                if (!!arr && arr.length > 0) {
                    var li = '<li class="crop-list">' +
                        '<div class="picker-btn crop-type">{0}<i class="iconfont icon-right"></i></div>' +
                        '<ul class="sub-item" data-name="{2}">{1}</ul></li>';
                    for (var i = 0; i < arr.length; i++) {
                        html += li.replace("{0}", arr[i].cropName)
                            .replace("{1}", picker.groupSub(arr[i].subList))
                            .replace("{2}", arr[i].cropName);
                    }
                }

                return html;

            },
            /**
             * 组成子菜单列表
             */
            groupSub: function(arr) {
                var subHtml = '';
                if (arr != null) {
                    var sub = '<li class="sub-name" data-id="{1}">{0}</li>';
                    for (var k = 0; k < arr.length; k++) {
                        subHtml += sub.replace("{0}", arr[k].cropSubName)
                            .replace("{1}", arr[k].cropSubId);
                    }
                }
                return subHtml;
            }
        }
    }();
    window.picker = picker;
})(jQuery);