/*
 * 验证工具
 * @creator CJ
 * @date 2014-08-22
 */
(function($){
	var validateUtil = function() {
		return {
			
			/**
			 * 验证分页跳转页数，正整数
			 * @param 跳转页数
			 * @returns true/false
			 */
			validatePages : function(param) {
				
				if (param != "" && param!= null) {
					var reg = /^[1-9]\d*$/;
					return reg.test(param);
				} else {
					return false;
				}
			},
			
			/**
			 * 验证分页跳转页数
			 * @param go_pages	跳转页数
			 * @returns
			 */
			validateSum : function (go_pages) {
				
				return parseInt($('#total_pages').text()) >= go_pages;
			},
			validateSum2 : function (go_pages) {
				
				return parseInt($('#total_pages2').text()) >= go_pages;
			},
			
			/**
			 * 验证手机号码格式
			 * @param phone 手机号码
			 * @returns
			 */
			validatePhone : function (phone) {
				
				/*手机号码正则表达式*/
				return /^1[3|4|5|7|8][0-9]\d{8}$/.test(phone);
			}
			
			
		};
	}();
	window.validateUtil = validateUtil;
}(jQuery));