/*
 * Decompiled with CFR 0.152.
 */
package com.shuxitech.component.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolCodec
extends ByteToMessageCodec<String> {
    private static final Logger log = LoggerFactory.getLogger(ProtocolCodec.class);

    protected void encode(ChannelHandlerContext channelHandlerContext, String s, ByteBuf byteBuf) throws Exception {
        byte[] data = s.getBytes(StandardCharsets.UTF_8);
        byteBuf.writeBytes(data);
        log.error("encode:" + s);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() < 1) {
            return;
        }
        byte[] data = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(data);
        String decodedString = new String(data, StandardCharsets.UTF_8);
        list.add(decodedString);
        log.error("decode:" + decodedString);
    }
}

