/*
 * Decompiled with CFR 0.152.
 */
package com.shuxitech.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.shuxitech.service.WeatherStationService;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/weather"})
public class WeatherStationController {
    @Autowired
    private WeatherStationService stationService;

    @GetMapping(value={"/data"})
    public Object queryStationData(@RequestParam(value="imei", required=false, defaultValue="T0001") String stationNum) {
        LocalDateTime localDateTime = LocalDateTime.now();
        JSONObject json = this.stationService.queryStationData(stationNum, localDateTime);
        return json;
    }

    @GetMapping(value={"/dataList"})
    public Object queryStationDataList(@RequestParam(value="imei") String imei, @RequestParam(value="beginTime") Long beginTime, @RequestParam(value="endTime") Long endTime) {
        JSONArray arr = this.stationService.queryStationDataList(imei, beginTime, endTime);
        JSONObject json = new JSONObject();
        json.put("list", (Object)arr);
        return json;
    }
}

