/*
 * Decompiled with CFR 0.152.
 */
package com.shuxitech.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.shuxitech.component.codec.Protocol;
import com.shuxitech.dto.WeatherStationRecord;
import com.shuxitech.dto.resultMap.LabelResultMap;
import com.shuxitech.mapper.WeatherStationRecordMapper;
import com.shuxitech.service.WeatherStationService;
import com.shuxitech.utils.BaseSystemUtil;
import com.shuxitech.utils.GeneralUtils;
import com.shuxitech.utils.MathUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeatherStationServiceImpl
implements WeatherStationService {
    private static final Logger log = LoggerFactory.getLogger(WeatherStationServiceImpl.class);
    @Autowired
    private WeatherStationRecordMapper weatherStationRecordMapper;

    public byte[] saveWeatherStationData(Protocol msg) {
        byte[] dataByte = msg.getData();
        String data = GeneralUtils.toStr((byte[])dataByte);
        try {
            String seriNoStr = data.substring(1, 5);
            String stationNo = data.substring(5, 10);
            String dateTimeStr = data.substring(10, 22);
            String rainMinuteStr = data.substring(22, 82);
            String scheduleTempStr = data.substring(82, 86);
            String maxTempStr = data.substring(86, 90);
            String maxTempTimeStr = data.substring(90, 92);
            String minTempStr = data.substring(92, 96);
            String minTempTimeStr = data.substring(96, 98);
            String hourVStr = data.substring(98, 101);
            String wS3SStr = data.substring(101, 104);
            String wD3SStr = data.substring(104, 107);
            String wS2MStr = data.substring(107, 110);
            String wD2MStr = data.substring(110, 113);
            String wS10MStr = data.substring(113, 116);
            String wD10MStr = data.substring(116, 119);
            String maxWS3SStr = data.substring(119, 122);
            String maxWD3SStr = data.substring(122, 125);
            String maxWS3STimeStr = data.substring(125, 127);
            String maxWS2MStr = data.substring(127, 130);
            String maxWD2MStr = data.substring(130, 133);
            String maxWD2MTimeStr = data.substring(133, 135);
            String maxWS10MStr = data.substring(135, 138);
            String maxWD10MStr = data.substring(138, 141);
            String maxWS10MTimeStr = data.substring(141, 143);
            String dataBStr = data.substring(143, 144);
            String schedulePressureStr = data.substring(144, 148);
            String maxPressureStr = data.substring(148, 152);
            String maxPressureTimeStr = data.substring(152, 154);
            String minPressureStr = data.substring(154, 158);
            String minPressureTimeStr = data.substring(158, 160);
            String scheduleHumiStr = data.substring(160, 163);
            String minScheduleStr = data.substring(163, 166);
            String minScheduleTimeStr = data.substring(166, 168);
            String dewTempStr = data.substring(168, 172);
            String waterPressureStr = data.substring(172, 176);
            LocalDateTime recordTime = LocalDateTime.parse(dateTimeStr, DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
            WeatherStationRecord record = new WeatherStationRecord(seriNoStr, stationNo, recordTime.toString(), rainMinuteStr, scheduleTempStr, maxTempStr, Integer.valueOf(Integer.parseInt(maxTempTimeStr)), minTempStr, Integer.valueOf(Integer.parseInt(minTempTimeStr)), hourVStr, wS3SStr, wD3SStr, wS2MStr, wD2MStr, wS10MStr, wD10MStr, maxWS3SStr, maxWD3SStr, maxWS3STimeStr, maxWS2MStr, maxWD2MStr, Integer.valueOf(Integer.parseInt(maxWD2MTimeStr)), maxWS10MStr, maxWD10MStr, Integer.valueOf(Integer.parseInt(maxWS10MTimeStr)), dataBStr, schedulePressureStr, maxPressureStr, Integer.valueOf(Integer.parseInt(maxPressureTimeStr)), minPressureStr, Integer.valueOf(Integer.parseInt(minPressureTimeStr)), scheduleHumiStr, minScheduleStr, Integer.valueOf(Integer.parseInt(minScheduleTimeStr)), dewTempStr, waterPressureStr);
            this.weatherStationRecordMapper.insert(record);
            this.saveWeatherStationRain(stationNo, recordTime, rainMinuteStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4fdd\u5b58\u7684\u6c14\u8c61\u6570\u636e\u62a5\u9519\u4e86\uff1a {}", (Object)data);
        }
        byte[] seriNoByte = Arrays.copyOfRange(dataByte, 1, 5);
        return seriNoByte;
    }

    void saveWeatherStationRain(String stationNo, LocalDateTime recordTime, String rainHour) {
        ArrayList<LabelResultMap> list = new ArrayList<LabelResultMap>();
        String[] rainHourArray = rainHour.split("");
        for (int i = 0; i < rainHourArray.length; ++i) {
            Integer rainMinute = BaseSystemUtil.tranNumer((String)rainHourArray[i]);
            recordTime = recordTime.withMinute(i);
            LabelResultMap label = new LabelResultMap(stationNo, recordTime.toString(), rainMinute);
            list.add(label);
        }
        this.weatherStationRecordMapper.insertOrUpdateRainBatch(list);
    }

    public JSONObject queryStationData(String stationNum, LocalDateTime endTime) {
        JSONObject json = new JSONObject();
        WeatherStationRecord record = this.weatherStationRecordMapper.queryRecentData(stationNum);
        if (record == null) {
            return json;
        }
        String scheduleTemp = MathUtils.calTemp((String)record.getScheduleTemp());
        json.put("scheduleTemp", (Object)scheduleTemp);
        StringBuffer scheHumiD = new StringBuffer(record.getScheduleHumi());
        String scheduleHumiL = scheHumiD.insert(1, ".").toString();
        json.put("scheduleHumi", (Object)scheduleHumiL);
        String localDate = LocalDate.now().toString();
        WeatherStationRecord maxRecord = this.weatherStationRecordMapper.queryTodayMaxTemp(stationNum, localDate);
        String maxTemp = "";
        String maxTempTime = "";
        try {
            maxTemp = MathUtils.calTemp((String)maxRecord.getMaxTemp());
            maxTempTime = MathUtils.calTime((String)maxRecord.getRecordTime(), (Integer)maxRecord.getMaxTempTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        json.put("maxTemp", (Object)maxTemp);
        json.put("maxTempTime", (Object)maxTempTime);
        WeatherStationRecord minRecord = this.weatherStationRecordMapper.queryTodayMinTemp(stationNum, localDate);
        String minTemp = "";
        String minTempTime = "";
        try {
            minTemp = MathUtils.calTemp((String)minRecord.getMinTemp());
            minTempTime = MathUtils.calTime((String)minRecord.getRecordTime(), (Integer)minRecord.getMinTempTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        json.put("minTemp", (Object)minTemp);
        json.put("minTempTime", (Object)minTempTime);
        BigDecimal ws2mB = new BigDecimal(scheduleTemp.substring(1));
        Double ws2m = ws2mB.divide(new BigDecimal(10)).doubleValue();
        json.put("ws2m", (Object)ws2m);
        json.put("wd2m", (Object)record.getWd2m());
        String dewTemp = MathUtils.calTemp((String)record.getDewTemp());
        json.put("dewTemp", (Object)dewTemp);
        json.put("recordTime", (Object)record.getRecordTime());
        LocalDateTime startTime = endTime.withMinute(0).withSecond(0).withNano(0);
        Integer rain3h = 0;
        Integer rain6h = 0;
        Integer rain12h = 0;
        Integer rain24h = 0;
        Integer rain1h = this.weatherStationRecordMapper.queryRainSumByHourPeriod(stationNum, startTime.toString(), endTime.toString());
        rain3h = this.weatherStationRecordMapper.queryRainSumByHourPeriod(stationNum, startTime.minusHours(2L).toString(), endTime.toString());
        rain6h = this.weatherStationRecordMapper.queryRainSumByHourPeriod(stationNum, startTime.minusHours(5L).toString(), endTime.toString());
        rain12h = this.weatherStationRecordMapper.queryRainSumByHourPeriod(stationNum, startTime.minusHours(11L).toString(), endTime.toString());
        rain24h = this.weatherStationRecordMapper.queryRainSumByHourPeriod(stationNum, startTime.minusHours(23L).toString(), endTime.toString());
        json.put("rain1h", (Object)MathUtils.calRain((Integer)rain1h));
        json.put("rain3h", (Object)MathUtils.calRain((Integer)rain3h));
        json.put("rain6h", (Object)MathUtils.calRain((Integer)rain6h));
        json.put("rain12h", (Object)MathUtils.calRain((Integer)rain12h));
        json.put("rain24h", (Object)MathUtils.calRain((Integer)rain24h));
        return json;
    }

    public static void main(String[] args) {
        LocalDateTime recordTime = LocalDateTime.parse("202104011403", DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
        System.out.println("date:" + recordTime);
        BigDecimal bigDecimal = new BigDecimal("4000");
        Double max = bigDecimal.divide(new BigDecimal(10)).doubleValue();
        System.out.println(max);
    }

    public JSONArray queryStationDataList(String stationNum, Long beginTime, Long endTime) {
        String end;
        JSONArray arr = new JSONArray();
        String begin = new Date(beginTime * 1000L).toInstant().atOffset(ZoneOffset.of("+8")).toLocalDate().toString() + " 00:00:00";
        List list = this.weatherStationRecordMapper.queryStationDataList(stationNum, begin, end = new Date(endTime * 1000L).toInstant().atOffset(ZoneOffset.of("+8")).toLocalDate().toString() + " 23:59:59");
        if (list == null || list.size() == 0) {
            return arr;
        }
        for (WeatherStationRecord record : list) {
            JSONObject json = new JSONObject();
            String scheduleTemp = MathUtils.calTemp((String)record.getScheduleTemp());
            json.put("scheduleTemp", (Object)scheduleTemp);
            StringBuffer scheHumiD = new StringBuffer(record.getScheduleHumi());
            String scheduleHumiL = scheHumiD.insert(1, ".").toString();
            json.put("scheduleHumi", (Object)scheduleHumiL);
            String localDate = record.getCreateTime().substring(0, 10);
            WeatherStationRecord maxRecord = this.weatherStationRecordMapper.queryTodayMaxTemp(stationNum, localDate);
            String maxTemp = "";
            String maxTempTime = "";
            try {
                maxTemp = MathUtils.calTemp((String)maxRecord.getMaxTemp());
                maxTempTime = MathUtils.calTime((String)maxRecord.getRecordTime(), (Integer)maxRecord.getMaxTempTime());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            json.put("maxTemp", (Object)maxTemp);
            json.put("maxTempTime", (Object)maxTempTime);
            WeatherStationRecord minRecord = this.weatherStationRecordMapper.queryTodayMinTemp(stationNum, localDate);
            String minTemp = "";
            String minTempTime = "";
            try {
                minTemp = MathUtils.calTemp((String)minRecord.getMinTemp());
                minTempTime = MathUtils.calTime((String)minRecord.getRecordTime(), (Integer)minRecord.getMinTempTime());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            json.put("minTemp", (Object)minTemp);
            json.put("minTempTime", (Object)minTempTime);
            BigDecimal ws2mB = new BigDecimal(scheduleTemp.substring(1));
            Double ws2m = ws2mB.divide(new BigDecimal(10)).doubleValue();
            json.put("ws2m", (Object)ws2m);
            json.put("wd2m", (Object)record.getWd2m());
            String dewTemp = MathUtils.calTemp((String)record.getDewTemp());
            json.put("dewTemp", (Object)dewTemp);
            json.put("recordTime", (Object)record.getCreateTime());
            Integer rain1h = this.weatherStationRecordMapper.queryRainSumByHourPeriod(stationNum, record.getCreateTime() + ":00:00", record.getCreateTime() + ":59:59");
            json.put("rain1h", (Object)MathUtils.calRain((Integer)rain1h));
            arr.add((Object)json);
        }
        return arr;
    }
}

