/*
 * Decompiled with CFR 0.152.
 */
package com.shuxitech;

import com.shuxitech.component.NettyServer;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication
@MapperScan(value={"com.shuxitech.mapper"})
public class WeatherStationApplication
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    @Value(value="${netty.port}")
    private Integer port;
    @Value(value="${netty.url}")
    private String url;
    @Autowired
    private NettyServer socketServer;

    public static void main(String[] args) {
        SpringApplication.run(WeatherStationApplication.class, (String[])args);
    }

    public void run(String ... args) throws Exception {
        log.error("\u7ed1\u5b9aip\uff1a" + this.url);
        log.error("\u7ed1\u5b9aport\uff1a" + this.port);
        InetSocketAddress address = new InetSocketAddress(this.url, (int)this.port);
        ChannelFuture future = this.socketServer.run(address);
        Runtime.getRuntime().addShutdownHook((Thread)new /* Unavailable Anonymous Inner Class!! */);
        future.channel().closeFuture().syncUninterruptibly();
    }

    static /* synthetic */ NettyServer access$000(WeatherStationApplication x0) {
        return x0.socketServer;
    }
}

