/*
 * Decompiled with CFR 0.152.
 */
package com.shuxitech.component;

import com.shuxitech.service.WeatherStationService;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NettyServer {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private Channel channel;
    @Autowired
    private WeatherStationService wsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture run(InetSocketAddress address) {
        ChannelFuture f = null;
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new /* Unavailable Anonymous Inner Class!! */).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            f = b.bind((SocketAddress)address).syncUninterruptibly();
            this.channel = f.channel();
        }
        catch (Exception e) {
            log.error("Netty start error:", (Throwable)e);
        }
        finally {
            if (f != null && f.isSuccess()) {
                log.info("Netty server listening " + address.getHostName() + " on port " + address.getPort() + " and ready for connections...");
            } else {
                log.error("Netty server start up Error!");
            }
        }
        return f;
    }

    public void destroy() {
        log.info("Shutdown Netty Server...");
        if (this.channel != null) {
            this.channel.close();
        }
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
        log.info("Shutdown Netty Server Success!");
    }

    static /* synthetic */ WeatherStationService access$000(NettyServer x0) {
        return x0.wsService;
    }
}

