/*
 * Decompiled with CFR 0.152.
 */
package com.shuxitech.component.codec;

import com.shuxitech.component.codec.Pack;
import com.shuxitech.component.codec.PackTypeAdapter;
import com.shuxitech.component.codec.Protocol;
import com.shuxitech.utils.GeneralUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolCodec
extends ByteToMessageCodec<Protocol> {
    private static final Logger log = LoggerFactory.getLogger(ProtocolCodec.class);
    private PackTypeAdapter frameV1 = new PackTypeAdapter(Short.MAX_VALUE, 2, 1, 2, 0, true);

    protected void encode(ChannelHandlerContext ctx, Protocol pro, ByteBuf out) throws Exception {
        log.error("\u5f00\u542f\u56de\u5e94\u6570\u636e\uff1a" + out.array());
        if (null != pro) {
            int lengthFieldLength = 0;
            if (Arrays.equals(Pack.HEADER_V1, pro.getHeader())) {
                lengthFieldLength = 1;
            } else {
                pro.setHeader(Pack.HEADER_V1);
                lengthFieldLength = 1;
            }
            byte[] data = pro.getData();
            int dataLength = 0;
            if (null != data && data.length > 0) {
                dataLength = data.length;
            }
            ByteBuf crcData = Unpooled.buffer((int)(dataLength + lengthFieldLength + 3));
            if (1 == lengthFieldLength) {
                crcData.writeByte(dataLength + 2 + 3);
            } else if (2 == lengthFieldLength) {
                crcData.writeShort(dataLength + 2 + 3);
            }
            if (1 == lengthFieldLength) {
                out.writeBytes(Pack.HEADER_V1);
            }
            out.writeBytes(crcData);
            out.writeBytes(Pack.END);
            crcData.release();
            if (log.isInfoEnabled()) {
                // empty if block
            }
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ReferenceCountUtil.retain((Object)in);
        if (in.readableBytes() > 256 || in.readableBytes() < 3) {
            return;
        }
        byte[] header = new byte[1];
        int readerIndex = in.readerIndex();
        in.getBytes(readerIndex, header);
        if ("F,H,I".indexOf(new String(header)) > -1) {
            Protocol protocol = this.decodeProtocol(in, header);
            in.clear();
            if (null != protocol) {
                out.add(protocol);
            }
        } else {
            int packLength = in.readableBytes();
            byte[] printData = in.readBytes(packLength).array();
            log.error("\u6536\u5230\u9519\u8bef\u5305\uff0c\u5173\u95ed\u8fde\u63a5\uff1a" + GeneralUtils.toStr((byte[])printData));
        }
    }

    private Protocol decodeProtocol(ByteBuf in, byte[] header) {
        int packLength = in.readableBytes();
        byte[] end = new byte[2];
        in.getBytes(in.readableBytes() - 2, end);
        if (!Arrays.equals(end, Pack.END)) {
            log.error("\u9519\u8bef\u7684\u7ed3\u675f\u7b26:" + GeneralUtils.getHexString((byte[])end));
            return null;
        }
        System.out.println("\u83b7\u53d6\u7684\u957f\u5ea6\uff1a" + packLength);
        Protocol pro = new Protocol();
        pro.setHeader(header);
        pro.setData(in.readBytes(packLength - 2).array());
        ReferenceCountUtil.safeRelease((Object)in);
        return pro;
    }

    public static void main(String[] args) {
        String hex = "78,78,11,01,08,68,12,01,37,19,46,65,70,01,32,02,00,23,d8,24,0d,0a,";
        System.out.println(hex.substring(13, 36).replaceAll(",", ""));
    }
}

