/*
 * Decompiled with CFR 0.152.
 */
package com.shuxitech.component.handler;

import com.shuxitech.component.codec.Pack;
import com.shuxitech.component.codec.Protocol;
import com.shuxitech.component.reply.ChannelMap;
import com.shuxitech.service.WeatherStationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolHandler
extends SimpleChannelInboundHandler<Protocol> {
    private static Logger loger = LoggerFactory.getLogger(ProtocolHandler.class);
    private WeatherStationService wsService;

    public ProtocolHandler(WeatherStationService wsService) {
        this.wsService = wsService;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Protocol msg) throws Exception {
        byte[] header = msg.getHeader();
        String data = new String(msg.getData());
        if (Arrays.equals(header, Pack.HEADER_LOGIN)) {
            loger.info("\u8fd9\u662f\u767b\u5f55\u5305\uff0c\u9700\u8981\u56de\u590d\uff01");
            Channel originChannel = ctx.channel();
            ChannelMap.addChannel((String)ctx.name(), (Channel)originChannel);
            Channel channel = ChannelMap.getChannelByName((String)ctx.name());
            channel.writeAndFlush((Object)("I" + data + new String(Pack.END)));
        } else if (Arrays.equals(header, Pack.HEADER_HEART)) {
            loger.info("\u8fd9\u662f\u5fc3\u8df3\u5305\uff0c\u9700\u8981\u56de\u590d\uff01");
            Channel originChannel = ctx.channel();
            ChannelMap.addChannel((String)ctx.name(), (Channel)originChannel);
            Channel channel = ChannelMap.getChannelByName((String)ctx.name());
            channel.writeAndFlush((Object)("GH" + new String(Pack.END)));
        } else if (Arrays.equals(header, Pack.HEADER_V1)) {
            byte[] seriNo = this.wsService.saveWeatherStationData(msg);
            loger.info("\u8fd9\u662f\u6570\u636e\u5305\uff0c\u9700\u8981\u56de\u590d\uff01");
            Channel originChannel = ctx.channel();
            ChannelMap.addChannel((String)ctx.name(), (Channel)originChannel);
            Channel channel = ChannelMap.getChannelByName((String)ctx.name());
            ByteBuf crcData = Unpooled.buffer((int)8);
            crcData.writeBytes("GF".getBytes());
            crcData.writeBytes(seriNo);
            crcData.writeBytes(Pack.END);
            channel.writeAndFlush((Object)crcData);
        }
    }
}

