/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.common.component;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import com.shuxi.common.component.AsyncBlockWaiter;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AsyncBlockWaiter {
    private static final Logger log = LoggerFactory.getLogger(AsyncBlockWaiter.class);
    private final ConcurrentHashMap<String, Pair<ReturnHolder, Long>> holderMap = new ConcurrentHashMap();
    private long clearTime;
    @Value(value="${block_waiter.wait_time_max:100000}")
    private long timeoutMax;
    @Value(value="${block_waiter.holder_capacity:1000}")
    private int holderCapacity;
    @Value(value="${block_waiter.holder_expire_seconds:60}")
    private long holderExpireSeconds;
    @Value(value="${block_waiter.holder_expire_seconds_minimum:10}")
    private long holderExpireSecondsMinimum;

    public <T> T waitReturn(String sessionId, Long timeout) throws DataNotRecvException {
        ReturnHolder returnHolder = (ReturnHolder)this.holderMap.computeIfAbsent(sessionId, sid -> new Pair((Object)new ReturnHolder(this, sid, null), (Object)System.currentTimeMillis())).getKey();
        Object data = ReturnHolder.access$000((ReturnHolder)returnHolder, (Long)timeout);
        return (T)data;
    }

    public void notice(String sessionId, Object value) {
        ReturnHolder returnHolder = this.getReturnHolder(sessionId);
        ReturnHolder.access$100((ReturnHolder)returnHolder, (Object)value);
    }

    private ReturnHolder getReturnHolder(String sessionId) {
        Assert.notNull((Object)sessionId);
        this.syncClear(this.holderCapacity, this.holderExpireSeconds, this.holderExpireSecondsMinimum);
        Assert.isTrue((this.holderMap.size() < this.holderCapacity ? 1 : 0) != 0);
        log.info("----------------------------------------------- ReturnHolder cache num:{}", (Object)this.holderMap.size());
        return (ReturnHolder)this.holderMap.computeIfAbsent(sessionId, sid -> new Pair((Object)new ReturnHolder(this, sid, null), (Object)System.currentTimeMillis())).getKey();
    }

    private synchronized void syncClear(int capacity, long expireSeconds, long expireSecondsMinimum) {
        if (System.currentTimeMillis() > this.clearTime + expireSeconds * 1000L || this.holderMap.size() > capacity) {
            log.info("----------------------------------------------- \u6e05\u9664\u8fc7\u671fholder, capacity={}, expireSeconds={}", (Object)capacity, (Object)expireSeconds);
            this.clearTime = System.currentTimeMillis();
            this.holderMap.entrySet().removeIf(entry -> (Long)((Pair)entry.getValue()).getValue() + expireSeconds * 1000L < this.clearTime);
            if ((double)this.holderMap.size() > (double)capacity * 0.6 && expireSeconds > expireSecondsMinimum) {
                log.info("----------------------------------------------- ReturnHolder\u6e05\u9664\u6570\u91cf\u4e0d\u8db3,\u9700\u8981\u518d\u6b21\u6e05\u9664");
                this.syncClear(capacity, Math.round((double)expireSeconds * 0.7), expireSecondsMinimum);
            }
        }
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }

    static /* synthetic */ long access$300(AsyncBlockWaiter x0) {
        return x0.timeoutMax;
    }

    static /* synthetic */ ConcurrentHashMap access$400(AsyncBlockWaiter x0) {
        return x0.holderMap;
    }
}

