/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.config;

import com.shuxi.handler.MqttHandler;
import com.shuxi.handler.MqttTopicMsgHandler;
import com.shuxi.util.HexStringUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.integration.mqtt.inbound.MqttPahoMessageDrivenChannelAdapter;
import org.springframework.integration.mqtt.outbound.MqttPahoMessageHandler;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

@Configuration
@IntegrationComponentScan
@ConditionalOnProperty(prefix="spring.mqtt", name={"enable"}, havingValue="true")
@RefreshScope
public class MqttConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MqttConfig.class);
    @Value(value="${spring.mqtt.userName}")
    private String userName;
    @Value(value="${spring.mqtt.passWord}")
    private String passWord;
    @Value(value="${spring.mqtt.hostUrl}")
    private String hostUrl;
    @Value(value="${spring.mqtt.clientId}")
    private String clientId;
    @Value(value="${spring.mqtt.topic}")
    private String topic;
    private final Map<String, MqttTopicMsgHandler> mqttHandlers = new ConcurrentHashMap();
    private ApplicationContext applicationContext;

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        log.info("username:{} password:{} hostUrl:{} clientId :{} topic:{}", new Object[]{this.userName, this.passWord, this.hostUrl, this.clientId, this.getHandler().keySet()});
    }

    @Bean
    public <hostUrl> MqttConnectOptions getMqttConnectOptions() {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(false);
        options.setUserName(this.userName);
        options.setPassword(this.passWord.toCharArray());
        options.setServerURIs(new String[]{this.hostUrl});
        options.setConnectionTimeout(10);
        options.setKeepAliveInterval(20);
        return options;
    }

    @Bean
    public MqttPahoClientFactory mqttClientFactory() {
        DefaultMqttPahoClientFactory factory = new DefaultMqttPahoClientFactory();
        factory.setConnectionOptions(this.getMqttConnectOptions());
        return factory;
    }

    @Bean(name={"mqttOutboundChannel"})
    public MessageChannel mqttOutboundChannel() {
        return new DirectChannel();
    }

    @Bean
    @ServiceActivator(inputChannel="mqttOutboundChannel")
    public MessageHandler mqttOutbound() {
        MqttPahoMessageHandler messageHandler = new MqttPahoMessageHandler(this.clientId + "_publish", this.mqttClientFactory());
        messageHandler.setAsync(true);
        messageHandler.setDefaultQos(2);
        messageHandler.setDefaultTopic(this.topic);
        messageHandler.setDefaultRetained(false);
        return messageHandler;
    }

    @Bean(name={"mqttInboundChannel"})
    public MessageChannel mqttInboundChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageProducer inbound() {
        String[] topics = this.getHandler().keySet().toArray(new String[0]);
        MqttPahoMessageDrivenChannelAdapter adapter = new MqttPahoMessageDrivenChannelAdapter(this.clientId + "_subscribe", this.mqttClientFactory(), topics);
        adapter.setCompletionTimeout(5000L);
        DefaultPahoMessageConverter converter = new DefaultPahoMessageConverter();
        converter.setPayloadAsBytes(true);
        adapter.setConverter((MqttMessageConverter)converter);
        adapter.setQos(new int[]{2});
        adapter.setOutputChannel(this.mqttInboundChannel());
        return adapter;
    }

    @Bean
    @ServiceActivator(inputChannel="mqttInboundChannel")
    public MessageHandler handler() {
        return message -> {
            try {
                String recvTopic = String.valueOf(message.getHeaders().get((Object)"mqtt_receivedTopic"));
                String qos = String.valueOf(message.getHeaders().get((Object)"mqtt_receivedQos"));
                byte[] bytes = (byte[])message.getPayload();
                String payload = HexStringUtil.bytes2HexString((byte[])bytes);
                log.info("\u63a5\u6536\u5b57\u8282\uff1a{}", (Object)bytes);
                log.info("\u4e3b\u9898\uff1a" + recvTopic);
                log.info("\u6d88\u606f\u5185\u5bb9\uff1a" + payload);
                log.info("\u7ea7\u522b\uff1a" + qos);
                MqttTopicMsgHandler handler = (MqttTopicMsgHandler)this.getHandler().get(recvTopic);
                if (handler != null) {
                    handler.handle(recvTopic, payload);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        };
    }

    private Map<String, MqttTopicMsgHandler> getHandler() {
        if (this.mqttHandlers.isEmpty()) {
            Map beanMap = this.applicationContext.getBeansOfType(MqttTopicMsgHandler.class);
            Map<String, MqttTopicMsgHandler> handlerMap = beanMap.values().stream().collect(Collectors.toMap(handler -> {
                try {
                    Method handle = handler.getClass().getDeclaredMethod("handle", String.class, String.class);
                    MqttHandler mqttHandler = handle.getAnnotation(MqttHandler.class);
                    return Optional.ofNullable(mqttHandler).map(MqttHandler::topic).orElse(null);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }, handler -> handler));
            this.mqttHandlers.putAll(handlerMap);
        }
        return this.mqttHandlers;
    }
}

