/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.controller;

import com.shuxi.base.vo.ActionResult;
import com.shuxi.base.vo.PageListVO;
import com.shuxi.bean.vo.ChartVo;
import com.shuxi.bean.vo.DeviceVo;
import com.shuxi.bean.vo.DiseaseInsectWarningVo;
import com.shuxi.bean.vo.InternetOfEverythingChartVo;
import com.shuxi.bean.vo.InternetOfEverythingCropMonitoringVo;
import com.shuxi.bean.vo.InternetOfEverythingMapFacilityVo;
import com.shuxi.bean.vo.InternetOfEverythingMapVo;
import com.shuxi.bean.vo.IrrigationModelDataVo;
import com.shuxi.bean.vo.PestCountVo;
import com.shuxi.bean.vo.PestDetectionImgVo;
import com.shuxi.bean.vo.SoilDetailChartVo;
import com.shuxi.bean.vo.WeatherStationDataVo;
import com.shuxi.service.InternetOfEverythingDpService;
import com.shuxi.service.PestCountService;
import java.util.List;
import java.util.Map;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/dp/internetOfEverything"})
public class InternetOfEverythingDpController {
    private final InternetOfEverythingDpService internetOfEverythingDpService;
    private final PestCountService pestCountService;

    @GetMapping(value={"/farmRecord"})
    public ActionResult<List<Map<String, Object>>> farmRecord(@RequestParam(value="companyId") Integer companyId) {
        List list = this.internetOfEverythingDpService.farmRecord(companyId);
        return ActionResult.success((Object)list);
    }

    @GetMapping(value={"/querySoilDetail"})
    public ActionResult<SoilDetailChartVo> querySoilDetail(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime, @RequestParam(value="dateType") Integer dateType, @RequestParam(value="deviceId") String deviceId, @RequestParam(value="companyId") Integer companyId) {
        SoilDetailChartVo vo = this.internetOfEverythingDpService.querySoilDetail(startTime, endTime, dateType, deviceId, companyId);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/queryRainfall"})
    public ActionResult<InternetOfEverythingChartVo> queryRainfall(@RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryRainfall(companyId));
    }

    @GetMapping(value={"/queryAtmosphere"})
    public ActionResult<InternetOfEverythingChartVo> queryAtmosphere(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime, @RequestParam(value="dateType") Integer dateType, @RequestParam(value="humitureType") Integer humitureType, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryAtmosphere(startTime, endTime, dateType, humitureType, companyId));
    }

    @GetMapping(value={"/queryCropEvapotranspiration"})
    public ActionResult<InternetOfEverythingChartVo> queryCropEvapotranspiration(@RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryCropEvapotranspiration(companyId));
    }

    @GetMapping(value={"/queryCropDemand"})
    public ActionResult<InternetOfEverythingChartVo> queryCropDemand(@RequestParam(value="demandType") Integer demandType, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryCropDemand(demandType, companyId));
    }

    @GetMapping(value={"/queryWeatherStationInformation"})
    public ActionResult<WeatherStationDataVo> queryWeatherStationInformation(@RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryWeatherStationInformation(companyId));
    }

    @GetMapping(value={"/queryIrrigationModel"})
    public ActionResult<IrrigationModelDataVo> queryIrrigationModel(@RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryIrrigationModel(companyId));
    }

    @GetMapping(value={"/queryInternetOfEverythingMap"})
    public ActionResult<List<InternetOfEverythingMapVo>> queryInternetOfEverythingMap(@RequestParam(value="tabType") Integer tabType, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryInternetOfEverythingMap(tabType, companyId));
    }

    @GetMapping(value={"/queryDeviceMessage"})
    public ActionResult<InternetOfEverythingMapFacilityVo> queryDeviceMessage(@RequestParam(value="deviceNameId") String deviceNameId, @RequestParam(value="deviceType") Integer deviceType, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryDeviceMessage(deviceNameId, deviceType, companyId));
    }

    @GetMapping(value={"/queryDeviceVoList"})
    public ActionResult<PageListVO<DeviceVo>> queryDeviceVoList(@RequestParam(value="currentPage") Integer currentPage, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="companyId") Integer companyId) {
        PageListVO listVO = this.internetOfEverythingDpService.queryDeviceVoList(currentPage, pageSize, companyId);
        return ActionResult.success((Object)listVO);
    }

    @GetMapping(value={"/queryPestCount"})
    public ActionResult<PestCountVo> queryPestCount(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime, @RequestParam(value="companyId", defaultValue="6597") Integer companyId) {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryPestCount(startTime, endTime, companyId));
    }

    @GetMapping(value={"/refreshPestCount"})
    public ActionResult refreshPestCount(@RequestParam(value="deviceId") String deviceId, @RequestParam(value="start") String start, @RequestParam(value="end") String end) {
        this.pestCountService.refreshPestCount(deviceId, start, end);
        return ActionResult.success();
    }

    @GetMapping(value={"/trendAnalysis"})
    public ActionResult<ChartVo> trendAnalysis(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime, @RequestParam(value="companyId") Integer companyId) {
        ChartVo chartVo = this.internetOfEverythingDpService.trendAnalysis(startTime, endTime, companyId);
        return ActionResult.success((Object)chartVo);
    }

    @GetMapping(value={"/pestChart"})
    public ActionResult<ChartVo> pestChart(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime, @RequestParam(value="companyId") Integer companyId, @RequestParam(value="deviceId") String deviceId) {
        ChartVo chartVo = this.internetOfEverythingDpService.pestChart(startTime, endTime, companyId, deviceId);
        return ActionResult.success((Object)chartVo);
    }

    @GetMapping(value={"/queryDiseaseInsectWarning"})
    public ActionResult<List<DiseaseInsectWarningVo>> queryDiseaseInsectWarning() {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryDiseaseInsectWarning());
    }

    @GetMapping(value={"/queryPestDetectionImgInfo"})
    public ActionResult<List<PestDetectionImgVo>> queryPestDetectionImgInfo() {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryPestDetectionImgInfo());
    }

    @GetMapping(value={"/queryCropMonitoring"})
    public ActionResult<List<InternetOfEverythingCropMonitoringVo>> queryCropMonitoring(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime, @RequestParam(value="deviceNameId", required=false, defaultValue="") String deviceNameId) {
        return ActionResult.success((Object)this.internetOfEverythingDpService.queryCropMonitoring(startTime, endTime, deviceNameId));
    }

    public InternetOfEverythingDpController(InternetOfEverythingDpService internetOfEverythingDpService, PestCountService pestCountService) {
        this.internetOfEverythingDpService = internetOfEverythingDpService;
        this.pestCountService = pestCountService;
    }
}

