/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.controller;

import com.alibaba.fastjson.JSONObject;
import com.shuxi.base.vo.ActionResult;
import com.shuxi.base.vo.MsgCode;
import com.shuxi.base.vo.PageListVO;
import com.shuxi.base.vo.PaginationVO;
import com.shuxi.bean.ca.IrrigationCase;
import com.shuxi.bean.vo.EquipmentVo;
import com.shuxi.bean.vo.FieldVo;
import com.shuxi.bean.vo.ImageDataVo;
import com.shuxi.bean.vo.IrrigateFormulaVo;
import com.shuxi.bean.vo.IrrigationSystemDataVo;
import com.shuxi.bean.vo.IrrigationVo;
import com.shuxi.bean.vo.IrrigationWarnVo;
import com.shuxi.bean.vo.PondVO;
import com.shuxi.bean.vo.UnitVo;
import com.shuxi.bean.vo.WaterValveVO;
import com.shuxi.service.IrrigationService;
import com.shuxi.util.JsonUtil;
import com.shuxi.util.StringUtil;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/dp/irrigation"})
public class IrrigationDpController {
    private final IrrigationService irrigationService;

    @GetMapping(value={"/planList"})
    public ActionResult<PageListVO<IrrigationVo>> planList(IrrigationCase irrigationCase) {
        List pointInfoList = this.irrigationService.planList(irrigationCase);
        PaginationVO baseResourceCaseVo = (PaginationVO)JsonUtil.getJsonToBean((Object)irrigationCase, PaginationVO.class);
        baseResourceCaseVo.setTotal(Integer.valueOf(Long.valueOf(irrigationCase.getTotal()).intValue()));
        return ActionResult.page((List)pointInfoList, (PaginationVO)baseResourceCaseVo);
    }

    @GetMapping(value={"/irrigateFormulaList"})
    public ActionResult<List<IrrigateFormulaVo>> irrigateFormulaList(@RequestParam(value="periodName", required=false, defaultValue="") String periodName, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.irrigationService.irrigateFormulaList(periodName, companyId));
    }

    @GetMapping(value={"/unitVoListByPlanId"})
    public ActionResult<List<UnitVo>> unitVoListByPlanId(@RequestParam(value="planId") String planId, @RequestParam(value="id") String id, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.irrigationService.unitVoListByPlanId(planId, id, companyId));
    }

    @GetMapping(value={"/fieldAndWaterValveList"})
    public ActionResult<List<UnitVo>> fieldAndWaterValveList(@RequestParam(value="id") String id, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.irrigationService.fieldAndWaterValveList(id, companyId));
    }

    @GetMapping(value={"/unitVoStatByPlanId"})
    public ActionResult<IrrigationSystemDataVo> unitVoStatByPlanId(@RequestParam(value="planId") String planId, @RequestParam(value="id") String id, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.irrigationService.unitVoStatByPlanId(planId, id, companyId));
    }

    @GetMapping(value={"/underwayPlanId"})
    public ActionResult<List<EquipmentVo>> underwayPlanId(@RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.irrigationService.underwayPlanId(companyId));
    }

    @GetMapping(value={"/dosageStatVo"})
    public ActionResult<JSONObject> dosageStatVo(@RequestParam(value="ids") String ids, @RequestParam(value="rangTime", required=false, defaultValue="") String rangTime, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.irrigationService.dosageStatVo(ids, rangTime, companyId));
    }

    @GetMapping(value={"/queryDateByType"})
    public ActionResult<List<String>> queryDateByType(@RequestParam(value="type") Integer type, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.irrigationService.queryDateByType(type, companyId));
    }

    @GetMapping(value={"/imgListByTypeAndDate"})
    public ActionResult<List<ImageDataVo>> imgListByTypeAndDate(@RequestParam(value="type") Integer type, @RequestParam(value="date") String date, @RequestParam(value="companyId") Integer companyId) {
        return ActionResult.success((Object)this.irrigationService.imgListByTypeAndDate(type, date, companyId));
    }

    @GetMapping(value={"/irrigationMonitoring"})
    public ActionResult<List<IrrigationWarnVo>> irrigationMonitoring(@RequestParam(value="id") Long id) {
        return ActionResult.success((Object)this.irrigationService.irrigationMonitoring(id));
    }

    @GetMapping(value={"/mainEquipment"})
    public ActionResult<EquipmentVo> mainEquipment(@RequestParam(value="id") String id) {
        return ActionResult.success((Object)this.irrigationService.mainEquipment(id));
    }

    @PostMapping(value={"/addPlan"})
    public ActionResult<Void> addPlan(@RequestBody JSONObject json) {
        String id = json.getString("id");
        Integer status = json.getInteger("status");
        if (StringUtil.isBlank((CharSequence)id) || status == null) {
            return ActionResult.success((String)MsgCode.GG103.get());
        }
        Integer count = this.irrigationService.addPlan(id, status);
        return count > 0 ? ActionResult.success((String)MsgCode.SU004.get()) : ActionResult.fail((String)MsgCode.GG102.get());
    }

    @GetMapping(value={"/getfieldInfoBi/{fieldId}"})
    public ActionResult<FieldVo> getfieldInfoBi(@PathVariable(value="fieldId") String fieldId) {
        return ActionResult.success((Object)this.irrigationService.selectById(fieldId));
    }

    @GetMapping(value={"/pondList"})
    public ActionResult<PondVO> pondList(@RequestParam(value="companyId") Integer companyId) {
        PondVO pond = this.irrigationService.pondList(companyId);
        return ActionResult.success((Object)pond);
    }

    @GetMapping(value={"/getWaterValves"})
    public ActionResult<List<WaterValveVO>> getWaterValves(@RequestParam(value="companyId") Integer companyId, @RequestParam(value="bindId", required=false) String bindId) {
        List list = this.irrigationService.getWaterValves(companyId, bindId);
        return ActionResult.success((Object)list);
    }

    @GetMapping(value={"/getWaterValveList"})
    public ActionResult<List<WaterValveVO>> getWaterValveList(@RequestParam(value="companyId") Integer companyId) {
        List list = this.irrigationService.getWaterValveList(companyId);
        return ActionResult.success((Object)list);
    }

    @GetMapping(value={"/getWaterDevices"})
    public ActionResult<List<WaterValveVO>> getWaterDevices(@RequestParam(value="companyId") Integer companyId, @RequestParam(value="deviceCode") String deviceCode) {
        List list = this.irrigationService.getWaterDevices(companyId, deviceCode);
        return ActionResult.success((Object)list);
    }

    @GetMapping(value={"/getFlowmeterValue"})
    public ActionResult<String> getFlowmeterValue(@RequestParam(value="code") String code) {
        String flowmeterValue = this.irrigationService.getFlowmeterValue(code);
        return ActionResult.success((String)MsgCode.SU000.get(), (Object)flowmeterValue);
    }

    public IrrigationDpController(IrrigationService irrigationService) {
        this.irrigationService = irrigationService;
    }
}

