/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.controller;

import com.shuxi.base.vo.ActionResult;
import com.shuxi.base.vo.MsgCode;
import com.shuxi.bean.ca.MqttWaterValveSendCase;
import com.shuxi.service.MqttClientService;
import com.shuxi.service.MqttMessageService;
import com.shuxi.util.HexStringUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mqtt"})
public class MqttClientController {
    private final MqttMessageService mqttMessageService;
    private final MqttClientService mqttClientService;

    @GetMapping(value={"/mqttTest"})
    public ActionResult mqttTest(@RequestParam(value="message") String message) {
        message = message.replace(" ", "");
        byte[] messageBytes = HexStringUtil.hexStringToBytes((String)message);
        this.mqttMessageService.sendToMqtt("topic_milldam", messageBytes);
        return ActionResult.success((String)"\u53d1\u9001\u6210\u529f");
    }

    @GetMapping(value={"/mqttSend"})
    public ActionResult mqttSend(MqttWaterValveSendCase mqttWaterValveSendCase) {
        this.mqttClientService.mqttSend(mqttWaterValveSendCase.getCode(), mqttWaterValveSendCase.getFunctionType(), mqttWaterValveSendCase.getUserId(), mqttWaterValveSendCase.getUserName(), mqttWaterValveSendCase.getCompanyId());
        return ActionResult.success((String)MsgCode.SU012.get());
    }

    @GetMapping(value={"/mqttSendWaterLevel"})
    public ActionResult mqttSendWaterLevel() {
        this.mqttClientService.mqttSendWaterLevels();
        return ActionResult.success((String)MsgCode.SU012.get());
    }

    @GetMapping(value={"/mqttSendFlowmeter"})
    public ActionResult mqttSendFlowmeter(@RequestParam(value="code") String code, @RequestParam(value="commandType") Integer commandType) {
        this.mqttClientService.mqttSendFlowmeter(code, commandType);
        return ActionResult.success((String)MsgCode.SU012.get());
    }

    public MqttClientController(MqttMessageService mqttMessageService, MqttClientService mqttClientService) {
        this.mqttMessageService = mqttMessageService;
        this.mqttClientService = mqttClientService;
    }
}

