/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.controller;

import com.shuxi.base.vo.ActionResult;
import com.shuxi.base.vo.MsgCode;
import com.shuxi.base.vo.PageListVO;
import com.shuxi.bean.ca.ProcessingRecordCase;
import com.shuxi.bean.entity.ProcessingBreedEntity;
import com.shuxi.bean.vo.ProcessingEnvironmentVo;
import com.shuxi.bean.vo.ProcessingHistoricalTrendVo;
import com.shuxi.bean.vo.ProcessingRecordVo;
import com.shuxi.service.ProcessingCtlService;
import com.shuxi.service.ProcessingRecordService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processing"})
public class ProcessingRecordController {
    @Autowired
    private ProcessingRecordService processingRecordService;
    @Autowired
    private ProcessingCtlService processingCtlService;

    @GetMapping(value={"/processingBreedList"})
    public ActionResult<List<ProcessingBreedEntity>> processingBreedList(@RequestParam(value="companyId") Integer companyId) {
        List list = this.processingRecordService.processingBreedList(companyId);
        return ActionResult.success((Object)list);
    }

    @GetMapping(value={"/processingRecordList"})
    public ActionResult<PageListVO<ProcessingRecordVo>> processingRecordList(ProcessingRecordCase processingRecordCase) {
        PageListVO pageListVO = this.processingRecordService.processingRecordList(processingRecordCase);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/processingRecordAdd"})
    public ActionResult processingRecordAdd(@RequestBody ProcessingRecordCase processingRecordCase) {
        this.processingRecordService.processingRecordAdd(processingRecordCase);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @PostMapping(value={"/processingRecordUpdate"})
    public ActionResult processingRecordUpdate(@RequestBody ProcessingRecordCase processingRecordCase) {
        this.processingRecordService.processingRecordUpdate(processingRecordCase);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @GetMapping(value={"/processingRecordDetail/{id}"})
    public ActionResult<ProcessingRecordVo> processingRecordDetail(@PathVariable(value="id") String id) {
        ProcessingRecordVo processingRecord = this.processingRecordService.processingRecordDetail(id);
        return ActionResult.success((Object)processingRecord);
    }

    @PostMapping(value={"/processingRecordDelete"})
    public ActionResult processingRecordDelete(@RequestBody ProcessingRecordCase processingRecordCase) {
        if (StringUtils.isBlank((CharSequence)processingRecordCase.getIds())) {
            return ActionResult.fail((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5220\u9664\u7684\u52a0\u5de5\u8bb0\u5f55");
        }
        this.processingRecordService.processingRecordDelete(processingRecordCase.getIds());
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @GetMapping(value={"/processingRecordCharts"})
    public ActionResult<List<List<Object>>> processingRecordCharts(@RequestParam(value="companyId") Integer companyId) {
        List list = this.processingRecordService.processingRecordCharts(companyId);
        return ActionResult.success((Object)list);
    }

    @GetMapping(value={"/realTimeEnvironment"})
    public ActionResult<ProcessingEnvironmentVo> realTimeEnvironment(@RequestParam(value="companyId") Integer companyId, @RequestParam(value="ctlName") String ctlName) {
        ProcessingEnvironmentVo processingEnvironmentVo = this.processingCtlService.realTimeEnvironment(companyId, ctlName);
        return ActionResult.success((Object)processingEnvironmentVo);
    }

    @GetMapping(value={"/historicalTrend"})
    public ActionResult<ProcessingHistoricalTrendVo> historicalTrend(@RequestParam(value="companyId") Integer companyId, @RequestParam(value="ctlName") String ctlName, @RequestParam(value="dataTime") String dataTime) {
        ProcessingHistoricalTrendVo processingHistoricalTrendVo = this.processingCtlService.historicalTrend(companyId, ctlName, dataTime);
        return ActionResult.success((Object)processingHistoricalTrendVo);
    }

    @GetMapping(value={"/windSpeedMonitoring"})
    public ActionResult<ProcessingHistoricalTrendVo> windSpeedMonitoring(@RequestParam(value="companyId") Integer companyId, @RequestParam(value="ctlName") String ctlName, @RequestParam(value="dataTime") String dataTime) {
        ProcessingHistoricalTrendVo processingHistoricalTrendVo = this.processingCtlService.windSpeedMonitoring(companyId, ctlName, dataTime);
        return ActionResult.success((Object)processingHistoricalTrendVo);
    }
}

