/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.controller;

import com.shuxi.base.vo.ActionResult;
import com.shuxi.base.vo.PageListVO;
import com.shuxi.bean.vo.AddressKrmVo;
import com.shuxi.bean.vo.DeviceCountVo;
import com.shuxi.bean.vo.DeviceInfoVo;
import com.shuxi.bean.vo.TrackInfoVo;
import com.shuxi.bean.vo.WorkInfoVo;
import com.shuxi.bean.vo.WorkQueryVo;
import com.shuxi.service.TransplanterService;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/transplant"})
public class TransplantApiController {
    private final TransplanterService transplanterService;

    @GetMapping(value={"/getToken"})
    public ActionResult getToken() {
        String token = this.transplanterService.getToken();
        return ActionResult.success((String)token);
    }

    @GetMapping(value={"/queryTrackList"})
    public ActionResult<List<TrackInfoVo>> queryTrackList(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        List list = this.transplanterService.queryTrackList(startTime, endTime);
        return ActionResult.success((Object)list);
    }

    @GetMapping(value={"/queryTrackDetail"})
    public ActionResult<List<TrackInfoVo>> queryTrackDetail() {
        List trackInfoVo = this.transplanterService.queryTrackDetail();
        return ActionResult.success((Object)trackInfoVo);
    }

    @GetMapping(value={"/queryDeviceList"})
    public ActionResult<PageListVO<DeviceInfoVo>> queryDeviceList(@RequestParam(value="page") Integer page, @RequestParam(value="limit") Integer limit) {
        PageListVO pageListVO = this.transplanterService.queryDeviceList(page, limit);
        return ActionResult.success((Object)pageListVO);
    }

    @GetMapping(value={"/queryDeviceDetail"})
    public ActionResult<DeviceInfoVo> queryDeviceDetail(@RequestParam(value="sn") String sn) {
        return ActionResult.success((Object)this.transplanterService.queryDeviceDetail(sn));
    }

    @GetMapping(value={"/queryDeviceCount"})
    public ActionResult<DeviceCountVo> queryDeviceCount() {
        return ActionResult.success((Object)this.transplanterService.queryDeviceCount());
    }

    @GetMapping(value={"/queryWorkInfoList"})
    public ActionResult<PageListVO<WorkInfoVo>> queryWorkInfoList(WorkQueryVo queryVo) {
        return ActionResult.success((Object)this.transplanterService.queryWorkInfoList(queryVo));
    }

    @GetMapping(value={"/queryWorkInfoDetailList"})
    public ActionResult<PageListVO<WorkInfoVo>> queryWorkInfoDetailList(WorkQueryVo queryVo) {
        return ActionResult.success((Object)this.transplanterService.queryWorkInfoDetailList(queryVo));
    }

    @GetMapping(value={"/queryAddressByKEM"})
    public ActionResult<List<AddressKrmVo>> queryAddressByKEM(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        List list = this.transplanterService.queryAddressByKEM(startTime, endTime);
        return ActionResult.success((Object)list);
    }

    public TransplantApiController(TransplanterService transplanterService) {
        this.transplanterService = transplanterService;
    }
}

