/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.controller;

import com.shuxi.base.vo.ActionResult;
import com.shuxi.bean.bo.WaterLevelValveUnionBo;
import com.shuxi.bean.vo.WaterLevelValveUnionVo;
import com.shuxi.service.WaterLevelService;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/waterLevel"})
public class WaterLevelController {
    private final WaterLevelService waterLevelService;

    @GetMapping(value={"/getWaterLevelHeight"})
    public ActionResult<Float> getWaterLevelHeight(@RequestParam(value="companyId") Integer companyId, @RequestParam(value="deviceNo") String deviceNo) {
        Float height = this.waterLevelService.getWaterLevelHeight(companyId, deviceNo);
        return ActionResult.success((String)"success", (Object)height);
    }

    @PostMapping(value={"/addUnionConfig"})
    public ActionResult<Boolean> addUnionConfig(@RequestBody List<WaterLevelValveUnionBo> waterLevelValveUnionBoList) {
        boolean b = this.waterLevelService.addUnionConfig(waterLevelValveUnionBoList);
        return ActionResult.success((String)"success", (Object)b);
    }

    @GetMapping(value={"/getUnionConfig"})
    public ActionResult<List<WaterLevelValveUnionVo>> getUnionConfig(@RequestParam(value="companyId") Integer companyId, @RequestParam(value="deviceNo") String deviceNo) {
        List configList = this.waterLevelService.getUnionConfig(companyId, deviceNo);
        return ActionResult.success((String)"success", (Object)configList);
    }

    @PostMapping(value={"/deleteUnionConfigs"})
    public ActionResult<Boolean> deleteUnionConfigs(@RequestBody List<Long> configIdLis) {
        boolean b = this.waterLevelService.deleteUnionConfigs(configIdLis);
        return ActionResult.success((String)"success", (Object)b);
    }

    public WaterLevelController(WaterLevelService waterLevelService) {
        this.waterLevelService = waterLevelService;
    }
}

