/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.shuxi.base.vo.ActionResult;
import com.shuxi.bean.bo.WaterLevelCorrectBo;
import com.shuxi.bean.bo.WaterLevelDeviceBo;
import com.shuxi.bean.entity.WaterLevelDevice;
import com.shuxi.bean.vo.FieldVo;
import com.shuxi.bean.vo.WaterLevelDeviceVo;
import com.shuxi.bean.vo.WaterLevelVo;
import com.shuxi.mapper.IrrigationMapper;
import com.shuxi.service.WaterLevelDeviceService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/dp/waterLevelDevice"})
public class WaterLevelDeviceController {
    private final IrrigationMapper irrigationMapper;
    private final WaterLevelDeviceService waterLevelDeviceService;

    @GetMapping(value={"/list"})
    public ActionResult<List<WaterLevelDevice>> getWaterLevelDeviceInfoList() {
        return ActionResult.success((Object)this.waterLevelDeviceService.getWaterLevelDeviceInfoList());
    }

    @GetMapping(value={"/getWaterLevelInfo"})
    public ActionResult<WaterLevelVo> getWaterLevelInfo(@RequestParam(value="id") String id, @RequestParam(value="companyId") String companyId) {
        List waterLevelInfo = this.waterLevelDeviceService.getWaterLevelInfo(id, companyId, 1);
        WaterLevelVo waterLevelVo = null;
        if (!waterLevelInfo.isEmpty() && StringUtils.isNotBlank((String)(waterLevelVo = (WaterLevelVo)waterLevelInfo.get(0)).getCalcHeight())) {
            waterLevelVo.setCalcHeight(new BigDecimal(waterLevelVo.getCalcHeight()).setScale(2, 4).toPlainString());
        }
        return ActionResult.success(waterLevelVo);
    }

    @GetMapping(value={"/getDetailById"})
    public ActionResult<List<WaterLevelDeviceVo>> getDetailById(@RequestParam(value="fieldId") String fieldId, @RequestParam(value="companyId") String companyId, @RequestParam(value="id") String id) {
        return ActionResult.success((Object)this.waterLevelDeviceService.getDetailById(fieldId, companyId, id));
    }

    @GetMapping(value={"/getOne"})
    public ActionResult<WaterLevelDevice> getWaterLevelDeviceInfo(@RequestParam(value="id") String id) {
        return ActionResult.success((Object)this.waterLevelDeviceService.getWaterLevelDeviceInfo(id));
    }

    @DeleteMapping(value={"/delete"})
    public ActionResult<Integer> deleteWaterLevelDevice(@RequestParam(value="id") String id) {
        return ActionResult.success((Object)this.waterLevelDeviceService.deleteWaterLevelDevice(id));
    }

    @PutMapping(value={"/update"})
    public ActionResult<Integer> updateWaterLevelDevice(@RequestBody WaterLevelDeviceBo entity) {
        return ActionResult.success((Object)this.waterLevelDeviceService.updateWaterLevelDevice(entity));
    }

    @PostMapping(value={"/insert"})
    public ActionResult<Integer> insertWaterLevelDevice(@RequestBody WaterLevelDeviceBo entity) {
        if (entity.getCompanyId() != null && StrUtil.isNotBlank((CharSequence)entity.getIdFour())) {
            List list = this.irrigationMapper.getDeviceLevelList(entity.getCompanyId(), entity.getIdFour());
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                return ActionResult.fail((Integer)400, (String)("\u8be5\u8bbe\u5907\u53f7\u5df2\u5728 " + ((FieldVo)list.get(0)).getFieldName() + " \u7530\u5757\u5b58\u5728!"));
            }
            return ActionResult.success((String)String.valueOf(this.waterLevelDeviceService.insertWaterLevelDevice(entity)));
        }
        return ActionResult.fail((String)"\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574!");
    }

    @PutMapping(value={"/correctWaterLevel"})
    public ActionResult<Boolean> correctWaterLevel(@RequestBody WaterLevelCorrectBo correctBo) {
        return ActionResult.success((Object)this.waterLevelDeviceService.correctWaterLevel(correctBo));
    }

    public WaterLevelDeviceController(IrrigationMapper irrigationMapper, WaterLevelDeviceService waterLevelDeviceService) {
        this.irrigationMapper = irrigationMapper;
        this.waterLevelDeviceService = waterLevelDeviceService;
    }
}

