/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.handler;

import com.shuxi.bean.entity.FlowmeterLogEntity;
import com.shuxi.bean.entity.FlowmeterPumpCommandEntity;
import com.shuxi.mapper.FlowmeterLogMapper;
import com.shuxi.mapper.FlowmeterPumpCommandMapper;
import com.shuxi.mapper.MilldamMapper;
import com.shuxi.util.BigDecimalUtils;
import com.shuxi.util.DateUtils;
import com.shuxi.util.IdGenerator;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class FlowmeterMqttCallbackHandler {
    private static final String thCompanyId = "6597";
    private final MilldamMapper milldamMapper;
    private final FlowmeterLogMapper flowmeterLogMapper;
    private final FlowmeterPumpCommandMapper flowmeterPumpCommandMapper;

    public void handleFlowmeter(String[] strings) {
        String idFour = strings[0];
        Integer codeType = 3;
        String code = this.milldamMapper.getCodeByIdFourAndCodeType(idFour, codeType, thCompanyId);
        FlowmeterPumpCommandEntity flowmeterPumpCommandEntity = this.flowmeterPumpCommandMapper.selectByCtlCode(code, Integer.valueOf(2));
        String coefficient = flowmeterPumpCommandEntity.getCoefficient();
        String ctlVolume = "";
        String numOne = String.valueOf(Integer.parseInt(strings[3] + strings[4] + strings[5] + strings[6], 16));
        String numTwo = String.valueOf(Integer.parseInt(strings[7] + strings[8], 16));
        String numDecimal = BigDecimalUtils.div((String)numTwo, (String)"100", (int)2);
        ctlVolume = BigDecimalUtils.add((String)numOne, (String)numDecimal, (int)2);
        ctlVolume = BigDecimalUtils.mul((String)ctlVolume, (String)coefficient).stripTrailingZeros().toString();
        FlowmeterLogEntity flowmeterLogEntity = new FlowmeterLogEntity();
        flowmeterLogEntity.setId(String.valueOf(IdGenerator.get((IdGenerator.IdBizType)IdGenerator.IdBizType.ID)));
        flowmeterLogEntity.setCreateTime(DateUtils.dateToLocalDateTime((Date)new Date()));
        flowmeterLogEntity.setCtlCode(code);
        flowmeterLogEntity.setCtlVolume(ctlVolume);
        this.flowmeterLogMapper.insert((Object)flowmeterLogEntity);
    }

    public FlowmeterMqttCallbackHandler(MilldamMapper milldamMapper, FlowmeterLogMapper flowmeterLogMapper, FlowmeterPumpCommandMapper flowmeterPumpCommandMapper) {
        this.milldamMapper = milldamMapper;
        this.flowmeterLogMapper = flowmeterLogMapper;
        this.flowmeterPumpCommandMapper = flowmeterPumpCommandMapper;
    }
}

