/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.handler;

import com.shuxi.handler.FlowmeterMqttCallbackHandler;
import com.shuxi.handler.MqttHandler;
import com.shuxi.handler.MqttTopicMsgHandler;
import com.shuxi.handler.PumpMqttCallbackHandler;
import com.shuxi.handler.WaterLevelMqttCallbackHandler;
import com.shuxi.handler.WaterValveMqttCallbackHandler;
import com.shuxi.mapper.MilldamMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MqttCallbackHandler
implements MqttTopicMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(MqttCallbackHandler.class);
    @Value(value="${spring.mqtt.topic}")
    private String topicName;
    private static final String thCompanyId = "6597";
    private final MilldamMapper milldamMapper;
    private final WaterLevelMqttCallbackHandler waterLevelMqttCallbackHandler;
    private final WaterValveMqttCallbackHandler waterValveMqttCallbackHandler;
    private final FlowmeterMqttCallbackHandler flowmeterMqttCallbackHandler;
    private final PumpMqttCallbackHandler pumpMqttCallbackHandler;

    @MqttHandler(topic="topic_milldam")
    public void handle(String topic, String payload) {
        if (this.topicName.equals(topic)) {
            String[] strings = payload.split(" ");
            String idFour = "";
            String codeType = "";
            if ("42".equals(strings[0]) && 12 == strings.length) {
                idFour = strings[5];
                codeType = this.milldamMapper.selectTypeByIdFour(idFour, thCompanyId);
            }
            if (11 == strings.length && !"42".equals(strings[0])) {
                codeType = "3";
            }
            if ("9".equals(codeType)) {
                this.waterLevelMqttCallbackHandler.handleWaterLevel(payload, strings);
            }
            if ("7".equals(codeType) || "8".equals(codeType)) {
                this.waterValveMqttCallbackHandler.handleCtl(strings);
            }
            if ("3".equals(codeType)) {
                this.flowmeterMqttCallbackHandler.handleFlowmeter(strings);
            }
            if ("5".equals(codeType)) {
                this.pumpMqttCallbackHandler.handlePump(strings);
            }
        }
    }

    public MqttCallbackHandler(MilldamMapper milldamMapper, WaterLevelMqttCallbackHandler waterLevelMqttCallbackHandler, WaterValveMqttCallbackHandler waterValveMqttCallbackHandler, FlowmeterMqttCallbackHandler flowmeterMqttCallbackHandler, PumpMqttCallbackHandler pumpMqttCallbackHandler) {
        this.milldamMapper = milldamMapper;
        this.waterLevelMqttCallbackHandler = waterLevelMqttCallbackHandler;
        this.waterValveMqttCallbackHandler = waterValveMqttCallbackHandler;
        this.flowmeterMqttCallbackHandler = flowmeterMqttCallbackHandler;
        this.pumpMqttCallbackHandler = pumpMqttCallbackHandler;
    }
}

