/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.handler;

import com.shuxi.bean.entity.WaterLevel;
import com.shuxi.bean.entity.WaterLevelDevice;
import com.shuxi.common.component.AsyncBlockWaiter;
import com.shuxi.mapper.WaterLevelMapper;
import com.shuxi.service.WaterLevelService;
import com.shuxi.util.HexStringUtil;
import com.shuxi.util.IdGenerator;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class WaterLevelMqttCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(WaterLevelMqttCallbackHandler.class);
    @Resource
    private WaterLevelMapper waterLevelMapper;
    @Resource
    private WaterLevelService waterLevelService;
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private AsyncBlockWaiter asyncBlockWaiter;
    @Resource(name="taskExecutor")
    private ThreadPoolTaskExecutor executor;

    public void handleWaterLevel(String payload, String[] strings) {
        if (!"42".equalsIgnoreCase(strings[0]) || !"46".equalsIgnoreCase(strings[1])) {
            log.info("------------------------ WaterLevelMqttCallbackHandler\u63a5\u6536\u62a5\u6587\u6570\u636e\u975e4246\u5f00\u5934\uff0cpayload={}", (Object)payload);
            return;
        }
        if (strings.length < 12) {
            log.error("========================== \u6c34\u4f4d\u4eea\u62a5\u6587\u957f\u5ea6\u592a\u77ed\uff0cpayload={}", (Object)payload);
            return;
        }
        String verifyOne = HexStringUtil.hexSumString((String)payload.substring(0, payload.length() - 2));
        if (!strings[11].equalsIgnoreCase(verifyOne)) {
            log.error("========================== \u6c34\u4f4d\u4eea\u6821\u9a8c\u548c\u5931\u8d25\uff0cpayload={}", (Object)payload);
            return;
        }
        log.info("------------------------ \u5f00\u59cb\u5904\u7406\u6c34\u4f4d\u4eea\u62a5\u6587\u6570\u636e\uff0cpayload={}", (Object)payload);
        log.info("------------------------ \u5f00\u59cb\u5904\u7406\u6c34\u4f4d\u4eea\u62a5\u6587\u6570\u636e, handleWaterLevel\uff0cstrings={}", (Object[])strings);
        String code = this.waterLevelMapper.getCodeByIdFour(strings[5]);
        WaterLevelDevice waterLevelDevice = this.waterLevelMapper.getWaterLevelDevByNo(code);
        int value = Integer.parseInt(strings[9] + strings[10], 16);
        if (this.redisTemplate.opsForHash().get((Object)"water_level_is_install_config", (Object)code) != null) {
            this.redisTemplate.opsForHash().delete((Object)"water_level_is_install_config", new Object[]{code});
            if (waterLevelDevice != null) {
                this.waterLevelMapper.updatePoleAngleScaleById(waterLevelDevice.getId(), value);
            }
        } else {
            float total = 4096.0f;
            float b = (float)value % total * 360.0f / total;
            float height = 0.0f;
            if (waterLevelDevice != null && waterLevelDevice.getPoleAngleScale() != null) {
                Float c = waterLevelDevice.getPoleLen();
                float a = waterLevelDevice.getPoleAngleScale().floatValue() % total * 360.0f / total;
                Float h = waterLevelDevice.getHeightOffset();
                Float f = waterLevelDevice.getBallOffset();
                height = (float)((double)c.floatValue() * Math.cos(Math.toRadians(a)) + (double)h.floatValue() - (double)c.floatValue() * Math.cos(Math.toRadians(b)) + (double)(f.floatValue() * (180.0f - b)));
                this.asyncBlockWaiter.notice(code, (Object)Float.valueOf(height));
                float height2 = height;
                this.executor.execute(() -> this.waterLevelService.unionRun(waterLevelDevice.getCompanyId(), waterLevelDevice.getDeviceNo(), height2));
            }
            WaterLevel waterLevel = new WaterLevel();
            waterLevel.setId(Long.valueOf(IdGenerator.get((IdGenerator.IdBizType)IdGenerator.IdBizType.ID)));
            waterLevel.setDeviceId(waterLevelDevice == null ? null : waterLevelDevice.getId());
            waterLevel.setDeviceNo(code);
            waterLevel.setCompanyId(waterLevelDevice == null ? null : waterLevelDevice.getCompanyId());
            waterLevel.setRecvData(payload);
            waterLevel.setCalcAngle(Float.valueOf(b));
            waterLevel.setCalcHeight(Float.valueOf(height));
            waterLevel.setCalcVars(this.joinVars(waterLevelDevice));
            waterLevel.setCreateTime(new Date());
            this.waterLevelMapper.insert((Object)waterLevel);
        }
    }

    private String joinVars(WaterLevelDevice waterLevelDevice) {
        if (waterLevelDevice == null) {
            return null;
        }
        CharSequence[] array = new String[]{"poleLen:" + waterLevelDevice.getPoleLen(), "poleAngleScale:" + waterLevelDevice.getPoleAngleScale(), "heightOffset:" + waterLevelDevice.getHeightOffset(), "ballOffset:" + waterLevelDevice.getBallOffset()};
        return String.join((CharSequence)",", array);
    }
}

