/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.shuxi.bean.entity.FieldUserCompanyEntity;
import com.shuxi.bean.entity.FieldWorkEntity;
import com.shuxi.bean.entity.TrackInfoHistoryEntity;
import com.shuxi.bean.vo.AreaTotalVo;
import com.shuxi.bean.vo.FieldReportChartVo;
import com.shuxi.bean.vo.FieldReportValueVo;
import com.shuxi.bean.vo.FieldReportVo;
import com.shuxi.bean.vo.FieldVo;
import com.shuxi.bean.vo.FieldWorkInfoVo;
import com.shuxi.bean.vo.FieldWorkProgressVo;
import com.shuxi.bean.vo.MachineryVo;
import com.shuxi.bean.vo.SoilFertilityVo;
import com.shuxi.bean.vo.TrackFertilizationVo;
import com.shuxi.bean.vo.TrackInfoVo;
import com.shuxi.bean.vo.TransplantChartVo;
import com.shuxi.bean.vo.WorkChartVo;
import com.shuxi.bean.vo.WorkDetailChartVo;
import com.shuxi.bean.vo.WorkOverviewVo;
import com.shuxi.bean.vo.WorkTimeDetailVo;
import com.shuxi.bean.vo.WorkTimeHistoryVo;
import com.shuxi.mapper.AgriculturalMachineryMapper;
import com.shuxi.mapper.FieldWorkMapper;
import com.shuxi.service.AgriculturalMachineryService;
import com.shuxi.service.ScheduledService;
import com.shuxi.service.TransplanterService;
import com.shuxi.util.BigDecimalUtils;
import com.shuxi.util.DataException;
import com.shuxi.util.JsonUtil;
import com.shuxi.util.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AgriculturalMachineryServiceImpl
implements AgriculturalMachineryService {
    private static final Logger log = LoggerFactory.getLogger(AgriculturalMachineryServiceImpl.class);
    private final AgriculturalMachineryMapper agriculturalMachineryMapper;
    private final TransplanterService transplanterService;
    private final ScheduledService scheduledService;
    private final FieldWorkMapper fieldWorkMapper;

    public WorkChartVo queryWorkProgress(Integer companyId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        WorkChartVo chartVo = new WorkChartVo();
        List<Object> xData = Lists.newArrayList();
        List<Object> yData = Lists.newArrayList();
        List fieldList = this.fieldWorkMapper.queryWorkProgress(companyId);
        if (StringUtil.isNotEmpty((Collection)fieldList)) {
            xData = fieldList.stream().map(t -> dateFormat.format(t.getWorkDate())).collect(Collectors.toList());
            yData = fieldList.stream().map(FieldWorkProgressVo::getArea).collect(Collectors.toList());
        }
        chartVo.setXData((List)xData);
        chartVo.setYData((List)yData);
        return chartVo;
    }

    public TransplantChartVo queryTransplantHistory(Integer companyId, String fieldId, String beginTime, String endTime) {
        try {
            beginTime = beginTime + ":00";
            endTime = endTime + ":59";
            TransplantChartVo chartVo = new TransplantChartVo();
            WorkOverviewVo workOverviewVo = new WorkOverviewVo();
            WorkDetailChartVo workDetailChartVo = new WorkDetailChartVo();
            ArrayList soil = Lists.newArrayList();
            List machineryList = Lists.newArrayList();
            FieldVo fieldVo = this.agriculturalMachineryMapper.queryField(fieldId);
            List fieldWorkEntityList = this.fieldWorkMapper.queryListByFieldIdAndTime(companyId, fieldId, beginTime, endTime);
            if (StringUtil.isNotNull((Object)fieldVo) && StringUtil.isNotEmpty((Collection)fieldWorkEntityList)) {
                List transplantAll;
                List historyEntityList;
                BigDecimal workArea = this.fieldWorkMapper.queryWorkAreaByFieldId(companyId, fieldId, beginTime, endTime);
                workOverviewVo.setFieldArea(fieldVo.getArea());
                workOverviewVo.setAccumulatedArea(workArea);
                BigDecimal repetitiveArea = workArea.subtract(fieldVo.getArea());
                if (repetitiveArea.compareTo(BigDecimal.ZERO) > 0) {
                    workOverviewVo.setRepetitiveArea(repetitiveArea);
                } else {
                    workOverviewVo.setRepetitiveArea(BigDecimal.ZERO);
                }
                if (workArea.compareTo(fieldVo.getArea()) > 0) {
                    workOverviewVo.setEffectiveArea(fieldVo.getArea());
                    workOverviewVo.setOmittedArea(BigDecimal.ZERO);
                } else {
                    workOverviewVo.setEffectiveArea(workArea);
                    workOverviewVo.setOmittedArea(fieldVo.getArea().subtract(workArea));
                }
                List workDetailCharts = this.agriculturalMachineryMapper.queryWorkDetails(companyId, fieldVo.getGeometry(), beginTime, endTime);
                workDetailChartVo = this.setWorkDetailChartVo(workDetailCharts);
                if (StringUtil.isNotNull((Object)workDetailChartVo)) {
                    Duration duration = this.getTimeDifferenceDuration((FieldWorkEntity)fieldWorkEntityList.get(0));
                    long minutes = duration.toMinutes();
                    workDetailChartVo.setDurationRt(BigDecimal.valueOf(minutes));
                }
                if (StringUtil.isNotEmpty((Collection)(historyEntityList = this.agriculturalMachineryMapper.queryByGeometry(companyId, fieldVo.getGeometry(), beginTime, endTime)))) {
                    for (TrackInfoHistoryEntity entity : historyEntityList) {
                        SoilFertilityVo fertilityVo = (SoilFertilityVo)JsonUtil.getJsonToBean((Object)entity, SoilFertilityVo.class);
                        BigDecimal D1104 = entity.getD1104() == null ? BigDecimal.ZERO : entity.getD1104();
                        BigDecimal fertility = new BigDecimal(0.02).multiply(D1104).setScale(2, 4);
                        fertilityVo.setFertility(fertility.stripTrailingZeros().toPlainString());
                        BigDecimal fertilityQuantity = new BigDecimal("20").subtract(new BigDecimal(0.02).multiply(D1104)).setScale(2, 4);
                        fertilityVo.setFertilityQuantity(fertilityQuantity.stripTrailingZeros().toPlainString());
                        soil.add(fertilityVo);
                    }
                }
                if (StringUtil.isNotEmpty((Collection)(transplantAll = this.agriculturalMachineryMapper.queryTransplantAll(companyId, beginTime, endTime)))) {
                    machineryList = JsonUtil.getJsonToList((Object)historyEntityList, MachineryVo.class);
                }
            }
            chartVo.setWorkDetailChartVo(workDetailChartVo);
            chartVo.setWorkOverviewVo(workOverviewVo);
            chartVo.setSoil((List)soil);
            chartVo.setMachinery(machineryList);
            return chartVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u667a\u6167\u519c\u673a-\u6570\u636e\u5927\u5c4f\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new DataException("\u667a\u6167\u519c\u673a-\u6570\u636e\u5927\u5c4f\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    private WorkDetailChartVo setWorkDetailChartVo(List<WorkDetailChartVo> workDetailCharts) {
        WorkDetailChartVo workDetailChartVo = new WorkDetailChartVo();
        Integer d1101Count = 0;
        Integer d1102Count = 0;
        Integer d1103Count = 0;
        Integer d1104Count = 0;
        Integer speedCount = 0;
        Integer mileageRtCount = 0;
        Integer durationRtCount = 0;
        BigDecimal d1101 = new BigDecimal("0");
        BigDecimal d1102 = new BigDecimal("0");
        BigDecimal d1103 = new BigDecimal("0");
        BigDecimal d1104 = new BigDecimal("0");
        BigDecimal speed = new BigDecimal("0");
        BigDecimal mileageRt = new BigDecimal("0");
        BigDecimal durationRt = new BigDecimal("0");
        for (WorkDetailChartVo workDetailChart : workDetailCharts) {
            Integer n;
            Integer n2;
            if (workDetailChart.getD1101() != null && workDetailChart.getD1101().compareTo(new BigDecimal("0")) > 0) {
                d1101 = d1101.add(workDetailChart.getD1101());
                n2 = d1101Count;
                n = d1101Count = Integer.valueOf(d1101Count + 1);
            }
            if (workDetailChart.getD1102() != null && workDetailChart.getD1102().compareTo(new BigDecimal("0")) > 0) {
                d1102 = d1102.add(workDetailChart.getD1102());
                n2 = d1102Count;
                n = d1102Count = Integer.valueOf(d1102Count + 1);
            }
            if (workDetailChart.getD1103() != null && workDetailChart.getD1103().compareTo(new BigDecimal("0")) > 0) {
                d1103 = d1103.add(workDetailChart.getD1103());
                n2 = d1103Count;
                n = d1103Count = Integer.valueOf(d1103Count + 1);
            }
            if (workDetailChart.getD1104() != null && workDetailChart.getD1104().compareTo(new BigDecimal("0")) > 0) {
                d1104 = d1104.add(workDetailChart.getD1104());
                n2 = d1104Count;
                n = d1104Count = Integer.valueOf(d1104Count + 1);
            }
            if (workDetailChart.getSpeed() != null && workDetailChart.getSpeed().compareTo(new BigDecimal("0")) > 0) {
                speed = speed.add(workDetailChart.getSpeed());
                n2 = speedCount;
                n = speedCount = Integer.valueOf(speedCount + 1);
            }
            if (workDetailChart.getMileageRt() != null && workDetailChart.getMileageRt().compareTo(new BigDecimal("0")) > 0) {
                mileageRt = mileageRt.add(workDetailChart.getMileageRt());
                n2 = mileageRtCount;
                n = mileageRtCount = Integer.valueOf(mileageRtCount + 1);
            }
            if (workDetailChart.getDurationRt() == null || workDetailChart.getDurationRt().compareTo(new BigDecimal("0")) <= 0) continue;
            durationRt = durationRt.add(workDetailChart.getDurationRt());
            n2 = durationRtCount;
            n = durationRtCount = Integer.valueOf(durationRtCount + 1);
        }
        BigDecimal zero = new BigDecimal("0");
        if (d1101Count > 0) {
            workDetailChartVo.setD1101(new BigDecimal(BigDecimalUtils.div((String)d1101.toString(), (String)String.valueOf(d1101Count), (int)2)));
        }
        if (d1101Count == 0) {
            workDetailChartVo.setD1101(zero);
        }
        if (d1102Count > 0) {
            workDetailChartVo.setD1102(new BigDecimal(BigDecimalUtils.div((String)d1102.toString(), (String)String.valueOf(d1102Count), (int)2)));
        }
        if (d1102Count == 0) {
            workDetailChartVo.setD1102(zero);
        }
        if (d1103Count > 0) {
            workDetailChartVo.setD1103(new BigDecimal(BigDecimalUtils.div((String)d1103.toString(), (String)String.valueOf(d1103Count), (int)2)));
        }
        if (d1103Count == 0) {
            workDetailChartVo.setD1103(zero);
        }
        if (d1104Count > 0) {
            workDetailChartVo.setD1104(new BigDecimal(BigDecimalUtils.div((String)d1104.toString(), (String)String.valueOf(d1104Count), (int)2)));
        }
        if (d1104Count == 0) {
            workDetailChartVo.setD1104(zero);
        }
        if (speedCount > 0) {
            workDetailChartVo.setSpeed(new BigDecimal(BigDecimalUtils.div((String)speed.toString(), (String)String.valueOf(speedCount), (int)2)));
        }
        if (speedCount == 0) {
            workDetailChartVo.setSpeed(zero);
        }
        if (mileageRtCount > 0) {
            workDetailChartVo.setMileageRt(new BigDecimal(BigDecimalUtils.div((String)mileageRt.toString(), (String)String.valueOf(mileageRtCount), (int)2)));
        }
        if (mileageRtCount == 0) {
            workDetailChartVo.setMileageRt(zero);
        }
        if (durationRtCount > 0) {
            workDetailChartVo.setDurationRt(new BigDecimal(BigDecimalUtils.div((String)durationRt.toString(), (String)String.valueOf(durationRtCount), (int)2)));
        }
        if (durationRtCount == 0) {
            workDetailChartVo.setDurationRt(zero);
        }
        return workDetailChartVo;
    }

    public TransplantChartVo queryTransplantByNow(Integer companyId, String fieldId) {
        try {
            TransplantChartVo chartVo = new TransplantChartVo();
            WorkDetailChartVo detailVo = new WorkDetailChartVo();
            WorkOverviewVo workOverviewVo = new WorkOverviewVo();
            ArrayList soil = Lists.newArrayList();
            List machineryList = Lists.newArrayList();
            List infoList = this.transplanterService.queryTrackDetail();
            FieldVo fieldVo = this.agriculturalMachineryMapper.queryField(fieldId);
            if (StringUtil.isNotEmpty((Collection)infoList)) {
                workOverviewVo.setFieldArea(fieldVo.getArea());
                TrackInfoVo trackInfoVo = (TrackInfoVo)infoList.get(0);
                String point = "{\"type\":\"Point\",\"coordinates\":[" + trackInfoVo.getLon() + "," + trackInfoVo.getLat() + "]}";
                String geometry = fieldVo.getGeometry();
                String flag = this.agriculturalMachineryMapper.queryPoint(point, geometry);
                if (StringUtil.isNotEmpty((String)flag) && "t".equals(flag)) {
                    TrackFertilizationVo details = trackInfoVo.getDetails();
                    detailVo.setD1101(details.getD1101());
                    detailVo.setD1102(details.getD1102());
                    detailVo.setD1104(details.getD1104());
                    detailVo.setD1103(details.getD1103());
                    detailVo.setSpeed(trackInfoVo.getSpeed());
                    detailVo.setMileageRt(new BigDecimal(trackInfoVo.getMileage_rt()));
                    BigDecimal timeValue = new BigDecimal(trackInfoVo.getDuration_rt() == null ? 0 : trackInfoVo.getDuration_rt());
                    detailVo.setDurationRt(timeValue.divide(new BigDecimal(60), RoundingMode.HALF_UP).setScale(2, 4));
                    SoilFertilityVo fertilityVo = (SoilFertilityVo)JsonUtil.getJsonToBean((Object)trackInfoVo, SoilFertilityVo.class);
                    BigDecimal D1104 = trackInfoVo.getDetails() == null ? BigDecimal.ZERO : trackInfoVo.getDetails().getD1104();
                    BigDecimal fertility = new BigDecimal(0.02).multiply(D1104).setScale(2, 4);
                    fertilityVo.setFertility(fertility.stripTrailingZeros().toPlainString());
                    BigDecimal fertilityQuantity = new BigDecimal("20").subtract(new BigDecimal(0.02).multiply(D1104)).setScale(2, 4);
                    fertilityVo.setFertilityQuantity(fertilityQuantity.stripTrailingZeros().toPlainString());
                    soil.add(fertilityVo);
                }
                machineryList = JsonUtil.getJsonToList((Object)infoList, MachineryVo.class);
            }
            chartVo.setWorkOverviewVo(workOverviewVo);
            chartVo.setWorkDetailChartVo(detailVo);
            chartVo.setSoil((List)soil);
            chartVo.setMachinery(machineryList);
            return chartVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u8f68\u8ff9\u5217\u8868\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new DataException("\u83b7\u53d6\u8f68\u8ff9\u5217\u8868\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01");
        }
    }

    public List<WorkTimeHistoryVo> queryWorkTimeList(Integer companyId, String fieldId) {
        ArrayList workList = Lists.newArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FieldWorkEntity::getFieldId, (Object)fieldId);
        queryWrapper.lambda().eq(FieldWorkEntity::getCompanyId, (Object)companyId);
        queryWrapper.lambda().orderByDesc(FieldWorkEntity::getArea);
        List fieldWorkEntityList = this.fieldWorkMapper.selectList((Wrapper)queryWrapper);
        if (StringUtil.isNotEmpty((Collection)fieldWorkEntityList)) {
            List<Object> dataList = Lists.newArrayList();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            dataList = fieldWorkEntityList.stream().map(t -> sdf.format(t.getBeginTime())).distinct().collect(Collectors.toList());
            for (String string : dataList) {
                WorkTimeHistoryVo historyVo = new WorkTimeHistoryVo();
                historyVo.setWorkDate(string);
                List filterList = fieldWorkEntityList.stream().filter(t -> str.equals(sdf.format(t.getBeginTime()))).collect(Collectors.toList());
                List detailVos = JsonUtil.getJsonToList(filterList, WorkTimeDetailVo.class);
                historyVo.setDetailVos(detailVos);
                workList.add(historyVo);
            }
        }
        return workList;
    }

    public FieldReportChartVo queryFieldReport(Integer companyId, String fieldId) {
        FieldReportChartVo chartVo = new FieldReportChartVo();
        FieldReportVo reportVo = this.agriculturalMachineryMapper.queryFieldReport(companyId, fieldId);
        if (StringUtil.isNotNull((Object)reportVo)) {
            String[] pieStr = reportVo.getPieChartLabels().replace("{", "").replace("}", "").split(",");
            chartVo.setNameList(Arrays.asList(pieStr));
            String[] percentStr = reportVo.getPieChartPercents().replace("{", "").replace("}", "").split(",");
            ArrayList values = Lists.newArrayList();
            if (percentStr.length > 0) {
                for (int i = 0; i < percentStr.length; ++i) {
                    FieldReportValueVo report = new FieldReportValueVo();
                    report.setName(pieStr[i]);
                    report.setValue(percentStr[i]);
                    values.add(report);
                }
            }
            chartVo.setValues((List)values);
            chartVo.setReportImgUrl(reportVo.getReportImgUrl());
            chartVo.setTotalArea(reportVo.getTotalArea());
        }
        return chartVo;
    }

    public AreaTotalVo queryAreaInfo(Integer companyId, Integer year) {
        AreaTotalVo areaTotalVo = new AreaTotalVo();
        BigDecimal totalArea = new BigDecimal(199);
        areaTotalVo.setTotalArea(totalArea);
        BigDecimal alreadyArea = BigDecimal.ZERO;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FieldWorkEntity::getCompanyId, (Object)companyId);
        if (year == null) {
            year = LocalDateTime.now().getYear();
        }
        LocalDateTime start = LocalDateTime.of((int)year, 1, 1, 0, 0);
        LocalDateTime end = LocalDateTime.of((int)year, 12, 31, 23, 59, 59);
        queryWrapper.lambda().between(FieldWorkEntity::getBeginTime, (Object)start, (Object)end);
        queryWrapper.lambda().orderByDesc(FieldWorkEntity::getArea);
        List workEntityList = this.fieldWorkMapper.selectList((Wrapper)queryWrapper);
        if (StringUtil.isNotEmpty((Collection)workEntityList)) {
            alreadyArea = workEntityList.stream().map(FieldWorkEntity::getArea).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
        }
        Integer userId = null;
        List companyList = this.agriculturalMachineryMapper.queryFieldUserAndCompany(companyId);
        if (StringUtil.isNotEmpty((Collection)companyList)) {
            FieldUserCompanyEntity companyEntity = (FieldUserCompanyEntity)companyList.get(0);
            userId = companyEntity.getUserId();
        }
        List fieldIds = this.agriculturalMachineryMapper.queryFiledByUserIdAndCompanyId(userId, companyId);
        log.info("\u592a\u548c\u519c\u573a\u7530\u5757id:" + fieldIds.toString());
        List fieldListVo = Lists.newArrayList();
        ArrayList fieldList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((Collection)fieldIds)) {
            fieldListVo = this.agriculturalMachineryMapper.queryFieldByIds(fieldIds);
        }
        if (StringUtil.isNotEmpty((Collection)fieldListVo)) {
            for (FieldVo fieldVo : fieldListVo) {
                FieldWorkInfoVo workInfoVo = new FieldWorkInfoVo();
                workInfoVo.setFieldId(fieldVo.getFieldId());
                workInfoVo.setArea(fieldVo.getArea());
                workInfoVo.setFieldName(fieldVo.getFieldName());
                List filterList = workEntityList.stream().filter(t -> fieldVo.getFieldId().equals(t.getFieldId())).collect(Collectors.toList());
                if (StringUtil.isNotEmpty(filterList)) {
                    BigDecimal fieldArea;
                    BigDecimal workArea = filterList.stream().map(t -> t.getArea()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal value = workArea.divide(fieldArea = fieldVo.getArea(), RoundingMode.HALF_UP).setScale(2, 4);
                    if (value.compareTo(BigDecimal.ZERO) > 0) {
                        workInfoVo.setStatus("0");
                    } else {
                        workInfoVo.setStatus("1");
                    }
                } else {
                    workInfoVo.setStatus("1");
                }
                fieldList.add(workInfoVo);
            }
        }
        if (companyId == 6628) {
            totalArea = alreadyArea;
            areaTotalVo.setTodoArea(BigDecimal.ZERO);
            areaTotalVo.setAlreadyArea(alreadyArea);
        } else if (alreadyArea.compareTo(totalArea) > 0) {
            areaTotalVo.setAlreadyArea(totalArea);
            areaTotalVo.setTodoArea(BigDecimal.ZERO);
        } else {
            areaTotalVo.setAlreadyArea(alreadyArea);
            areaTotalVo.setTodoArea(totalArea.subtract(alreadyArea));
        }
        areaTotalVo.setTotalArea(totalArea);
        areaTotalVo.setFieldList((List)fieldList);
        return areaTotalVo;
    }

    public List<FieldVo> queryFiledWorkByNow(Integer companyId) {
        ArrayList list = Lists.newArrayList();
        List infoList = this.transplanterService.queryTrackDetail();
        if (StringUtil.isNotEmpty((Collection)infoList)) {
            List fieldIds;
            FieldVo fieldVo;
            TrackInfoVo trackInfoVo = (TrackInfoVo)infoList.get(0);
            String point = "{\"type\":\"Point\",\"coordinates\":[" + trackInfoVo.getLon() + "," + trackInfoVo.getLat() + "]}";
            Integer userId = null;
            List companyList = this.agriculturalMachineryMapper.queryFieldUserAndCompany(companyId);
            if (StringUtil.isNotEmpty((Collection)companyList)) {
                FieldUserCompanyEntity companyEntity = (FieldUserCompanyEntity)companyList.get(0);
                userId = companyEntity.getUserId();
            }
            if (StringUtil.isNotNull((Object)(fieldVo = this.agriculturalMachineryMapper.queryFieldByTrackPoint(point, fieldIds = this.agriculturalMachineryMapper.queryFiledByUserIdAndCompanyId(userId, companyId))))) {
                list.add(fieldVo);
            }
        }
        return list;
    }

    public Duration getTimeDifferenceDuration(FieldWorkEntity entity) {
        if (entity.getBeginTime() == null || entity.getEndTime() == null) {
            return null;
        }
        Instant start = entity.getBeginTime().toInstant();
        Instant end = entity.getEndTime().toInstant();
        return Duration.between(start, end);
    }

    public AgriculturalMachineryServiceImpl(AgriculturalMachineryMapper agriculturalMachineryMapper, TransplanterService transplanterService, ScheduledService scheduledService, FieldWorkMapper fieldWorkMapper) {
        this.agriculturalMachineryMapper = agriculturalMachineryMapper;
        this.transplanterService = transplanterService;
        this.scheduledService = scheduledService;
        this.fieldWorkMapper = fieldWorkMapper;
    }
}

